/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;
import uk.ac.starlink.ast.gui.AstAxisLabels;
import uk.ac.starlink.ast.gui.ColourIcon;
import uk.ac.starlink.ast.gui.FontChangedEvent;
import uk.ac.starlink.ast.gui.FontChangedListener;
import uk.ac.starlink.ast.gui.FontControls;
import uk.ac.starlink.ast.gui.PlotControls;
import uk.ac.starlink.ast.gui.ScientificSpinner;
import uk.ac.starlink.ast.gui.Utilities;
import uk.ac.starlink.util.gui.GridBagLayouter;
import uk.ac.starlink.util.gui.SelectTextField;

public class AxisLabelControls
extends JPanel
implements PlotControls,
ChangeListener {
    protected AstAxisLabels astAxisLabels = null;
    protected JCheckBox xShowLabel = new JCheckBox();
    protected JCheckBox yShowLabel = new JCheckBox();
    protected SelectTextField xTextField = new SelectTextField();
    protected SelectTextField yTextField = new SelectTextField();
    protected ScientificSpinner xGapSpinner = null;
    protected ScientificSpinner yGapSpinner = null;
    protected SpinnerNumberModel xSpinnerModel = new SpinnerNumberModel(0.0, -0.5, 0.5, 0.005);
    protected SpinnerNumberModel ySpinnerModel = new SpinnerNumberModel(0.0, -0.5, 0.5, 0.005);
    protected JButton colourButton = new JButton();
    protected ColourIcon colourIcon = new ColourIcon(Color.black);
    protected FontControls fontControls = null;
    protected JComboBox xEdge = new JComboBox();
    protected JComboBox yEdge = new JComboBox();
    protected JCheckBox xUnits = new JCheckBox();
    protected JCheckBox yUnits = new JCheckBox();
    protected boolean inhibitXDocumentListener = false;
    protected boolean inhibitYDocumentListener = false;
    protected static String defaultTitle = "Axis labels properties:";
    protected static String defaultName = "Axis labels";
    static /* synthetic */ Class class$uk$ac$starlink$ast$gui$AstAxisLabels;

    public AxisLabelControls(AbstractPlotControlsModel astAxisLabels) {
        this.initUI();
        this.setAstAxisLabel((AstAxisLabels)astAxisLabels);
    }

    protected void initUI() {
        this.xEdge.addItem("BOTTOM");
        this.xEdge.addItem("TOP");
        this.yEdge.addItem("LEFT");
        this.yEdge.addItem("RIGHT");
        this.xShowLabel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisLabelControls.this.matchXShown();
            }
        });
        this.yShowLabel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisLabelControls.this.matchYShown();
            }
        });
        this.colourButton.setIcon(this.colourIcon);
        this.colourButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisLabelControls.this.chooseColour();
            }
        });
        Document doc = this.xTextField.getDocument();
        doc.addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                AxisLabelControls.this.matchXText();
            }

            public void insertUpdate(DocumentEvent e) {
                AxisLabelControls.this.matchXText();
            }

            public void removeUpdate(DocumentEvent e) {
                AxisLabelControls.this.matchXText();
            }
        });
        doc = this.yTextField.getDocument();
        doc.addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                AxisLabelControls.this.matchYText();
            }

            public void insertUpdate(DocumentEvent e) {
                AxisLabelControls.this.matchYText();
            }

            public void removeUpdate(DocumentEvent e) {
                AxisLabelControls.this.matchYText();
            }
        });
        this.xGapSpinner = new ScientificSpinner(this.xSpinnerModel);
        this.xGapSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AxisLabelControls.this.matchXGap();
            }
        });
        this.yGapSpinner = new ScientificSpinner(this.ySpinnerModel);
        this.yGapSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AxisLabelControls.this.matchYGap();
            }
        });
        this.xEdge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisLabelControls.this.matchXEdge();
            }
        });
        this.yEdge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisLabelControls.this.matchYEdge();
            }
        });
        this.xUnits.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisLabelControls.this.matchXUnits();
            }
        });
        this.yUnits.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisLabelControls.this.matchYUnits();
            }
        });
        GridBagLayouter layouter = Utilities.getGridBagLayouter(this);
        layouter.add("Show X:", false);
        layouter.add((Component)this.xShowLabel, true);
        layouter.add("X label:", false);
        layouter.add((Component)this.xTextField, true);
        layouter.add("Show Y:", false);
        layouter.add((Component)this.yShowLabel, true);
        layouter.add("Y label:", false);
        layouter.add((Component)this.yTextField, true);
        this.addFontControls(layouter);
        layouter.add("Colour:", false);
        layouter.add((Component)this.colourButton, false);
        layouter.eatLine();
        layouter.add("X gap:", false);
        layouter.add((Component)this.xGapSpinner, false);
        layouter.eatLine();
        layouter.add("Y gap:", false);
        layouter.add((Component)this.yGapSpinner, false);
        layouter.eatLine();
        layouter.add("X edge:", false);
        layouter.add((Component)this.xEdge, false);
        layouter.eatLine();
        layouter.add("Y edge:", false);
        layouter.add((Component)this.yEdge, false);
        layouter.eatLine();
        layouter.add("X units:", false);
        layouter.add((Component)this.xUnits, true);
        layouter.add("Y units:", false);
        layouter.add((Component)this.yUnits, true);
        layouter.eatSpare();
        this.colourButton.setToolTipText("Select a colour");
        this.xTextField.setToolTipText("Type in the X axis label");
        this.yTextField.setToolTipText("Type in the Y axis label");
        this.xGapSpinner.setToolTipText("Set the gap between label and axis");
        this.yGapSpinner.setToolTipText("Set the gap between label and axis");
        this.xEdge.setToolTipText("Set edge for displaying label");
        this.yEdge.setToolTipText("Set edge for displaying label");
        this.xUnits.setToolTipText("Append any X axis units to label");
        this.xUnits.setToolTipText("Append any Y axis units to label");
    }

    public void setAstAxisLabel(AstAxisLabels astAxisLabels) {
        this.astAxisLabels = astAxisLabels;
        this.updateFromAstAxisLabels();
    }

    protected void updateFromAstAxisLabels() {
        this.astAxisLabels.removeChangeListener(this);
        this.xShowLabel.setSelected(this.astAxisLabels.getXShown());
        if (!this.inhibitXDocumentListener) {
            this.xTextField.setText(this.astAxisLabels.getXLabel());
        }
        this.yShowLabel.setSelected(this.astAxisLabels.getYShown());
        if (!this.inhibitYDocumentListener) {
            this.yTextField.setText(this.astAxisLabels.getYLabel());
        }
        this.xTextField.setTextFont(this.astAxisLabels.getFont());
        this.yTextField.setTextFont(this.astAxisLabels.getFont());
        this.fontControls.setFont(this.astAxisLabels.getFont());
        this.xTextField.setTextColour(this.astAxisLabels.getColour());
        this.yTextField.setTextColour(this.astAxisLabels.getColour());
        this.colourIcon.setMainColour(this.astAxisLabels.getColour());
        this.colourButton.repaint();
        this.xSpinnerModel.setValue(new Double(this.astAxisLabels.getXGap()));
        this.ySpinnerModel.setValue(new Double(this.astAxisLabels.getYGap()));
        if (this.astAxisLabels.getXEdge() == 4) {
            this.xEdge.setSelectedItem("BOTTOM");
        } else {
            this.xEdge.setSelectedItem("TOP");
        }
        if (this.astAxisLabels.getYEdge() == 1) {
            this.yEdge.setSelectedItem("LEFT");
        } else {
            this.yEdge.setSelectedItem("RIGHT");
        }
        this.xUnits.setSelected(this.astAxisLabels.getShowXUnits());
        this.yUnits.setSelected(this.astAxisLabels.getShowYUnits());
        this.astAxisLabels.setXState(true);
        this.astAxisLabels.setYState(true);
        this.astAxisLabels.addChangeListener(this);
    }

    public AstAxisLabels getAstAxisLabels() {
        return this.astAxisLabels;
    }

    private void addFontControls(GridBagLayouter layouter) {
        this.fontControls = new FontControls(layouter, "");
        this.fontControls.addListener(new FontChangedListener(){

            public void fontChanged(FontChangedEvent e) {
                AxisLabelControls.this.updateFont(e);
            }
        });
    }

    public void setXText(String text) {
        this.xTextField.setText(text);
    }

    public void setYText(String text) {
        this.yTextField.setText(text);
    }

    protected void matchXShown() {
        this.astAxisLabels.setXShown(this.xShowLabel.isSelected());
    }

    protected void matchXText() {
        this.inhibitXDocumentListener = true;
        this.astAxisLabels.setXLabel(this.xTextField.getText());
        this.inhibitXDocumentListener = false;
    }

    protected void matchYShown() {
        this.astAxisLabels.setYShown(this.yShowLabel.isSelected());
    }

    protected void matchYText() {
        this.inhibitYDocumentListener = true;
        this.astAxisLabels.setYLabel(this.yTextField.getText());
        this.inhibitYDocumentListener = false;
    }

    protected void matchXGap() {
        this.astAxisLabels.setXGap(this.xSpinnerModel.getNumber().doubleValue());
    }

    protected void matchYGap() {
        this.astAxisLabels.setYGap(this.ySpinnerModel.getNumber().doubleValue());
    }

    protected void updateFont(FontChangedEvent e) {
        this.setTextFont(e.getFont());
    }

    protected void setTextFont(Font font) {
        if (font != null) {
            this.xTextField.setTextFont(font);
            this.yTextField.setTextFont(font);
            this.astAxisLabels.setFont(font);
        }
    }

    protected void chooseColour() {
        Color newColour = JColorChooser.showDialog(this, "Select text colour", this.colourIcon.getMainColour());
        if (newColour != null) {
            this.setTextColour(newColour);
        }
    }

    protected void setTextColour(Color colour) {
        if (colour != null) {
            this.xTextField.setTextColour(colour);
            this.yTextField.setTextColour(colour);
            this.colourIcon.setMainColour(colour);
            this.colourButton.repaint();
            this.astAxisLabels.setColour(colour);
        }
    }

    protected void matchXEdge() {
        String edge = (String)this.xEdge.getSelectedItem();
        if (edge != null) {
            if (edge == "BOTTOM") {
                this.astAxisLabels.setXEdge(4);
            } else {
                this.astAxisLabels.setXEdge(3);
            }
        }
    }

    protected void matchYEdge() {
        String edge = (String)this.yEdge.getSelectedItem();
        if (edge != null) {
            if (edge == "LEFT") {
                this.astAxisLabels.setYEdge(1);
            } else {
                this.astAxisLabels.setYEdge(2);
            }
        }
    }

    protected void matchXUnits() {
        this.astAxisLabels.setShowXUnits(this.xUnits.isSelected());
    }

    protected void matchYUnits() {
        this.astAxisLabels.setShowYUnits(this.yUnits.isSelected());
    }

    public String getControlsTitle() {
        return defaultTitle;
    }

    public String getControlsName() {
        return defaultName;
    }

    public void reset() {
        this.astAxisLabels.setDefaults();
        this.fontControls.setDefaults();
        this.setTextColour(Color.black);
        this.astAxisLabels.addChangeListener(this);
        this.updateFromAstAxisLabels();
    }

    public JComponent getControlsComponent() {
        return this;
    }

    public AbstractPlotControlsModel getControlsModel() {
        return this.astAxisLabels;
    }

    public static Class getControlsModelClass() {
        return class$uk$ac$starlink$ast$gui$AstAxisLabels == null ? (class$uk$ac$starlink$ast$gui$AstAxisLabels = AxisLabelControls.class$("uk.ac.starlink.ast.gui.AstAxisLabels")) : class$uk$ac$starlink$ast$gui$AstAxisLabels;
    }

    public void stateChanged(ChangeEvent e) {
        this.updateFromAstAxisLabels();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

