/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;
import uk.ac.starlink.ast.gui.AstBorder;
import uk.ac.starlink.ast.gui.LineControls;
import uk.ac.starlink.ast.gui.PlotControls;
import uk.ac.starlink.ast.gui.Utilities;
import uk.ac.starlink.util.gui.GridBagLayouter;

public class BorderControls
extends JPanel
implements PlotControls,
ChangeListener {
    protected AstBorder astBorder = null;
    protected JCheckBox show = new JCheckBox();
    protected LineControls lineControls = null;
    protected boolean inhibitLineChangeListener = false;
    protected static String defaultTitle = "Border line properties:";
    protected static String defaultName = "Border lines";
    static /* synthetic */ Class class$uk$ac$starlink$ast$gui$AstBorder;

    public BorderControls(AbstractPlotControlsModel astBorder) {
        this.initUI();
        this.setAstBorder((AstBorder)astBorder);
    }

    protected void initUI() {
        this.show.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BorderControls.this.matchShow();
            }
        });
        GridBagLayouter layouter = Utilities.getGridBagLayouter(this);
        layouter.add("Show:", false);
        layouter.add((Component)this.show, true);
        this.addLineControls(layouter);
        layouter.eatSpare();
        this.show.setToolTipText("Display border lines in plot");
    }

    public void setAstBorder(AstBorder astBorder) {
        this.astBorder = astBorder;
        astBorder.addChangeListener(this);
        this.updateFromAstBorder();
    }

    protected void updateFromAstBorder() {
        this.astBorder.removeChangeListener(this);
        this.show.setSelected(this.astBorder.getShown());
        this.inhibitLineChangeListener = true;
        this.lineControls.setThick((int)this.astBorder.getWidth());
        this.lineControls.setColour(this.astBorder.getColour());
        this.lineControls.setStyle((int)this.astBorder.getStyle());
        this.inhibitLineChangeListener = false;
        this.astBorder.setState(true);
        this.astBorder.addChangeListener(this);
    }

    public AstBorder getAstBorder() {
        return this.astBorder;
    }

    protected void matchShow() {
        this.astBorder.setShown(this.show.isSelected());
    }

    private void addLineControls(GridBagLayouter layouter) {
        this.lineControls = new LineControls(layouter, "");
        this.lineControls.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                BorderControls.this.matchLine();
            }
        });
    }

    protected void matchLine() {
        if (!this.inhibitLineChangeListener) {
            this.astBorder.removeChangeListener(this);
            this.astBorder.setWidth(this.lineControls.getThick());
            this.astBorder.setStyle(this.lineControls.getStyle());
            this.astBorder.setColour(this.lineControls.getColour());
            this.astBorder.addChangeListener(this);
            this.updateFromAstBorder();
        }
    }

    public String getControlsTitle() {
        return defaultTitle;
    }

    public String getControlsName() {
        return defaultName;
    }

    public void reset() {
        this.lineControls.reset();
        this.astBorder.setDefaults();
    }

    public JComponent getControlsComponent() {
        return this;
    }

    public AbstractPlotControlsModel getControlsModel() {
        return this.astBorder;
    }

    public static Class getControlsModelClass() {
        return class$uk$ac$starlink$ast$gui$AstBorder == null ? (class$uk$ac$starlink$ast$gui$AstBorder = BorderControls.class$("uk.ac.starlink.ast.gui.AstBorder")) : class$uk$ac$starlink$ast$gui$AstBorder;
    }

    public void stateChanged(ChangeEvent e) {
        this.updateFromAstBorder();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

