/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Toolkit;
import java.text.ParseException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import uk.ac.starlink.ast.gui.ScientificFormat;

public class DecimalDocument
extends PlainDocument {
    private ScientificFormat format;

    public DecimalDocument(ScientificFormat format) {
        this.format = format;
    }

    public ScientificFormat getFormat() {
        return this.format;
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String currentText = this.getText(0, this.getLength()) + "0";
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + str + afterOffset;
        try {
            this.format.parseObject(proposedResult);
            super.insertString(offs, str, a);
        }
        catch (ParseException e) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void remove(int offs, int len) throws BadLocationException {
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(len + offs, currentText.length());
        String proposedResult = beforeOffset + afterOffset;
        try {
            if (proposedResult.length() > 1) {
                this.format.parseObject(proposedResult);
            }
            super.remove(offs, len);
        }
        catch (ParseException e) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

