/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.text.ParseException;
import javax.swing.JTextField;
import uk.ac.starlink.ast.gui.DecimalDocument;
import uk.ac.starlink.ast.gui.ScientificFormat;

public class DecimalField
extends JTextField {
    protected ScientificFormat scientificFormat;

    public DecimalField(double value, int columns, ScientificFormat format) {
        super(columns);
        this.setDocument(new DecimalDocument(format));
        this.scientificFormat = format;
        this.setDoubleValue(value);
    }

    public DecimalField(int value, int columns, ScientificFormat format) {
        super(columns);
        this.setDocument(new DecimalDocument(format));
        this.scientificFormat = format;
        this.setIntValue(value);
    }

    public double getDoubleValue() {
        double retVal = 0.0;
        try {
            retVal = this.scientificFormat.parse(this.getText()).doubleValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return retVal;
    }

    public int getIntValue() {
        int retVal = 0;
        try {
            retVal = this.scientificFormat.parse(this.getText()).intValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return retVal;
    }

    public void setDoubleValue(double value) {
        this.setText(this.scientificFormat.format(value));
    }

    public void setIntValue(int value) {
        this.setText(this.scientificFormat.format(value));
    }
}

