/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;
import uk.ac.starlink.ast.gui.AstAxes;
import uk.ac.starlink.ast.gui.AstAxisLabels;
import uk.ac.starlink.ast.gui.AstBorder;
import uk.ac.starlink.ast.gui.AstGrid;
import uk.ac.starlink.ast.gui.AstNumberLabels;
import uk.ac.starlink.ast.gui.AstStrings;
import uk.ac.starlink.ast.gui.AstTicks;
import uk.ac.starlink.ast.gui.AstTitle;
import uk.ac.starlink.util.XMLEncodeDecode;
import uk.ac.starlink.util.gui.StoreConfiguration;

public class PlotConfiguration
implements XMLEncodeDecode {
    protected AstTitle astTitle = new AstTitle();
    protected AstStrings astStrings = new AstStrings();
    protected AstAxisLabels astAxisLabels = new AstAxisLabels();
    protected AstNumberLabels astNumberLabels = new AstNumberLabels();
    protected AstGrid astGrid = new AstGrid();
    protected AstAxes astAxes = new AstAxes();
    protected AstBorder astBorder = new AstBorder();
    protected AstTicks astTicks = new AstTicks();
    protected ArrayList configObjects = new ArrayList(10);
    protected ArrayList astConfigObjects = new ArrayList(10);

    public PlotConfiguration() {
        this.configObjects.add(this.astTitle);
        this.configObjects.add(this.astStrings);
        this.configObjects.add(this.astAxisLabels);
        this.configObjects.add(this.astNumberLabels);
        this.configObjects.add(this.astGrid);
        this.configObjects.add(this.astAxes);
        this.configObjects.add(this.astBorder);
        this.configObjects.add(this.astTicks);
        this.astConfigObjects.add(this.astTitle);
        this.astConfigObjects.add(this.astStrings);
        this.astConfigObjects.add(this.astAxisLabels);
        this.astConfigObjects.add(this.astNumberLabels);
        this.astConfigObjects.add(this.astGrid);
        this.astConfigObjects.add(this.astAxes);
        this.astConfigObjects.add(this.astBorder);
        this.astConfigObjects.add(this.astTicks);
    }

    public String getAst() {
        StringBuffer result = new StringBuffer(this.astConfigObjects.get(0).toString());
        String description = null;
        for (int i = 1; i < this.astConfigObjects.size(); ++i) {
            description = this.astConfigObjects.get(i).toString();
            if (description == null || description.equals("")) continue;
            result.append(",");
            result.append(description);
        }
        return result.toString();
    }

    public String getAst(boolean passone) {
        AbstractPlotControlsModel.setListening(false);
        boolean tickAll = this.astTicks.getTickAll();
        this.astTicks.setTickAll(false);
        boolean titleShown = this.astTitle.getShown();
        boolean yAxisShown = this.astAxes.getYShown();
        boolean yLabelShown = this.astAxisLabels.getYShown();
        int xEdge = this.astAxisLabels.getXEdge();
        boolean yNumbersShown = this.astNumberLabels.getYShown();
        if (passone) {
            this.astAxes.setYShown(false);
            this.astAxisLabels.setYShown(false);
            this.astNumberLabels.setYShown(false);
            if (xEdge == 4) {
                this.astTitle.setShown(false);
            }
        } else if (xEdge == 3) {
            this.astTitle.setShown(false);
            this.astAxisLabels.setXEdge(4);
        } else {
            this.astAxisLabels.setXEdge(3);
        }
        String options = this.getAst();
        this.astTicks.setTickAll(tickAll);
        this.astTitle.setShown(titleShown);
        this.astAxes.setYShown(yAxisShown);
        this.astAxisLabels.setXEdge(xEdge);
        this.astAxisLabels.setYShown(yLabelShown);
        this.astNumberLabels.setYShown(yNumbersShown);
        AbstractPlotControlsModel.setListening(true);
        return options;
    }

    public void add(AbstractPlotControlsModel model) {
        this.configObjects.add(model);
    }

    public Iterator iterator() {
        return this.configObjects.iterator();
    }

    public AbstractPlotControlsModel getControlsModel(Class clazz) {
        Iterator i = this.configObjects.iterator();
        Object n = null;
        while (i.hasNext()) {
            n = i.next();
            if (!clazz.isInstance(n)) continue;
            return n;
        }
        return null;
    }

    public void encode(Element rootElement) {
        Document parent = rootElement.getOwnerDocument();
        for (int i = 0; i < this.configObjects.size(); ++i) {
            AbstractPlotControlsModel model = (AbstractPlotControlsModel)this.configObjects.get(i);
            Element child = parent.createElement(model.getTagName());
            rootElement.appendChild(child);
            model.encode(child);
        }
    }

    public void decode(Element rootElement) {
        List children = StoreConfiguration.getChildElements(rootElement);
        block0: for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            String name = child.getTagName();
            for (int j = 0; j < this.configObjects.size(); ++j) {
                AbstractPlotControlsModel model = (AbstractPlotControlsModel)this.configObjects.get(j);
                if (!model.getTagName().equals(name)) continue;
                model.decode(child);
                continue block0;
            }
        }
    }

    public String getTagName() {
        return "plot-config";
    }
}

