/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Element;
import uk.ac.starlink.ast.gui.AxesControls;
import uk.ac.starlink.ast.gui.AxisLabelControls;
import uk.ac.starlink.ast.gui.AxisNumLabControls;
import uk.ac.starlink.ast.gui.BorderControls;
import uk.ac.starlink.ast.gui.GridControls;
import uk.ac.starlink.ast.gui.PlotConfiguration;
import uk.ac.starlink.ast.gui.PlotController;
import uk.ac.starlink.ast.gui.PlotControls;
import uk.ac.starlink.ast.gui.StringsControls;
import uk.ac.starlink.ast.gui.TickControls;
import uk.ac.starlink.ast.gui.TitleControls;
import uk.ac.starlink.util.gui.StoreControlFrame;
import uk.ac.starlink.util.gui.StoreSource;

public class PlotConfigurator
extends JFrame
implements StoreSource,
ChangeListener {
    protected JPanel contentPane = null;
    protected JPanel actionBar = new JPanel();
    protected JTabbedPane tabbedPane = new JTabbedPane();
    protected JMenuBar menuBar = new JMenuBar();
    protected JMenu fileMenu = new JMenu();
    protected JMenuItem saveConfigFileMenu = new JMenuItem();
    protected JMenuItem drawFileMenu = new JMenuItem();
    protected JMenuItem closeFileMenu = new JMenuItem();
    protected JMenu optionsMenu = new JMenu();
    protected JMenuItem saveConfigOptionsMenu = new JMenuItem();
    protected JMenuItem autoDrawOptionsMenu = new JCheckBoxMenuItem("Auto-update");
    protected PlotConfiguration config = null;
    protected PlotController controller;
    protected StoreControlFrame storeControl = null;
    protected Element defaultConfig = null;
    protected static String defaultTitle = "Configure AST graphics options";
    protected String applicationName = "astgui";
    protected String storeName = "plot-configs.xml";
    protected String title = defaultTitle;
    protected ArrayList controlsList = new ArrayList(10);
    static /* synthetic */ Class class$uk$ac$starlink$util$images$ImageHolder;

    public PlotConfigurator() {
        this((String)null, (PlotController)null);
    }

    public PlotConfigurator(String title) {
        this(title, (PlotController)null);
    }

    public PlotConfigurator(String title, PlotController controller) {
        this(title, controller, null, null, null);
    }

    public PlotConfigurator(String title, PlotController controller, PlotConfiguration config, String applicationName, String storeName) {
        this.title = title == null ? defaultTitle : title;
        this.controller = controller;
        this.config = config == null ? new PlotConfiguration() : config;
        if (applicationName != null) {
            this.applicationName = applicationName;
        }
        if (storeName != null) {
            this.storeName = storeName;
        }
        this.contentPane = (JPanel)this.getContentPane();
        this.initTabbedPane();
        this.initMenus();
        this.initFrame();
    }

    protected void initTabbedPane() {
        this.tabbedPane.setTabPlacement(1);
        this.tabbedPane.setToolTipText("Ast graphics configurator window");
        this.addDefaultControls();
    }

    protected void initFrame() {
        this.setTitle(this.title);
        this.setDefaultCloseOperation(1);
        this.contentPane.add((Component)this.tabbedPane, "Center");
        this.contentPane.add((Component)this.actionBar, "South");
        this.setSize(new Dimension(400, 750));
        this.setVisible(true);
    }

    protected void initMenus() {
        this.setJMenuBar(this.menuBar);
        JPanel topAction = new JPanel();
        JPanel botAction = new JPanel();
        topAction.setLayout(new BoxLayout(topAction, 0));
        botAction.setLayout(new BoxLayout(botAction, 0));
        topAction.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        botAction.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.actionBar.setLayout(new BorderLayout());
        this.actionBar.add((Component)topAction, "North");
        this.actionBar.add((Component)botAction, "South");
        this.actionBar.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        ImageIcon drawImage = new ImageIcon((class$uk$ac$starlink$util$images$ImageHolder == null ? (class$uk$ac$starlink$util$images$ImageHolder = PlotConfigurator.class$("uk.ac.starlink.util.images.ImageHolder")) : class$uk$ac$starlink$util$images$ImageHolder).getResource("accept.gif"));
        ImageIcon resetImage = new ImageIcon((class$uk$ac$starlink$util$images$ImageHolder == null ? (class$uk$ac$starlink$util$images$ImageHolder = PlotConfigurator.class$("uk.ac.starlink.util.images.ImageHolder")) : class$uk$ac$starlink$util$images$ImageHolder).getResource("reset.gif"));
        ImageIcon closeImage = new ImageIcon((class$uk$ac$starlink$util$images$ImageHolder == null ? (class$uk$ac$starlink$util$images$ImageHolder = PlotConfigurator.class$("uk.ac.starlink.util.images.ImageHolder")) : class$uk$ac$starlink$util$images$ImageHolder).getResource("exit.gif"));
        ImageIcon configImage = new ImageIcon((class$uk$ac$starlink$util$images$ImageHolder == null ? (class$uk$ac$starlink$util$images$ImageHolder = PlotConfigurator.class$("uk.ac.starlink.util.images.ImageHolder")) : class$uk$ac$starlink$util$images$ImageHolder).getResource("config.gif"));
        this.fileMenu.setText("File");
        this.fileMenu.setMnemonic(70);
        this.menuBar.add(this.fileMenu);
        this.optionsMenu.setText("Options");
        this.optionsMenu.setMnemonic(79);
        this.menuBar.add(this.optionsMenu);
        DrawAction drawAction = new DrawAction("Draw", drawImage);
        this.fileMenu.add(drawAction).setMnemonic(68);
        JButton drawButton = new JButton(drawAction);
        topAction.add(Box.createGlue());
        topAction.add(drawButton);
        drawButton.setToolTipText("Re-draw graphics using the current configuration");
        ResetAction resetAction = new ResetAction("Reset", resetImage);
        this.fileMenu.add(resetAction).setMnemonic(82);
        JButton resetButton = new JButton(resetAction);
        topAction.add(Box.createGlue());
        topAction.add(resetButton);
        resetButton.setToolTipText("Reset all values to defaults");
        StoreAction storeAction = new StoreAction("Store/restore", configImage);
        this.optionsMenu.add(storeAction).setMnemonic(83);
        JButton storeButton = new JButton(storeAction);
        topAction.add(Box.createGlue());
        topAction.add(storeButton);
        storeButton.setToolTipText("Open window to store and restore configurations");
        this.optionsMenu.add(this.autoDrawOptionsMenu);
        CloseAction closeAction = new CloseAction("Close", closeImage);
        this.fileMenu.add(closeAction).setMnemonic(67);
        JButton closeButton = new JButton(closeAction);
        botAction.add(Box.createGlue());
        botAction.add(closeButton);
        closeButton.setToolTipText("Close window");
        topAction.add(Box.createGlue());
        botAction.add(Box.createGlue());
    }

    public String getAst() {
        return this.config.getAst();
    }

    public PlotConfiguration getConfiguration() {
        return this.config;
    }

    public void setAutoDrawOption(boolean state) {
        if (this.autoDrawOptionsMenu.isSelected() != state) {
            this.autoDrawOptionsMenu.setSelected(state);
        }
    }

    public boolean isAutoDrawOption() {
        return this.autoDrawOptionsMenu.isSelected();
    }

    protected void addDefaultControls() {
        this.addTitle();
        this.addAxisLabels();
        this.addNumberLabels();
        this.addAxes();
        this.addGrid();
        this.addBorder();
        this.addTicks();
        this.addText();
    }

    public void addTitle() {
        TitleControls titlePanel = new TitleControls(this.config.getControlsModel(TitleControls.getControlsModelClass()));
        this.addControls(titlePanel, true);
    }

    protected void addAxisLabels() {
        AxisLabelControls axisLabelsPanel = new AxisLabelControls(this.config.getControlsModel(AxisLabelControls.getControlsModelClass()));
        this.addControls(axisLabelsPanel, true);
    }

    protected void addNumberLabels() {
        AxisNumLabControls axisNumbersPanel = new AxisNumLabControls(this.config.getControlsModel(AxisNumLabControls.getControlsModelClass()));
        this.addControls(axisNumbersPanel, true);
    }

    protected void addGrid() {
        GridControls gridPanel = new GridControls(this.config.getControlsModel(GridControls.getControlsModelClass()));
        this.addControls(gridPanel, true);
    }

    protected void addAxes() {
        AxesControls axesPanel = new AxesControls(this.config.getControlsModel(AxesControls.getControlsModelClass()), this.controller);
        this.addControls(axesPanel, true);
    }

    protected void addBorder() {
        BorderControls borderPanel = new BorderControls(this.config.getControlsModel(BorderControls.getControlsModelClass()));
        this.addControls(borderPanel, true);
    }

    protected void addTicks() {
        TickControls ticksPanel = new TickControls(this.config.getControlsModel(TickControls.getControlsModelClass()), this.controller);
        this.addControls(ticksPanel, true);
    }

    public void addText() {
        StringsControls stringsPanel = new StringsControls(this.config.getControlsModel(StringsControls.getControlsModelClass()));
        this.addControls(stringsPanel, true);
    }

    public void addExtraControls(PlotControls controls, boolean append) {
        this.addControls(controls, append);
    }

    protected void addControls(PlotControls controls, boolean append) {
        JComponent controlsUI = controls.getControlsComponent();
        controlsUI.setBorder(new TitledBorder(controls.getControlsTitle()));
        if (append) {
            this.tabbedPane.add(controls.getControlsName(), controlsUI);
        } else {
            this.tabbedPane.add(controlsUI, controls.getControlsName(), 0);
        }
        controls.getControlsModel().addChangeListener(this);
        this.controlsList.add(controls);
    }

    public void reveal(int page) {
        try {
            this.tabbedPane.setSelectedIndex(page);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected void closeWindowEvent() {
        this.dispose();
        if (this.storeControl != null) {
            this.storeControl.dispose();
        }
    }

    public void update() {
        this.controller.updatePlot();
    }

    public void reset() {
        for (int i = 0; i < this.controlsList.size(); ++i) {
            ((PlotControls)this.controlsList.get(i)).reset();
        }
        if (this.defaultConfig != null) {
            this.config.decode(this.defaultConfig);
        }
    }

    public void saveState(Element rootElement) {
        this.config.encode(rootElement);
    }

    public void restoreState(Element rootElement) {
        this.defaultConfig = rootElement;
        this.config.decode(rootElement);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getTagName() {
        return this.config.getTagName();
    }

    public void openStoreWindow() {
        if (this.storeControl == null) {
            this.storeControl = new StoreControlFrame(this);
            this.storeControl.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent evt) {
                    PlotConfigurator.this.storeControlClosed();
                }
            });
        } else {
            this.storeControl.setVisible(true);
        }
    }

    protected void storeControlClosed() {
    }

    protected void closeStoreConfigFrame() {
        if (this.storeControl != null) {
            this.storeControl.dispose();
            this.storeControl = null;
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (this.autoDrawOptionsMenu.isSelected()) {
            this.update();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class StoreAction
    extends AbstractAction {
        public StoreAction(String name, Icon icon) {
            super(name, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control S"));
        }

        public void actionPerformed(ActionEvent ae) {
            PlotConfigurator.this.openStoreWindow();
        }
    }

    protected class ResetAction
    extends AbstractAction {
        public ResetAction(String name, Icon icon) {
            super(name, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control R"));
        }

        public void actionPerformed(ActionEvent ae) {
            PlotConfigurator.this.reset();
        }
    }

    protected class CloseAction
    extends AbstractAction {
        public CloseAction(String name, Icon icon) {
            super(name, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control W"));
        }

        public void actionPerformed(ActionEvent ae) {
            PlotConfigurator.this.closeWindowEvent();
        }
    }

    protected class DrawAction
    extends AbstractAction {
        public DrawAction(String name, Icon icon) {
            super(name, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control D"));
        }

        public void actionPerformed(ActionEvent ae) {
            PlotConfigurator.this.update();
        }
    }
}

