/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hds;

import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Order;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;
import uk.ac.starlink.hds.HDSType;

public class ArrayStructure {
    private final HDSObject hobj;
    private final HDSObject dataObj;
    private final OrderedNDShape oshape;
    private final HDSType htype;
    private final String storage;
    private static final long[] SCALAR_DIMS = new long[0];

    public ArrayStructure(HDSObject hobj) throws HDSException {
        HDSObject dat;
        this.hobj = hobj;
        if (hobj.datStruc() && hobj.datShape().length == 0 && hobj.datType().equals("ARRAY") && hobj.datThere("DATA") && (dat = hobj.datFind("DATA")) != null && !dat.datStruc() && dat.datShape().length > 0) {
            long[] origin;
            this.storage = "SIMPLE";
            this.dataObj = dat;
            long[] dims = this.dataObj.datShape();
            if (hobj.datThere("ORIGIN")) {
                HDSObject orgObj = hobj.datFind("ORIGIN");
                long[] orgShape = orgObj.datShape();
                if (orgShape.length != 1 || orgShape[0] != (long)dims.length || !orgObj.datType().equals("_INTEGER")) {
                    throw new HDSException("Format of ARY object is unexpected");
                }
                origin = NDShape.intsToLongs((int[])orgObj.datGetvi());
            } else {
                origin = new long[dims.length];
                for (int i = 0; i < dims.length; ++i) {
                    origin[i] = 1L;
                }
            }
            this.oshape = new OrderedNDShape(new NDShape(origin, dims), Order.COLUMN_MAJOR);
        } else if (!hobj.datStruc() && hobj.datShape().length > 0) {
            this.storage = "PRIMITIVE";
            this.dataObj = hobj.datClone();
            long[] dims = this.dataObj.datShape();
            int ndim = dims.length;
            long[] origin = new long[ndim];
            for (int i = 0; i < ndim; ++i) {
                origin[i] = 1L;
            }
            this.oshape = new OrderedNDShape(new NDShape(origin, dims), Order.COLUMN_MAJOR);
        } else {
            throw new HDSException("No array structure found in HDS object " + hobj.datRef());
        }
        this.htype = HDSType.fromName(this.dataObj.datType());
    }

    public ArrayStructure(HDSObject struct, NDShape shape, HDSType htype) throws HDSException {
        if (!struct.datStruc()) {
            throw new HDSException("HDS object is not a structure");
        }
        if (!struct.datType().equals("ARRAY")) {
            throw new HDSException("HDS structure type is '" + struct.datType() + "' not 'ARRAY'");
        }
        for (int i = struct.datNcomp(); i > 0; --i) {
            HDSObject sub = struct.datIndex(i);
            String subname = sub.datName();
            sub.datAnnul();
            struct.datErase(subname);
        }
        ArrayStructure.populateArrayStructure(struct, shape, htype);
        this.hobj = struct;
        this.dataObj = struct.datFind("DATA");
        this.oshape = new OrderedNDShape(shape, Order.COLUMN_MAJOR);
        this.htype = htype;
        this.storage = "SIMPLE";
    }

    public ArrayStructure(HDSObject parent, String name, HDSType htype, NDShape shape) throws HDSException {
        parent.datNew(name, "ARRAY", SCALAR_DIMS);
        HDSObject struct = parent.datFind(name);
        ArrayStructure.populateArrayStructure(struct, shape, htype);
        this.hobj = struct;
        this.dataObj = struct.datFind("DATA");
        this.oshape = new OrderedNDShape(shape, Order.COLUMN_MAJOR);
        this.htype = htype;
        this.storage = "SIMPLE";
    }

    private static void populateArrayStructure(HDSObject struct, NDShape shape, HDSType htype) throws HDSException {
        long[] dims = shape.getDims();
        struct.datNew("ORIGIN", "_INTEGER", new long[]{dims.length});
        struct.datFind("ORIGIN").datPutvi(NDShape.longsToInts((long[])shape.getOrigin()));
        struct.datNew("DATA", htype.getName(), dims);
    }

    public HDSObject getData() {
        return this.dataObj;
    }

    public OrderedNDShape getShape() {
        return this.oshape;
    }

    public String getStorage() {
        return this.storage;
    }

    public HDSObject getHDSObject() {
        return this.hobj;
    }

    public HDSType getType() {
        return this.htype;
    }
}

