/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hds;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;
import uk.ac.starlink.hds.HDSPackage;
import uk.ac.starlink.hds.HDSReference;
import uk.ac.starlink.hds.LocalHDS;
import uk.ac.starlink.hds.NDFNdxImpl;
import uk.ac.starlink.hds.NdfMaker;
import uk.ac.starlink.hdx.HdxDOMImplementation;
import uk.ac.starlink.hdx.HdxDocument;
import uk.ac.starlink.hdx.HdxDocumentFactory;
import uk.ac.starlink.hdx.HdxException;
import uk.ac.starlink.hdx.HdxFactory;
import uk.ac.starlink.ndx.BridgeNdx;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.NdxHandler;
import uk.ac.starlink.ndx.NdxImpl;

public class NDFNdxHandler
implements NdxHandler,
HdxDocumentFactory {
    private static NDFNdxHandler instance = new NDFNdxHandler();

    private NDFNdxHandler() {
    }

    public static NDFNdxHandler getInstance() {
        if (HDSPackage.isAvailable()) {
            return instance;
        }
        throw new LinkageError("Native code for the JNIHDS package is not installed");
    }

    public Ndx makeNdx(URL url, AccessMode mode) throws IOException {
        if (mode != AccessMode.READ && !url.getProtocol().equals("file")) {
            throw new IOException("Remote " + mode + " access not supported " + "for HDS files");
        }
        LocalHDS lobj = LocalHDS.getReadableHDS(url);
        if (lobj == null) {
            return null;
        }
        HDSReference href = lobj.getHDSReference();
        final File file = href.getContainerFile();
        final boolean isTemp = lobj.isTemporary();
        try {
            NDFNdxImpl impl = new NDFNdxImpl(href, url, mode){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void finalize() throws Throwable {
                    try {
                        super.finalize();
                    }
                    finally {
                        if (isTemp) {
                            file.delete();
                        }
                    }
                }
            };
            return new BridgeNdx((NdxImpl)impl);
        }
        catch (HDSException e) {
            if (isTemp) {
                file.delete();
            }
            throw (IOException)new IOException().initCause(e);
        }
    }

    public Ndx makeNdx(HDSObject hobj, URL persistentURL, AccessMode mode) throws HDSException {
        try {
            return new BridgeNdx((NdxImpl)new NDFNdxImpl(hobj, persistentURL, mode));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean makeBlankNdx(URL url, Ndx template) throws IOException {
        try {
            LocalHDS lobj = LocalHDS.getNewHDS(url, "NDF");
            if (lobj == null) {
                return false;
            }
            HDSReference href = lobj.getHDSReference();
            HDSObject place = href.getObject("WRITE");
            new NdfMaker().makeBlankNDF(template, place);
            return true;
        }
        catch (HDSException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public boolean outputNdx(URL url, Ndx orig) throws IOException {
        try {
            LocalHDS lobj = LocalHDS.getNewHDS(url, "NDF");
            if (lobj == null) {
                return false;
            }
            HDSReference href = lobj.getHDSReference();
            HDSObject place = href.getObject("WRITE");
            new NdfMaker().makeNDF(orig, place);
            return true;
        }
        catch (HDSException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public Document makeHdxDocument(URL url) throws HdxException {
        try {
            Ndx hdsNdx = this.makeNdx(url, AccessMode.READ);
            if (hdsNdx == null) {
                return null;
            }
            HdxDocument doc = (HdxDocument)HdxDOMImplementation.getInstance().createDocument(null, "hdx", null);
            Element el = doc.createElement("hdx");
            doc.appendChild(el);
            Element ndxEl = doc.createElement(hdsNdx.getHdxFacade());
            el.appendChild(ndxEl);
            return doc;
        }
        catch (IOException ex) {
            throw new HdxException("Failed to handle URL " + url + " (" + ex + ")");
        }
    }

    public Source makeHdxSource(URL url) throws HdxException {
        return new DOMSource(this.makeHdxDocument(url));
    }

    static {
        HdxFactory.registerHdxDocumentFactory(NDFNdxHandler.getInstance());
    }
}

