/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hds;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.ArrayImpl;
import uk.ac.starlink.array.BridgeNDArray;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.ast.AstPackage;
import uk.ac.starlink.ast.CmpMap;
import uk.ac.starlink.ast.Frame;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.ast.LutMap;
import uk.ac.starlink.ast.Mapping;
import uk.ac.starlink.ast.ShiftMap;
import uk.ac.starlink.ast.UnitMap;
import uk.ac.starlink.hds.ARYReadChannel;
import uk.ac.starlink.hds.ArrayStructure;
import uk.ac.starlink.hds.HDSArrayImpl;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;
import uk.ac.starlink.hds.HDSReference;
import uk.ac.starlink.ndx.NdxImpl;
import uk.ac.starlink.util.URLUtils;

class NDFNdxImpl
implements NdxImpl {
    private final URL persistentUrl;
    private final HDSObject ndf;
    private final AccessMode mode;
    private NDArray image;
    private NDArray variance;
    private NDArray quality;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NDFNdxImpl(HDSReference nref, URL persistentUrl, AccessMode mode) throws HDSException {
        this(nref.getObject(HDSReference.hdsMode(mode)), persistentUrl, mode);
    }

    public NDFNdxImpl(HDSObject nobj, URL persistentUrl, AccessMode mode) throws HDSException {
        this.ndf = nobj;
        this.persistentUrl = persistentUrl;
        this.mode = mode;
        NDArray[] arrays = NDFNdxImpl.makeArrayData(this.ndf, persistentUrl, mode);
        this.image = arrays[0];
        this.variance = arrays[1];
        this.quality = arrays[2];
    }

    public boolean hasTitle() {
        try {
            return this.ndf.datThere("TITLE");
        }
        catch (HDSException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTitle() {
        try {
            return this.ndf.datFind("TITLE").datGet0c();
        }
        catch (HDSException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasLabel() {
        try {
            return this.ndf.datThere("LABEL");
        }
        catch (HDSException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLabel() {
        try {
            return this.ndf.datFind("LABEL").datGet0c();
        }
        catch (HDSException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasUnits() {
        try {
            return this.ndf.datThere("UNITS");
        }
        catch (HDSException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUnits() {
        try {
            return this.ndf.datFind("UNITS").datGet0c();
        }
        catch (HDSException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasWCS() {
        return AstPackage.isAvailable() && (this.wcsArray() != null || this.axisArray() != null);
    }

    public Object getWCS() {
        OrderedNDShape shape = this.image.getShape();
        int ndim = shape.getNumDims();
        Frame gridFrame = new Frame(ndim);
        Frame pixelFrame = new Frame(ndim);
        Frame axisFrame = new Frame(ndim);
        gridFrame.setDomain("GRID");
        pixelFrame.setDomain("PIXEL");
        axisFrame.setDomain("AXIS");
        for (int i = 0; i < ndim; ++i) {
            int ifrm = i + 1;
            gridFrame.setLabel(ifrm, "GRID" + ifrm);
            pixelFrame.setLabel(ifrm, "PIXEL" + ifrm);
            axisFrame.setLabel(ifrm, "AXIS" + ifrm);
        }
        long[] origin = shape.getOrigin();
        double[] pixShift = new double[ndim];
        for (int i = 0; i < ndim; ++i) {
            pixShift[i] = (double)origin[i] - 1.5;
        }
        FrameSet fset = new FrameSet(gridFrame);
        int jGridFrm = fset.getNframe();
        fset.addFrame(jGridFrm, (Mapping)new ShiftMap(pixShift), pixelFrame);
        int jPixelFrm = fset.getNframe();
        fset.addFrame(jPixelFrm, (Mapping)new UnitMap(ndim), axisFrame);
        int jAxisFrm = fset.getNframe();
        FrameSet basicFset = (FrameSet)fset.copy();
        try {
            HDSObject wcsa;
            HDSObject axes = this.axisArray();
            if (axes != null) {
                LutMap amap = null;
                for (int i = 0; i < ndim; ++i) {
                    ArrayStructure axary;
                    HDSObject axdat;
                    double[] lut;
                    int ifrm = i + 1;
                    HDSObject axobj = axes.datCell(new long[]{ifrm});
                    if (axobj.datThere("UNITS")) {
                        axisFrame.setUnit(ifrm, axobj.datFind("UNITS").datGet0c());
                    }
                    if (axobj.datThere("LABEL")) {
                        axisFrame.setLabel(ifrm, axobj.datFind("LABEL").datGet0c());
                    }
                    LutMap map1 = (lut = (axdat = (axary = new ArrayStructure(axobj.datFind("DATA_ARRAY"))).getData()).datGetvd()).length > 1 ? new LutMap(lut, 1.0, 1.0) : new ShiftMap(lut);
                    amap = i == 0 ? map1 : new CmpMap((Mapping)amap, (Mapping)map1, false);
                }
                if (!$assertionsDisabled && !fset.getFrame(3).getDomain().equals("AXIS")) {
                    throw new AssertionError();
                }
                fset.remapFrame(3, amap.simplify());
            }
            if ((wcsa = this.wcsArray()) != null) {
                ARYReadChannel chan = new ARYReadChannel(this.wcsArray());
                FrameSet wcs = (FrameSet)chan.read();
                if (wcs != null && wcs.getFrame(1).getNaxes() == ndim && wcs.getFrame(1).getDomain().equals("GRID") && wcs.getFrame(2).getDomain().equals("PIXEL") && wcs.getFrame(3).getDomain().equals("AXIS")) {
                    if (wcs.getNframe() > 3) {
                        int jCurrent = wcs.getCurrent();
                        Frame gridCopy = (Frame)wcs.getFrame(1).copy();
                        gridCopy.setDomain("DUMMY");
                        wcs.addFrame(1, (Mapping)new UnitMap(ndim), gridCopy);
                        int jDummy = wcs.getNframe();
                        wcs.removeFrame(3);
                        wcs.removeFrame(2);
                        wcs.removeFrame(1);
                        fset.addFrame(1, (Mapping)new UnitMap(ndim), (Frame)wcs);
                        if (!$assertionsDisabled && !fset.getFrame(jDummy).getDomain().equals("DUMMY")) {
                            throw new AssertionError();
                        }
                        fset.removeFrame(jDummy);
                        fset.setCurrent(jCurrent);
                    }
                } else {
                    logger.warning("Ignoring funny-looking WCS component");
                }
            }
            return fset;
        }
        catch (HDSException e) {
            logger.warning("Trouble reading WCS FrameSet from NDF: " + e);
            return basicFset;
        }
        catch (IOException e) {
            logger.warning("Trouble reading WCS FrameSet from NDF: " + e);
            return basicFset;
        }
    }

    public boolean hasEtc() {
        try {
            return this.moreObject() != null;
        }
        catch (HDSException e) {
            throw new RuntimeException(e);
        }
    }

    public Source getEtc() {
        try {
            HDSObject more = this.moreObject();
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element etc = doc.createElement("etc");
            int ncomp = more.datNcomp();
            for (int i = 0; i < ncomp; ++i) {
                HDSObject extobj = more.datIndex(i + 1);
                String name = extobj.datName();
                String type = extobj.datType();
                Element extel = doc.createElement(name);
                extel.setAttribute("type", type);
                Comment content = doc.createComment("Extension content not yet implemented");
                extel.appendChild(content);
                etc.appendChild(extel);
            }
            return new DOMSource(etc);
        }
        catch (HDSException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public int getBadBits() {
        try {
            HDSObject bbobj;
            HDSObject qcomp;
            if (this.ndf.datThere("QUALITY") && (qcomp = this.ndf.datFind("QUALITY")).datThere("BADBITS") && !(bbobj = qcomp.datFind("BADBITS")).datStruc() && (bbobj.datType().equals("_UBYTE") || bbobj.datType().equals("_BYTE")) && bbobj.datShape().length == 0) {
                byte bbval = (byte)bbobj.datGet0i();
                return bbval;
            }
            return 0;
        }
        catch (HDSException e) {
            throw new RuntimeException(e);
        }
    }

    public NDArray getImage() {
        return this.image;
    }

    public boolean hasVariance() {
        return this.variance != null;
    }

    public NDArray getVariance() {
        return this.variance;
    }

    public boolean hasQuality() {
        return this.quality != null;
    }

    public NDArray getQuality() {
        return this.quality;
    }

    private static NDArray[] makeArrayData(HDSObject ndf, URL persistentUrl, AccessMode mode) throws HDSException {
        String qname;
        URL iurl;
        ArrayStructure iary;
        String iname;
        BridgeNDArray inda = null;
        BridgeNDArray vnda = null;
        BridgeNDArray qnda = null;
        if (!ndf.datStruc()) {
            throw new IllegalArgumentException("Not a structure");
        }
        String proto = null;
        HDSReference baseRef = null;
        URL context = null;
        if (persistentUrl != null) {
            proto = persistentUrl.getProtocol();
            try {
                String frag = persistentUrl.getRef();
                URL baseUrl = new URL("file:" + persistentUrl.getFile() + (frag != null ? "#" + frag : ""));
                baseRef = new HDSReference(baseUrl);
                context = new URL(persistentUrl.getProtocol(), persistentUrl.getHost(), persistentUrl.getPort(), persistentUrl.getFile());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (ndf.datThere(iname = "DATA_ARRAY")) {
            HDSObject iobj = ndf.datFind(iname);
            iary = new ArrayStructure(iobj);
            iurl = null;
            if (baseRef != null) {
                HDSReference iref = (HDSReference)baseRef.clone();
                iref.push(iname);
                iurl = URLUtils.makeURL((String)context.toString(), (String)NDFNdxImpl.getLocation(iref));
            }
        } else {
            throw new IllegalArgumentException("No DATA_ARRAY component - not an NDF");
        }
        inda = new BridgeNDArray((ArrayImpl)new HDSArrayImpl(iary, mode), iurl);
        String vname = "VARIANCE";
        if (ndf.datThere(vname)) {
            HDSObject vobj = ndf.datFind(vname);
            ArrayStructure vary = new ArrayStructure(vobj);
            URL vurl = null;
            if (baseRef != null) {
                HDSReference vref = (HDSReference)baseRef.clone();
                vref.push(vname);
                vurl = URLUtils.makeURL((String)context.toString(), (String)NDFNdxImpl.getLocation(vref));
            }
            vnda = new BridgeNDArray((ArrayImpl)new HDSArrayImpl(vary, mode), vurl);
        }
        if (ndf.datThere(qname = "QUALITY")) {
            HDSObject qobj = ndf.datFind(qname);
            URL qurl = null;
            HDSReference qref = null;
            if (baseRef != null) {
                qref = (HDSReference)baseRef.clone();
                qref.push(qname);
                qurl = URLUtils.makeURL((String)context.toString(), (String)NDFNdxImpl.getLocation(qref));
            }
            if (qobj.datType().equals("QUALITY")) {
                String qsubname = "QUALITY";
                if (qref != null) {
                    qref.push(qsubname);
                    qurl = URLUtils.makeURL((String)context.toString(), (String)NDFNdxImpl.getLocation(qref));
                }
                qobj = qobj.datFind(qsubname);
            }
            ArrayStructure qary = new ArrayStructure(qobj);
            qnda = new BridgeNDArray((ArrayImpl)new HDSArrayImpl(qary, mode), qurl);
        }
        return new NDArray[]{inda, vnda, qnda};
    }

    protected static String getLocation(HDSReference ref) {
        URL url = ref.getURL();
        String frag = url.getRef();
        if (frag != null) {
            return url.getPath() + "#" + frag;
        }
        return url.getPath();
    }

    private HDSObject wcsArray() {
        try {
            HDSObject warr;
            HDSObject wobj;
            if (this.ndf.datThere("WCS") && (wobj = this.ndf.datFind("WCS")).datThere("DATA") && !(warr = wobj.datFind("DATA")).datStruc() && warr.datType().startsWith("_CHAR") && warr.datShape().length == 1) {
                return warr;
            }
            return null;
        }
        catch (HDSException e) {
            throw new RuntimeException(e);
        }
    }

    private HDSObject axisArray() {
        try {
            if (this.ndf.datThere("AXIS")) {
                HDSObject aobj = this.ndf.datFind("AXIS");
                long[] ashape = aobj.datShape();
                if (aobj.datStruc() && ashape.length == 1) {
                    return aobj;
                }
                logger.warning("Ignoring strangely-formed AXIS component");
                return null;
            }
            return null;
        }
        catch (HDSException e) {
            throw new RuntimeException(e);
        }
    }

    private HDSObject moreObject() throws HDSException {
        HDSObject more;
        if (this.ndf.datThere("MORE") && (more = this.ndf.datFind("MORE")).datStruc()) {
            return more;
        }
        return null;
    }

    static {
        $assertionsDisabled = !NDFNdxImpl.class.desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.hds");
    }
}

