/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hds;

import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Logger;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.ArrayAccess;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.ChunkStepper;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDArrays;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Order;
import uk.ac.starlink.array.Requirements;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.ast.AstObject;
import uk.ac.starlink.ast.Channel;
import uk.ac.starlink.ast.Frame;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.ast.Mapping;
import uk.ac.starlink.ast.UnitMap;
import uk.ac.starlink.ast.WinMap;
import uk.ac.starlink.hds.ArrayStructure;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;
import uk.ac.starlink.hds.HDSReference;
import uk.ac.starlink.hds.HDSType;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.util.GenericNioBuffer;

public class NdfMaker {
    private HDSType hdstype;
    private NDShape window;
    private static Logger logger = Logger.getLogger("uk.ac.starlink.hds");
    private static final long[] SCALAR_DIMS = new long[0];

    public void setType(HDSType hdstype) {
        this.hdstype = hdstype;
    }

    public HDSType getType() {
        return this.hdstype;
    }

    public void setWindow(NDShape window) {
        this.window = window;
    }

    public NDShape getWindow() {
        return this.window;
    }

    public HDSReference makeTempNDF(Ndx ndx) throws IOException {
        File tmpfile = File.createTempFile("ndf", ".sdf", this.getTmpDir());
        tmpfile.delete();
        String container = tmpfile.getPath();
        container = container.replaceFirst(".sdf$", "");
        return this.makeNDF(ndx, container);
    }

    public HDSReference makeNDF(Ndx ndx, String container) throws IOException {
        HDSReference ndfref;
        HDSObject ndfob;
        String name = new File(container).getName().toUpperCase();
        if (name.length() > HDSObject.DAT__SZNAM) {
            name = name.substring(0, HDSObject.DAT__SZNAM);
        }
        try {
            ndfob = HDSObject.hdsNew(container, name, "NDF", SCALAR_DIMS);
            ndfref = new HDSReference(ndfob);
        }
        catch (HDSException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        this.makeNDF(ndx, ndfob);
        return ndfref;
    }

    public void makeNDF(Ndx ndx, HDSObject ndfob) throws IOException {
        try {
            this.copyNdxToNdf(ndx, ndfob, true);
        }
        catch (HDSException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public void makeBlankNDF(Ndx ndx, HDSObject ndfob) throws IOException {
        try {
            this.copyNdxToNdf(ndx, ndfob, false);
        }
        catch (HDSException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private File getTmpDir() {
        String dirname = null;
        if (dirname == null) {
            dirname = System.getProperty("uk.ac.starlink.hds.scratch");
        }
        if (dirname == null) {
            dirname = System.getProperty("java.io.tmpdir");
        }
        if (dirname == null) {
            dirname = ".";
        }
        return new File(dirname);
    }

    private void copyNdxToNdf(Ndx ndx, HDSObject ndfob, boolean copyData) throws HDSException, IOException {
        NDShape shape = this.window == null ? ndx.getImage().getShape() : this.window;
        this.copyArray(ndx.getImage(), ndfob, "DATA_ARRAY", shape, this.hdstype, copyData);
        if (ndx.hasVariance()) {
            this.copyArray(ndx.getVariance(), ndfob, "VARIANCE", shape, this.hdstype, copyData);
        }
        if (ndx.hasQuality()) {
            NDArray qnda;
            ndfob.datNew("QUALITY", "QUALITY", SCALAR_DIMS);
            HDSObject qobj = ndfob.datFind("QUALITY");
            int ibad = ndx.getBadBits();
            if (ibad > 0) {
                qobj.datNew("BADBITS", "_UBYTE", SCALAR_DIMS);
                qobj.datFind("BADBITS").datPut0i(ibad);
            }
            if ((qnda = ndx.getQuality()).getType() != Type.BYTE) {
                logger.warning("Truncating Quality component from " + qnda.getType().getNumBytes() * 8 + " to 8 bits");
            }
            this.copyArray(qnda, qobj, "QUALITY", shape, HDSType._UBYTE, copyData);
            HDSObject qcomp = qobj.datFind("QUALITY");
            qcomp.datNew("BAD_PIXEL", "_LOGICAL", SCALAR_DIMS);
            qcomp.datFind("BAD_PIXEL").datPut0l(false);
        }
        if (ndx.hasTitle()) {
            String title = ndx.getTitle();
            ndfob.datNew("TITLE", "_CHAR*" + title.length(), SCALAR_DIMS);
            ndfob.datFind("TITLE").datPut0c(title);
        }
        if (ndx.hasLabel()) {
            String label = ndx.getLabel();
            ndfob.datNew("LABEL", "_CHAR*" + label.length(), SCALAR_DIMS);
            ndfob.datFind("LABEL").datPut0c(label);
        }
        if (ndx.hasUnits()) {
            String units = ndx.getUnits();
            ndfob.datNew("UNITS", "_CHAR*" + units.length(), SCALAR_DIMS);
            ndfob.datFind("UNITS").datPut0c(units);
        }
        if (ndx.hasWCS()) {
            FrameSet wcs = NdfMaker.doctorForNDF(ndx.getAst(), shape);
            int nchars = 32;
            char[] blanks = new char[32];
            Arrays.fill(blanks, ' ');
            final String blank = new String(blanks);
            final ArrayList lines = new ArrayList();
            Channel lchan = new Channel(){

                protected void sink(String line) {
                    line = line.trim();
                    int pos = 0;
                    int leng = line.length();
                    while (pos < leng) {
                        StringBuffer sbuf = new StringBuffer(blank);
                        sbuf.setCharAt(0, pos == 0 ? (char)' ' : '+');
                        for (int i = 1; pos < leng && i < 32; ++i, ++pos) {
                            sbuf.setCharAt(i, line.charAt(pos));
                        }
                        lines.add(sbuf.toString());
                    }
                }
            };
            lchan.setComment(false);
            lchan.setFull(-1);
            lchan.write((AstObject)wcs);
            int nline = lines.size();
            ndfob.datNew("WCS", "WCS", SCALAR_DIMS);
            HDSObject wcsholder = ndfob.datFind("WCS");
            wcsholder.datNew("DATA", "_CHAR*32", new long[]{nline});
            HDSObject wcsob = wcsholder.datFind("DATA");
            long[] pos = new long[]{1L};
            Iterator it = lines.iterator();
            while (it.hasNext()) {
                wcsob.datCell(pos).datPut0c((String)it.next());
                pos[0] = pos[0] + 1L;
            }
        }
        ndfob.datAnnul();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyArray(NDArray nda, HDSObject parent, String name, NDShape shape, HDSType htype, boolean copyData) throws HDSException, IOException {
        if (htype == null) {
            htype = this.hdstype;
        }
        if (htype == null) {
            htype = HDSType.fromJavaType(nda.getType());
        }
        ArrayStructure ary = new ArrayStructure(parent, name, htype, shape);
        if (copyData) {
            long[] dims = shape.getDims();
            Type jtype = htype.getJavaType();
            BadHandler handler = BadHandler.getHandler((Type)jtype, (Number)htype.getBadValue());
            Requirements req = new Requirements(AccessMode.READ).setOrder(Order.COLUMN_MAJOR).setWindow(shape).setType(jtype).setBadHandler(handler);
            nda = NDArrays.toRequiredArray((NDArray)nda, (Requirements)req);
            HDSObject data = ary.getData();
            Buffer mapped = data.datMapv(htype.getName(), "WRITE");
            GenericNioBuffer genbuf = new GenericNioBuffer(mapped);
            ChunkStepper cit = new ChunkStepper(shape.getNumPixels());
            Object buf = htype.getJavaType().newArray(cit.getSize());
            ArrayAccess acc = nda.getAccess();
            try {
                while (cit.hasNext()) {
                    int size = cit.getSize();
                    acc.read(buf, 0, size);
                    genbuf.put(buf, 0, size);
                    cit.next();
                }
            }
            finally {
                acc.close();
                data.datUnmap();
            }
        }
    }

    private static FrameSet doctorForNDF(FrameSet origWcs, NDShape shape) {
        if (origWcs.getNframe() >= 3 && origWcs.getFrame(1).getDomain().equals("GRID") && origWcs.getFrame(2).getDomain().equals("PIXEL") && origWcs.getFrame(3).getDomain().equals("AXIS")) {
            return origWcs;
        }
        if (origWcs.getNframe() >= 2 && origWcs.getFrame(1).getDomain().equals("GRID") && origWcs.getFrame(2).getDomain().equals("PIXEL")) {
            FrameSet wcs = (FrameSet)origWcs.copy();
            while (wcs.getNframe() > 2) {
                wcs.removeFrame(wcs.getNframe());
            }
            Frame axframe = (Frame)wcs.getFrame(2).copy();
            axframe.setDomain("AXIS");
            int ndim = axframe.getNaxes();
            wcs.addFrame(2, (Mapping)new UnitMap(ndim), axframe);
            int extras = origWcs.getNframe() - 2;
            for (int i = 0; i < extras; ++i) {
                wcs.addFrame(FrameSet.AST__BASE, origWcs.getMapping(FrameSet.AST__BASE, i + 3).simplify(), origWcs.getFrame(i + 3));
            }
            int cur = origWcs.getCurrent();
            wcs.setCurrent(cur <= 2 ? cur : cur + 1);
            return wcs;
        }
        Frame gridframe = (Frame)origWcs.getFrame(1).copy();
        gridframe.setDomain("GRID");
        FrameSet wcs = new FrameSet(gridframe);
        int ndim = shape.getNumDims();
        double[] ina = new double[ndim];
        double[] inb = new double[ndim];
        double[] outa = new double[ndim];
        double[] outb = new double[ndim];
        for (int i = 0; i < ndim; ++i) {
            double trans = (double)shape.getOrigin()[i] - 0.5;
            ina[i] = 0.0;
            inb[i] = 1.0;
            outa[i] = ina[i] + trans;
            outb[i] = inb[i] + trans;
        }
        WinMap pmap = new WinMap(ndim, ina, inb, outa, outb);
        Frame pixframe = new Frame(ndim);
        pixframe.setDomain("PIXEL");
        wcs.addFrame(1, (Mapping)pmap, pixframe);
        Frame axframe = new Frame(ndim);
        axframe.setDomain("AXIS");
        wcs.addFrame(2, (Mapping)new UnitMap(ndim), axframe);
        int extras = origWcs.getNframe() - 1;
        for (int i = 0; i < extras; ++i) {
            wcs.addFrame(FrameSet.AST__BASE, origWcs.getMapping(FrameSet.AST__BASE, i + 2).simplify(), origWcs.getFrame(i + 2));
        }
        int cur = origWcs.getCurrent();
        wcs.setCurrent(cur <= 1 ? cur : cur + 2);
        return wcs;
    }
}

