/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.skiplist;

import edu.jhu.skiplist.SkipList;
import edu.jhu.skiplist.SkipListElement;
import edu.jhu.skiplist.SkipListRenderer;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Event;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextField;

public class SkipListApplet
extends Applet {
    private SkipListRenderer mySkipListRenderer;
    private SkipList mySkipList = new SkipList(0.5f, 6);
    private TextField myKeyTextField;
    private TextField myValueTextField;
    private TextField myOutputTextField;
    private Button myInsertButton;
    private Button mySearchButton;
    private Button myDeleteButton;
    private Button myRandomizeButton;
    private Button myResetButton;
    private Scrollbar myScrollbar;

    public SkipListApplet() {
        this.mySkipListRenderer = new SkipListRenderer(this, this.mySkipList);
    }

    public void init() {
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.add(new Label("SkipList Demonstration     (C) 1997 Thomas Wenger      "));
        this.myRandomizeButton = new Button("Insert 10 Random nodes");
        panel.add(this.myRandomizeButton);
        this.myResetButton = new Button("Reset");
        panel.add(this.myResetButton);
        this.add("North", panel);
        this.add("Center", this.mySkipListRenderer);
        Panel panel2 = new Panel();
        panel2.add(new Label("Key:"));
        this.myKeyTextField = new TextField(6);
        panel2.add(this.myKeyTextField);
        panel2.add(new Label("Value:"));
        this.myValueTextField = new TextField(6);
        panel2.add(this.myValueTextField);
        this.myKeyTextField.setText("");
        this.myValueTextField.setText("0");
        this.myInsertButton = new Button("Insert");
        panel2.add(this.myInsertButton);
        this.mySearchButton = new Button("Search");
        panel2.add(this.mySearchButton);
        this.myDeleteButton = new Button("Delete");
        panel2.add(this.myDeleteButton);
        panel2.add(new Label("Result:"));
        this.myOutputTextField = new TextField(35);
        panel2.add(this.myOutputTextField);
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        this.myScrollbar = new Scrollbar(0, 0, 250, 0, 1000);
        panel3.add("North", this.myScrollbar);
        panel3.add("South", panel2);
        this.add("South", panel3);
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.myScrollbar && (event.id == 601 || event.id == 602 || event.id == 603 || event.id == 604 || event.id == 605)) {
            int n = (Integer)event.arg;
            Rectangle rectangle = this.mySkipListRenderer.bounds();
            int n2 = this.mySkipListRenderer.calculateImageWidth() - rectangle.width;
            n2 = n2 < 0 ? 0 : n2;
            int n3 = (int)((float)(-n) / 1000.0f * (float)n2);
            this.mySkipListRenderer.setXOffset(n3);
            this.mySkipListRenderer.repaint();
            return true;
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.myInsertButton) {
            long l = Integer.parseInt(this.myKeyTextField.getText());
            long l2 = Integer.parseInt(this.myValueTextField.getText());
            this.myKeyTextField.setText("");
            this.myValueTextField.setText("0");
            this.mySkipList.insert(l, l2);
            this.myOutputTextField.setText("Node (k=" + l + ", v=" + l2 + ") inserted.");
            this.mySkipListRenderer.repaint();
            return true;
        }
        if (event.target == this.mySearchButton) {
            long l = Integer.parseInt(this.myKeyTextField.getText());
            long l3 = this.mySkipList.search(l);
            this.myKeyTextField.setText("");
            this.myValueTextField.setText("0");
            if (l3 != -1L) {
                this.myOutputTextField.setText("Found: Node (k=" + l + ", v=" + l3 + ")");
            } else {
                this.myOutputTextField.setText("Not found: Node with k=" + l);
            }
            return true;
        }
        if (event.target == this.myDeleteButton) {
            long l = Integer.parseInt(this.myKeyTextField.getText());
            long l4 = this.mySkipList.search(l);
            this.myKeyTextField.setText("");
            this.myValueTextField.setText("0");
            if (l4 != -1L && l != Integer.MAX_VALUE) {
                this.mySkipList.delete(l);
                this.myOutputTextField.setText("Deleted: Node (k=" + l + ", v=" + l4 + ")");
                this.mySkipListRenderer.repaint();
            } else {
                this.myOutputTextField.setText("Not deleted: No node with k=" + l);
            }
            return true;
        }
        if (event.target == this.myRandomizeButton) {
            int n = 0;
            while (n < 10) {
                long l = (long)(Math.random() * 100.0);
                long l5 = (long)(Math.random() * 100.0);
                this.mySkipList.insert(l, l5);
                ++n;
            }
            this.myOutputTextField.setText("10 random nodes inserted");
            this.mySkipListRenderer.repaint();
            return true;
        }
        if (event.target == this.myResetButton) {
            this.mySkipList = new SkipList(0.5f, 6);
            this.mySkipListRenderer.setSkipList(this.mySkipList);
            this.mySkipListRenderer.setXOffset(0);
            this.mySkipListRenderer.repaint();
            this.myScrollbar.setValue(0);
            this.myOutputTextField.setText("List reseted.");
            return true;
        }
        return super.action(event, object);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (event.target == this.mySkipListRenderer) {
            SkipListElement skipListElement = this.mySkipListRenderer.findElementAt(n, n2);
            if (skipListElement != null && skipListElement.key >= 0L && skipListElement.key < Integer.MAX_VALUE) {
                this.myKeyTextField.setText(Long.toString(skipListElement.key));
                this.myValueTextField.setText(Long.toString(skipListElement.value));
                this.myOutputTextField.setText("Node selected.");
            }
            return true;
        }
        return false;
    }
}

