/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.jaiutil;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.io.IOException;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.jaiutil.NDArrayData;

public class NDArrayDataFloat
extends NDArrayData {
    public NDArrayDataFloat(NDArray nda) throws IOException {
        super(nda);
    }

    public NDArrayDataFloat(NDArray nda, int[] axes) throws IOException {
        super(nda, axes);
    }

    public Raster getTile(Raster tile, int subsample, int scaledWidth, int scaledHeight) throws IOException {
        float[] destArray = NDArrayDataFloat.getRasterArray(tile);
        int tw = tile.getWidth();
        int th = tile.getHeight();
        int x0 = tile.getMinX();
        int y0 = tile.getMinY();
        if (subsample == 1) {
            this.fillTile(destArray, x0, y0, tw, th);
        } else {
            int x1 = Math.min(x0 + tw - 1, scaledWidth - 1);
            int y1 = Math.min(y0 + th - 1, scaledHeight - 1);
            for (int j = y0; j <= y1; ++j) {
                int dst = (j - y0) * tw;
                long src = (j * this.width + x0) * subsample;
                for (int i = x0; i <= x1; ++i) {
                    this.tiler.setOffset(src);
                    this.tiler.read(destArray, dst++, 1);
                    src += (long)subsample;
                }
            }
        }
        return tile;
    }

    public Raster getPreviewImage(Raster tile, int factor) throws IOException {
        float[] destArray = NDArrayDataFloat.getRasterArray(tile);
        float[] line = new float[this.width];
        int tw = tile.getWidth();
        int th = tile.getHeight();
        int w = tw * factor;
        int h = th * factor;
        int n = 0;
        int m = 0;
        try {
            for (int j = 0; j < h; j += factor) {
                n = m++ * tw;
                this.fillTile(line, 0, j, this.width, 1);
                for (int i = 0; i < w; i += factor) {
                    destArray[n++] = line[i];
                }
            }
            return tile;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static float[] getRasterArray(Raster tile) {
        DataBuffer dataBuffer = tile.getDataBuffer();
        if (dataBuffer instanceof javax.media.jai.DataBufferFloat) {
            return ((javax.media.jai.DataBufferFloat)dataBuffer).getData();
        }
        return ((DataBufferFloat)dataBuffer).getData();
    }
}

