/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hdx;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.hdx.HdxContainer;
import uk.ac.starlink.hdx.HdxException;
import uk.ac.starlink.hdx.HdxFactory;
import uk.ac.starlink.hdx.HdxResourceType;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.util.NodeDescendants;

class DomHdxContainer
implements HdxContainer {
    private Element hdxElement;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    DomHdxContainer(Element dom) throws HdxException {
        if (dom == null) {
            throw new HdxException("Received null DOM");
        }
        this.hdxElement = dom;
        if (!this.hdxElement.getTagName().equals(HdxResourceType.HDX.xmlName())) {
            throw new HdxException("DOM malformed: document element is " + this.hdxElement.getTagName() + ", not " + HdxResourceType.HDX.xmlName());
        }
    }

    public Object get(HdxResourceType type) {
        if (!$assertionsDisabled && !this.hdxElement.getTagName().equals(HdxResourceType.HDX.xmlName())) {
            throw new AssertionError();
        }
        try {
            Iterator ni = new NodeDescendants(this.hdxElement, 1).iterator();
            while (ni.hasNext()) {
                Object ret;
                Element el = (Element)ni.next();
                if (HdxResourceType.match(el) != type || (ret = HdxFactory.getInstance().getObject(el)) == null) continue;
                return ret;
            }
        }
        catch (HdxException ex) {
            logger.warning("Unexpected error constructing object: " + ex);
        }
        return null;
    }

    public List getList(HdxResourceType type) {
        if (!$assertionsDisabled && !this.hdxElement.getTagName().equals(HdxResourceType.HDX.xmlName())) {
            throw new AssertionError();
        }
        ArrayList<Object> retlist = new ArrayList<Object>();
        try {
            HdxFactory factory = HdxFactory.getInstance();
            Iterator ni = new NodeDescendants(this.hdxElement).iterator();
            while (ni.hasNext()) {
                Object t;
                Element el;
                Node child = (Node)ni.next();
                if (child.getNodeType() != 1 || HdxResourceType.match(el = (Element)child) != type || (t = factory.getObject(el)) == null) continue;
                retlist.add(t);
            }
        }
        catch (HdxException ex) {
            logger.warning("Unexpected error constructing object: " + ex);
        }
        return retlist;
    }

    public Element getDOM(URI base) {
        if (base == null) {
            return this.hdxElement;
        }
        Element t = (Element)DOMUtils.relativizeDOM(this.hdxElement.cloneNode(true), base, null);
        return t;
    }

    public Source getSource(URI base) {
        return new DOMSource(this.getDOM(base));
    }

    static {
        $assertionsDisabled = !DomHdxContainer.class.desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.hdx");
    }
}

