/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hdx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.starlink.hdx.HdxDOMImplementation;
import uk.ac.starlink.hdx.HdxDocument;
import uk.ac.starlink.hdx.HdxNode;
import uk.ac.starlink.hdx.HdxResourceType;
import uk.ac.starlink.util.NodeDescendants;

class HdxElement
extends HdxNode
implements Element,
Cloneable {
    private String giName;
    private AttributeMap attributeMap;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    HdxElement(String giName, Document owner) throws DOMException {
        this(null, new ElementTypeInfo(giName, null), false, owner);
        this.giName = giName;
        if (!$assertionsDisabled && this.giName == null) {
            throw new AssertionError();
        }
    }

    private HdxElement(Element el, ElementTypeInfo setType, boolean inNamespace, Document owner) {
        super((short)1, owner);
        ElementTypeInfo inf;
        if (!$assertionsDisabled && owner == null) {
            throw new AssertionError();
        }
        if (setType == null) {
            if (el == null) {
                throw new IllegalArgumentException("HdxElement(null,null,...)");
            }
            inf = HdxElement.getElementTypeInfo(el, inNamespace ? 1 : -1);
        } else {
            inf = setType;
        }
        this.giName = inf.getName();
        String backingNodeNSPrefix = inf.getPrefix();
        int attsToUse = inf.fromArch() ? 1 : (inf.fromNamespace() ? 3 : 2);
        if (!$assertionsDisabled && this.giName == null) {
            throw new AssertionError();
        }
        Element backingNode = el;
        logger.fine("HdxElement: giName=" + this.giName + " => type=" + this.getHdxType() + ", backing node?=" + (backingNode != null) + ", prefix=" + backingNodeNSPrefix);
        this.attributeMap = new AttributeMap((HdxDocument)owner, backingNode, backingNodeNSPrefix, attsToUse);
        if (backingNode == null) {
            if (!$assertionsDisabled && backingNodeNSPrefix != null) {
                throw new AssertionError();
            }
            return;
        }
        if (!$assertionsDisabled && el == null) {
            throw new AssertionError();
        }
        String hoist = this.getHdxType().getHoistAttribute();
        if (hoist != null && !this.hasAttribute(hoist) && el.hasChildNodes()) {
            NodeList nl = el.getChildNodes();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n.getNodeType() != 3) continue;
                sb.append(n.getNodeValue());
            }
            String textval = sb.toString().trim();
            if (textval.length() != 0) {
                this.setAttribute(hoist, textval, false);
            }
        }
    }

    private static ElementTypeInfo getElementTypeInfo(Element el, int nsswitch) {
        if (el == null) {
            return new ElementTypeInfo(null, null);
        }
        String gins = el.getNamespaceURI();
        if (nsswitch >= 0) {
            if (gins != null && gins.equals("http://www.starlink.ac.uk/HDX")) {
                return new ElementTypeInfo(el.getLocalName(), el.getPrefix());
            }
            Attr hdxname = el.getAttributeNodeNS("http://www.starlink.ac.uk/HDX", "hdxname");
            if (hdxname != null) {
                ElementTypeInfo inf = new ElementTypeInfo(hdxname.getValue(), hdxname.getPrefix());
                inf.setArch(true);
                return inf;
            }
        }
        if (nsswitch <= 0 && gins == null) {
            return new ElementTypeInfo(el.getTagName(), null);
        }
        return new ElementTypeInfo(null, null);
    }

    static DocumentFragment constructHdxElementTree(Element el) {
        boolean useNS;
        ElementTypeInfo inf = HdxElement.getElementTypeInfo(el, 0);
        boolean bl = useNS = inf.getType() == HdxResourceType.NONE || inf.fromNamespace();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("constructHdxElementTree:" + el.toString() + ", useNS=" + useNS);
        }
        Document tdoc = HdxDOMImplementation.getInstance().createDocument(null, "dummy", null);
        DocumentFragment df = tdoc.createDocumentFragment();
        HdxElement.addHdxChildren(df, el, useNS);
        if (!df.hasChildNodes()) {
            return null;
        }
        if (((HdxElement)df.getFirstChild()).getHdxType() == HdxResourceType.HDX) {
            for (HdxElement kid = (HdxElement)df.getFirstChild(); kid != null; kid = (HdxElement)kid.getNextSibling()) {
                if (kid.getHdxType() == HdxResourceType.HDX) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("constructHdxElementTree: not all children are HDX!");
                }
                return null;
            }
            return df;
        }
        for (HdxElement kid = (HdxElement)df.getFirstChild(); kid != null; kid = (HdxElement)kid.getNextSibling()) {
            if (kid.getHdxType() == HdxResourceType.HDX) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("constructHdxElementTree: unexpected Hdx");
                }
                return null;
            }
            if (kid.getHdxType() != HdxResourceType.NONE) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("constructHdxElementTree: unregistered type");
            }
            return null;
        }
        DocumentFragment newfrag = tdoc.createDocumentFragment();
        Element newhdx = tdoc.createElement(HdxResourceType.HDX.xmlName());
        newfrag.appendChild(newhdx);
        newhdx.appendChild(df);
        return newfrag;
    }

    private static void addHdxChildren(Node parent, Element el, boolean useNS) {
        Node fosterParent;
        if (!$assertionsDisabled && !(parent instanceof HdxNode)) {
            throw new AssertionError();
        }
        ElementTypeInfo elType = HdxElement.getElementTypeInfo(el, useNS ? 1 : -1);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("addHdxChildren(" + ((HdxNode)parent).toString() + ", " + el.getTagName() + '(' + elType + "), " + useNS + ')');
        }
        if (elType.getName() == null) {
            fosterParent = parent;
        } else {
            fosterParent = new HdxElement(el, elType, useNS, parent.getOwnerDocument());
            parent.appendChild(fosterParent);
        }
        for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1) continue;
            HdxElement.addHdxChildren(fosterParent, (Element)kid, useNS);
        }
    }

    private HdxResourceType getHdxType() {
        return HdxResourceType.match(this.giName);
    }

    public void setShadowAttributes(boolean shadow) {
        this.attributeMap.shadowNewAttributes = shadow;
    }

    public String getTagName() {
        return this.giName;
    }

    public boolean hasAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return this.attributeMap.containsKey(name);
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        if (localName == null) {
            throw new IllegalArgumentException("localName is null");
        }
        try {
            this.trapHdxNamespace(namespaceURI);
            if (namespaceURI == null) {
                return this.hasAttribute(localName);
            }
            return this.attributeMap.containsKey(namespaceURI, localName);
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    public String getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        Attr a = this.attributeMap.get(name);
        return a == null ? "" : a.getValue();
    }

    public Attr getAttributeNode(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return this.attributeMap.get(name);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        if (localName == null) {
            throw new IllegalArgumentException("localName is null");
        }
        try {
            this.trapHdxNamespace(namespaceURI);
        }
        catch (DOMException ex) {
            return "";
        }
        return this.attributeMap.getString(namespaceURI, localName);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        if (localName == null) {
            throw new IllegalArgumentException("localName is null");
        }
        try {
            this.trapHdxNamespace(namespaceURI);
        }
        catch (DOMException ex) {
            return null;
        }
        return this.attributeMap.get(namespaceURI, localName);
    }

    public void setAttribute(String name, String value) throws DOMException {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name or value is null");
        }
        this.attributeMap.set(name, value);
    }

    void setAttribute(String name, String value, boolean useBacking) throws DOMException {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name or value is null");
        }
        boolean tshadow = this.attributeMap.shadowNewAttributes;
        this.attributeMap.shadowNewAttributes = false;
        this.setAttribute(name, value);
        this.attributeMap.shadowNewAttributes = tshadow;
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        if (newAttr == null) {
            throw new IllegalArgumentException("newAttr is null");
        }
        Attr oldAtt = this.getAttributeNode(newAttr.getName());
        this.attributeMap.set(newAttr);
        return oldAtt;
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        if (qualifiedName == null || value == null) {
            throw new IllegalArgumentException("qualifiedName or value is null");
        }
        this.trapHdxNamespace(namespaceURI);
        if (namespaceURI != null) {
            throw new DOMException(14, "HdxElement elements can't take namespaced attributes");
        }
        this.setAttribute(qualifiedName, value);
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        if (newAttr == null) {
            throw new IllegalArgumentException("newAttr is null");
        }
        String namespaceURI = newAttr.getNamespaceURI();
        this.trapHdxNamespace(namespaceURI);
        if (namespaceURI == null) {
            return this.setAttributeNode(newAttr);
        }
        throw new DOMException(14, "HdxElement elements can't take namespaced attributes");
    }

    public void removeAttribute(String name) throws DOMException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.attributeMap.remove(name);
    }

    public Attr removeAttributeNode(Attr oldAtt) throws DOMException {
        if (oldAtt == null) {
            throw new IllegalArgumentException("oldAtt is null");
        }
        Attr att = this.getAttributeNode(oldAtt.getName());
        if (att == null) {
            throw new DOMException(8, "the attribute " + oldAtt.getName() + " is not present on that element");
        }
        this.removeAttribute(oldAtt.getName());
        return oldAtt;
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        if (localName == null) {
            throw new IllegalArgumentException("localName is null");
        }
        this.trapHdxNamespace(namespaceURI);
        if (namespaceURI == null) {
            this.removeAttribute(localName);
            return;
        }
        throw new DOMException(14, "HdxElement elements can't take namespaced attributes");
    }

    public NodeList getElementsByTagName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        class TagnameNodeList
        implements NodeList,
        NodeDescendants.Visitor {
            private final String selector;
            private ArrayList l = new ArrayList();
            private final /* synthetic */ String val$name;

            TagnameNodeList(String val$name) {
                this.val$name = val$name;
                this.selector = this.val$name.equals("*") ? null : this.val$name;
            }

            public int getLength() {
                return this.l.size();
            }

            public Node item(int index) {
                if (index < 0 || index >= this.l.size()) {
                    return null;
                }
                return (Node)this.l.get(index);
            }

            public Object visitNode(Node n) {
                if (this.selector == null || n.getNodeName().equals(this.selector)) {
                    this.l.add(n);
                }
                return null;
            }
        }
        TagnameNodeList tnl = new TagnameNodeList(name);
        NodeDescendants nd = new NodeDescendants(this, 1);
        nd.visitTree(tnl);
        return tnl;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        if (localName == null) {
            throw new IllegalArgumentException("localName is null");
        }
        return new NodeList(){

            public int getLength() {
                return 0;
            }

            public Node item(int index) {
                return null;
            }
        };
    }

    public String getNodeName() {
        return this.giName;
    }

    public boolean hasAttributes() {
        return this.attributeMap.size() != 0;
    }

    public NamedNodeMap getAttributes() {
        return new NamedNodeMap(){
            private List list = new ArrayList();
            {
                Iterator mi = HdxElement.this.attributeMap.iterator();
                while (mi.hasNext()) {
                    this.list.add(HdxElement.this.attributeMap.get((String)mi.next()));
                }
            }

            public int getLength() {
                return this.list.size();
            }

            public Node item(int index) {
                if (index < 0 || index >= this.getLength()) {
                    return null;
                }
                return (Node)this.list.get(index);
            }

            public Node getNamedItem(String name) {
                for (int i = 0; i < this.list.size(); ++i) {
                    Attr att = (Attr)this.list.get(i);
                    if (!att.getName().equals(name)) continue;
                    return att;
                }
                return null;
            }

            public Node getNamedItemNS(String namespaceURI, String localName) {
                return this.getNamedItem(localName);
            }

            public Node removeNamedItem(String name) throws DOMException {
                HdxElement.this.cannotModifyException("removeNamedItem");
                return null;
            }

            public Node removeNamedItemNS(String ns, String name) throws DOMException {
                HdxElement.this.cannotModifyException("removeNamedItemNS");
                return null;
            }

            public Node setNamedItem(Node n) throws DOMException {
                HdxElement.this.cannotModifyException("setNamedItem");
                return null;
            }

            public Node setNamedItemNS(Node n) throws DOMException {
                HdxElement.this.cannotModifyException("setNamedItemNS");
                return null;
            }
        };
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<");
        sb.append(this.getTagName());
        NamedNodeMap nodemap = this.getAttributes();
        for (int i = 0; i < nodemap.getLength(); ++i) {
            Attr att = (Attr)nodemap.item(i);
            sb.append(' ');
            sb.append(att.getName());
            sb.append("=\"");
            sb.append(att.getValue());
            sb.append('\"');
        }
        sb.append('>');
        return sb.toString();
    }

    public Node cloneNode(boolean deep) {
        HdxElement el = (HdxElement)super.clone(deep);
        el.attributeMap = (AttributeMap)this.attributeMap.clone();
        Iterator ai = el.attributeMap.iterator();
        while (ai.hasNext()) {
            String n = (String)ai.next();
            HdxAttr attr = (HdxAttr)el.attributeMap.get(n);
            attr.setOwnerElement(el);
        }
        return el;
    }

    protected Object clone(boolean deep) {
        HdxElement el = (HdxElement)super.clone(deep);
        el.attributeMap = (AttributeMap)this.attributeMap.clone();
        Iterator ai = el.attributeMap.iterator();
        while (ai.hasNext()) {
            String n = (String)ai.next();
            HdxAttr attr = (HdxAttr)el.attributeMap.get(n);
            attr.setOwnerElement(el);
        }
        return el;
    }

    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (!(t instanceof HdxElement)) {
            return false;
        }
        HdxElement te = (HdxElement)t;
        if (!this.giName.equals(te.giName)) {
            return false;
        }
        if (!this.attributeMap.equals(te.attributeMap)) {
            return false;
        }
        Node mykid = this.getFirstChild();
        Node tkid = te.getFirstChild();
        while (mykid != null) {
            if (tkid == null) {
                return false;
            }
            if (!mykid.equals(tkid)) {
                return false;
            }
            mykid = mykid.getNextSibling();
            tkid = tkid.getNextSibling();
        }
        return tkid == null;
    }

    public int hashCode() {
        HdxNode.HashCode hc = new HdxNode.HashCode(this.giName.hashCode());
        hc.add(this.attributeMap.hashCode());
        for (Node kid = this.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            hc.add(kid.hashCode());
        }
        return hc.value();
    }

    private void cannotModifyException(String methodName) throws DOMException {
        throw new DOMException(7, "HdxElement can't be modified using method " + methodName);
    }

    private void notSupportedException(String methodName) throws DOMException {
        throw new DOMException(9, "HdxElement doesn't support method " + methodName);
    }

    private void trapHdxNamespace(String namespaceURI) throws DOMException {
        if (namespaceURI != null && (namespaceURI.length() == 0 || namespaceURI.equals("http://www.starlink.ac.uk/HDX"))) {
            throw new DOMException(14, "HdxElement attributes must be in the empty namespace");
        }
    }

    static Attr newHdxAttr(String name, HdxDocument ownerDocument) {
        return HdxElement.newHdxAttr(name, "", null, ownerDocument, null);
    }

    private static Attr newHdxAttr(String name, String value, Attr shadow, HdxDocument ownerDocument, HdxElement ownerElement) {
        HdxAttr a = new HdxAttr(name, value, shadow, ownerDocument);
        a.setOwnerElement(ownerElement);
        return a;
    }

    static {
        $assertionsDisabled = !HdxElement.class.desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.hdx");
    }

    private class AttributeMap
    implements Cloneable {
        public static final int ATTS_NS = 1;
        public static final int ATTS_NONS = 2;
        private Map myMap;
        private final HdxDocument doc;
        private final Element shadowElement;
        private final String shadowElementPrefix;
        public boolean shadowNewAttributes;
        static final /* synthetic */ boolean $assertionsDisabled;

        public AttributeMap(HdxDocument doc, Element shadowElement, String shadowElementPrefix, int attsToUse) {
            this.doc = doc;
            this.shadowElement = shadowElement;
            this.shadowElementPrefix = shadowElementPrefix;
            this.shadowNewAttributes = true;
            this.myMap = new TreeMap();
            if (!$assertionsDisabled && !(this.myMap instanceof SortedMap)) {
                throw new AssertionError();
            }
            if (shadowElement != null) {
                NamedNodeMap shAtts = shadowElement.getAttributes();
                String elNS = shadowElement.getNamespaceURI();
                for (int i = 0; i < shAtts.getLength(); ++i) {
                    String myname;
                    Attr a = (Attr)shAtts.item(i);
                    String ns = a.getNamespaceURI();
                    if (!$assertionsDisabled && attsToUse == 0) {
                        throw new AssertionError();
                    }
                    boolean oneOfOurs = (attsToUse & 1) != 0 && ns != null && ns.equals("http://www.starlink.ac.uk/HDX") || (attsToUse & 2) != 0 && ns == null;
                    String string = myname = ns == null ? a.getName() : a.getLocalName();
                    if (myname.equals("hdxname")) {
                        oneOfOurs = false;
                    }
                    if (oneOfOurs) {
                        Attr newAttr = HdxElement.newHdxAttr(myname, null, a, doc, HdxElement.this);
                        this.myMap.put(myname, newAttr);
                        continue;
                    }
                    if (!a.getName().equals("xml:base")) continue;
                    this.myMap.put("xml:base", a);
                }
            }
        }

        public Attr get(String name) {
            return (Attr)this.myMap.get(name);
        }

        public Attr get(String namespaceURI, String localName) {
            if (namespaceURI == null) {
                return this.get(localName);
            }
            if (this.shadowElement != null) {
                return this.shadowElement.getAttributeNodeNS(namespaceURI, localName);
            }
            return null;
        }

        public String getString(String name) {
            Attr a = this.get(name);
            return a == null ? "" : a.getValue();
        }

        public String getString(String namespaceURI, String name) {
            Attr a = this.get(namespaceURI, name);
            return a == null ? "" : a.getValue();
        }

        public void set(String name, String value) throws DOMException {
            Attr attr = (Attr)this.myMap.get(name);
            if (attr == null) {
                boolean shadowIt = this.shadowNewAttributes && this.shadowElement != null;
                Attr newAttr = shadowIt ? HdxElement.newHdxAttr(name, null, this.newShadowAttr(name, value), this.doc, HdxElement.this) : HdxElement.newHdxAttr(name, value, null, this.doc, HdxElement.this);
                this.myMap.put(name, newAttr);
            } else {
                if (!$assertionsDisabled && !(attr instanceof HdxAttr)) {
                    throw new AssertionError();
                }
                attr.setValue(value);
            }
        }

        public void set(Attr att) throws DOMException {
            if (!(att instanceof HdxAttr)) {
                StringBuffer sb = new StringBuffer();
                sb.append("Attribute ").append(att.getName()).append('=').append(att.getValue()).append(" is class ").append(att.getClass().getName()).append(", not Hdx");
                throw new DOMException(4, sb.toString());
            }
            if (!$assertionsDisabled && att.getNamespaceURI() != null) {
                throw new AssertionError();
            }
            Attr curr = (Attr)this.myMap.get(att.getName());
            if (curr == null) {
                this.set(att.getName(), att.getValue());
            } else {
                ((HdxAttr)att).setOwnerElement(HdxElement.this);
                this.myMap.put(att.getName(), att);
            }
        }

        private Attr newShadowAttr(String name, String value) throws DOMException {
            Attr shAttr;
            if (!$assertionsDisabled && this.shadowElement == null) {
                throw new AssertionError();
            }
            if (this.shadowElementPrefix == null) {
                if (!$assertionsDisabled && this.shadowElement.hasAttribute(name)) {
                    throw new AssertionError();
                }
                this.shadowElement.setAttribute(name, value);
                shAttr = this.shadowElement.getAttributeNode(name);
            } else {
                if (!$assertionsDisabled && this.shadowElement.hasAttributeNS("http://www.starlink.ac.uk/HDX", name)) {
                    throw new AssertionError();
                }
                this.shadowElement.setAttributeNS("http://www.starlink.ac.uk/HDX", this.shadowElementPrefix + ':' + name, value);
                shAttr = this.shadowElement.getAttributeNodeNS("http://www.starlink.ac.uk/HDX", name);
            }
            return shAttr;
        }

        public void remove(String name) {
            this.myMap.remove(name);
        }

        public int size() {
            return this.myMap.size();
        }

        public boolean containsKey(String name) {
            return this.get(name) != null;
        }

        public boolean containsKey(String namespaceURI, String localName) {
            return this.get(namespaceURI, localName) != null;
        }

        public void clear() {
            this.myMap.clear();
        }

        public Iterator iterator() {
            return this.myMap.keySet().iterator();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            String nl = System.getProperty("line.separator");
            sb.append("AttributeMap:").append(nl);
            if (this.myMap == null) {
                sb.append("    <null>").append(nl);
            } else {
                Iterator i = this.myMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    sb.append("    ").append(e.getKey()).append('=').append(e.getValue()).append(nl);
                }
            }
            return sb.toString();
        }

        public Object clone() {
            try {
                AttributeMap a = (AttributeMap)super.clone();
                a.myMap = new TreeMap();
                Iterator i = this.myMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    a.myMap.put(e.getKey(), ((HdxAttr)e.getValue()).clone());
                }
                return a;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)"Can't happen: Object.clone() seemed to throw CloneNotSupportedException");
            }
        }

        public int hashCode() {
            if (!$assertionsDisabled && !(this.myMap instanceof SortedMap)) {
                throw new AssertionError();
            }
            HdxNode.HashCode hc = new HdxNode.HashCode();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                Attr val = this.get((String)i.next());
                if (!$assertionsDisabled && !(val instanceof HdxAttr)) {
                    throw new AssertionError();
                }
                hc.add(val.hashCode());
            }
            return hc.value();
        }

        public boolean equals(Object t) {
            if (t == null || !(t instanceof AttributeMap)) {
                return false;
            }
            if (t == this) {
                return true;
            }
            AttributeMap ta = (AttributeMap)t;
            if (this.myMap == null && ta.myMap != null) {
                return false;
            }
            if (ta.myMap == null) {
                return false;
            }
            if (this.myMap.size() != ta.myMap.size()) {
                return false;
            }
            Iterator i = this.iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (ta.containsKey(key) && this.getString(key).equals(ta.getString(key))) continue;
                return false;
            }
            return true;
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$hdx$HdxElement == null ? (class$uk$ac$starlink$hdx$HdxElement = HdxElement.class$("uk.ac.starlink.hdx.HdxElement")) : class$uk$ac$starlink$hdx$HdxElement).desiredAssertionStatus();
        }
    }

    private static final class HdxAttr
    extends HdxNode
    implements Attr {
        private final String name;
        private String value;
        private Attr shadowAttr;
        private HdxElement ownerElement;
        private Node textNode;
        static final /* synthetic */ boolean $assertionsDisabled;

        public HdxAttr(String name, String value, Attr shadowAttr, Document ownerDocument) {
            super((short)2, ownerDocument);
            this.name = name;
            this.value = value;
            this.shadowAttr = shadowAttr;
            if (!$assertionsDisabled && !(this.value != null ^ this.shadowAttr != null)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.name == null) {
                throw new AssertionError();
            }
        }

        void setOwnerElement(HdxElement ownerElement) {
            this.ownerElement = ownerElement;
        }

        public String getName() {
            return this.name;
        }

        public String getNodeName() {
            return this.getName();
        }

        public Element getOwnerElement() {
            return this.ownerElement;
        }

        public boolean getSpecified() {
            return true;
        }

        public String getValue() {
            if (this.value == null) {
                return this.shadowAttr.getValue();
            }
            return this.value;
        }

        public String getNodeValue() {
            return this.getValue();
        }

        public void setValue(String newValue) {
            if (this.value == null) {
                this.shadowAttr.setValue(newValue);
            } else {
                this.value = newValue;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("HdxAttr.setValue: " + this.name + '=' + this.getValue());
            }
            this.textNode = null;
        }

        public void setNodeValue(String newValue) {
            this.setValue(newValue);
        }

        public Node getFirstChild() {
            if (this.textNode == null) {
                this.textNode = this.getOwnerDocument().createTextNode(this.getValue());
            }
            return this.textNode;
        }

        public Node getLastChild() {
            return this.getFirstChild();
        }

        public Node cloneNode(boolean deep) {
            return (Node)this.clone();
        }

        public Object clone() {
            HdxAttr a = (HdxAttr)super.clone();
            a.value = new String(this.getValue());
            a.shadowAttr = null;
            return a;
        }

        public boolean equals(Object a) {
            if (a == null || !(a instanceof HdxAttr)) {
                return false;
            }
            if (a == this) {
                return true;
            }
            HdxAttr hdxa = (HdxAttr)a;
            return this.name.equals(hdxa.name) && this.getValue().equals(hdxa.getValue());
        }

        public int hashCode() {
            return new HdxNode.HashCode().add(this.name.hashCode()).add(this.getValue().hashCode()).value();
        }

        public String toString() {
            return "[" + this.name + '=' + this.getValue() + ']';
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$hdx$HdxElement == null ? (class$uk$ac$starlink$hdx$HdxElement = HdxElement.class$("uk.ac.starlink.hdx.HdxElement")) : class$uk$ac$starlink$hdx$HdxElement).desiredAssertionStatus();
        }
    }

    private static class ElementTypeInfo {
        private HdxResourceType t;
        private String hdxname;
        private String prefix;
        private boolean hadArchAttribute;

        public ElementTypeInfo(String typename, String prefix) {
            this.t = HdxResourceType.match(typename);
            this.hdxname = typename;
            this.prefix = prefix;
            this.hadArchAttribute = false;
        }

        public HdxResourceType getType() {
            return this.t;
        }

        public String getName() {
            return this.hdxname;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean fromNamespace() {
            return this.prefix != null;
        }

        public boolean fromArch() {
            return this.hadArchAttribute;
        }

        public void setArch(boolean is) {
            this.hadArchAttribute = is;
        }

        public String toString() {
            return (this.prefix == null ? "" : this.prefix) + ':' + this.hdxname;
        }
    }
}

