/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hdx;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.hdx.DomHdxContainer;
import uk.ac.starlink.hdx.HdxContainer;
import uk.ac.starlink.hdx.HdxDOMImplementation;
import uk.ac.starlink.hdx.HdxDocument;
import uk.ac.starlink.hdx.HdxDocumentFactory;
import uk.ac.starlink.hdx.HdxElement;
import uk.ac.starlink.hdx.HdxException;
import uk.ac.starlink.hdx.HdxFacade;
import uk.ac.starlink.hdx.HdxNode;
import uk.ac.starlink.hdx.HdxProperties;
import uk.ac.starlink.hdx.HdxResourceType;
import uk.ac.starlink.hdx.PluginException;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.util.URLUtils;

public class HdxFactory {
    private static HdxFactory defaultInstance;
    private static List hdxFactoryList;
    private static Logger logger;
    private static Map factoryMap;
    private static URI factoryBaseURI;
    static final /* synthetic */ boolean $assertionsDisabled;

    private HdxFactory(URI base) {
        factoryBaseURI = base;
    }

    public static HdxFactory getInstance() {
        if (defaultInstance == null) {
            defaultInstance = new HdxFactory(null);
        }
        return defaultInstance;
    }

    public static HdxFactory findFactory(Node el) {
        for (Node n = el; n != null; n = n.getParentNode()) {
            if (!factoryMap.containsKey(el)) continue;
            return (HdxFactory)factoryMap.get(el);
        }
        return HdxFactory.getInstance();
    }

    public static void registerHdxDocumentFactory(HdxDocumentFactory factory) {
        hdxFactoryList.add(0, factory);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Registered HdxDocumentFactory " + factory.getClass().getName());
        }
    }

    public HdxContainer newHdxContainer(URI uri) throws HdxException {
        return this.newHdxContainer(this.fullyResolveURI(uri, null));
    }

    public HdxContainer newHdxContainer(URL url) throws HdxException {
        try {
            Document hdxdom = null;
            url = this.fullyResolveURI(URLUtils.urlToUri(url), null);
            Iterator fi = hdxFactoryList.iterator();
            while (hdxdom == null && fi.hasNext()) {
                HdxDocumentFactory factory = (HdxDocumentFactory)fi.next();
                hdxdom = factory.makeHdxDocument(url);
                if (hdxdom == null || !logger.isLoggable(Level.FINE)) continue;
                logger.fine("newHdxDocumentFactory(url=" + url + "): success from HdxDocumentFactory " + factory.getClass().getName());
            }
            if (hdxdom == null) {
                return null;
            }
            Element docelem = hdxdom.getDocumentElement();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("newHdxContainer(" + url + ")  docelem=" + (docelem == null ? "null" : docelem.getTagName()));
            }
            if (docelem == null) {
                return null;
            }
            return this.newHdxContainer(docelem, URLUtils.urlToUri(url));
        }
        catch (MalformedURLException e) {
            throw new HdxException("URL " + url + " is malformed");
        }
    }

    public HdxContainer newHdxContainer(Element el) throws HdxException {
        return this.newHdxContainer(el, null);
    }

    public HdxContainer newHdxContainer(Element el, URI systemId) throws HdxException {
        Element hdx = this.validateHdxDOM(el);
        if (hdx == null) {
            return null;
        }
        if (hdx.getNextSibling() != null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Warning: element given to newHdxContainer included more than one HDX");
            }
            return null;
        }
        if (systemId != null) {
            HdxFactory newfactory = new HdxFactory(systemId);
            factoryMap.put(el, newfactory);
        }
        return new DomHdxContainer(hdx);
    }

    public HdxContainer newHdxContainer(HdxFacade facade) throws HdxException {
        if (facade == null) {
            throw new IllegalArgumentException("null facade given to newHdxContainer");
        }
        HdxDocument hdxdoc = (HdxDocument)HdxDOMImplementation.getInstance().createDocument(null, "hdx", null);
        Element hdx = hdxdoc.createElement("hdx");
        hdxdoc.appendChild(hdx);
        Element kid = hdxdoc.createElement(facade);
        hdx.appendChild(kid);
        return new DomHdxContainer(hdx);
    }

    public Object getObject(Element el) throws HdxException {
        HdxResourceType hdxType;
        block11: {
            hdxType = HdxResourceType.match(el);
            if (hdxType == HdxResourceType.NONE) {
                return null;
            }
            if (el.hasAttribute("uri") && !el.hasAttribute("url")) {
                try {
                    URI uri = new URI(el.getAttribute("uri"));
                    URL url = this.fullyResolveURI(uri, (Node)el);
                    if (url != null) {
                        if (el instanceof HdxElement) {
                            ((HdxElement)el).setAttribute("url", url.toString(), false);
                        } else {
                            el.setAttribute("url", url.toString());
                        }
                    }
                }
                catch (HdxException ex) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.warning("Failed to resolve URI: " + ex);
                    }
                }
                catch (URISyntaxException ex) {
                    if (!logger.isLoggable(Level.WARNING)) break block11;
                    logger.warning("Invalid URI: " + ex);
                }
            }
        }
        Object ret = null;
        if (el instanceof HdxNode) {
            ret = ((HdxNode)((Object)el)).getNodeObject();
        }
        if (ret == null) {
            ret = hdxType.getObject(el);
        }
        return ret;
    }

    public URL fullyResolveURI(URI uri, Node context) throws HdxException {
        try {
            String scheme = uri.getScheme();
            if (scheme != null && scheme.toLowerCase().equals("file")) {
                String ssp = uri.getSchemeSpecificPart();
                String frag = uri.getFragment();
                uri = new URI(null, ssp, frag);
            }
            if (uri.isAbsolute()) {
                return uri.toURL();
            }
            URI baseURI = this.getBaseURI(context);
            if (baseURI == null) {
                baseURI = new File("").getAbsoluteFile().toURI();
            }
            if (!baseURI.isAbsolute()) {
                throw new HdxException("Can't find any base URI");
            }
            URI resolvedURI = baseURI.resolve(uri);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("fullyResolveURI: uri<" + uri + "> + base<" + baseURI + "> = <" + resolvedURI + ">");
            }
            return resolvedURI.toURL();
        }
        catch (MalformedURLException ex) {
            throw new HdxException("Malformed URL constructed from URI!: " + ex);
        }
        catch (URISyntaxException ex) {
            throw new HdxException("URI syntax: " + ex);
        }
    }

    public URL fullyResolveURI(String uri, Node context) throws HdxException {
        try {
            return this.fullyResolveURI(new URI(uri), context);
        }
        catch (URISyntaxException ex) {
            throw new HdxException("URI syntax: " + ex);
        }
    }

    URI getBaseURI(Node n) throws HdxException {
        Element referenceElement;
        if (n == null) {
            return null;
        }
        URI base = null;
        switch (n.getNodeType()) {
            case 1: {
                referenceElement = (Element)n;
                break;
            }
            case 2: {
                if (n.getNodeName().equals("xml:base")) {
                    Element owner = ((Attr)n).getOwnerElement();
                    if (!$assertionsDisabled && owner == null) {
                        throw new AssertionError();
                    }
                    referenceElement = (Element)owner.getParentNode();
                    break;
                }
                referenceElement = ((Attr)n).getOwnerElement();
                if (!$assertionsDisabled && referenceElement == null) {
                    throw new AssertionError();
                }
                break;
            }
            case 3: 
            case 4: {
                Node parent = n.getParentNode();
                if (!$assertionsDisabled && parent == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && parent.getNodeType() != 1) {
                    throw new AssertionError();
                }
                referenceElement = (Element)parent;
                break;
            }
            case 7: {
                Node parent = n.getParentNode();
                if (parent == null) {
                    referenceElement = null;
                    break;
                }
                if (!$assertionsDisabled && parent.getNodeType() != 1) {
                    throw new AssertionError();
                }
                referenceElement = (Element)parent;
                break;
            }
            case 9: {
                referenceElement = null;
                break;
            }
            case 6: {
                return null;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                throw new HdxException("HdxFactory.getBaseURI: there is no base URI defined for nodes of type " + DOMUtils.mapNodeType(n.getNodeType()));
            }
            default: {
                throw new HdxException("Impossible node type " + n.getNodeType() + '=' + DOMUtils.mapNodeType(n.getNodeType()));
            }
        }
        try {
            while (referenceElement != null) {
                Node parent;
                String baseAtt = referenceElement.getAttribute("xml:base");
                if (baseAtt.length() != 0) {
                    if (base == null) {
                        base = new URI(baseAtt);
                    } else {
                        URI newbase = new URI(baseAtt);
                        base = newbase.resolve(base);
                    }
                    if (base.isAbsolute()) break;
                }
                if ((parent = referenceElement.getParentNode()).getNodeType() == 1) {
                    referenceElement = (Element)parent;
                    continue;
                }
                referenceElement = null;
            }
        }
        catch (URISyntaxException ex) {
            throw new HdxException("Syntactically invalid URI in xml:base: " + ex);
        }
        if (!(base != null && base.isAbsolute() || factoryBaseURI == null)) {
            base = base == null ? factoryBaseURI : factoryBaseURI.resolve(base);
        }
        if (base == null) {
            throw new HdxException("Can't determine base URI for document node");
        }
        String basepath = base.getPath();
        if (basepath == null || basepath.length() == 0) {
            try {
                base = new URI(base.getScheme(), base.getAuthority(), "/", base.getQuery(), base.getFragment());
            }
            catch (URISyntaxException ex) {
                throw new HdxException("Error inserting path to URI (shouldn't happen)" + ex);
            }
        }
        return base;
    }

    private Element validateHdxDOM(Element hdxElement) {
        if (HdxResourceType.HDX.isValid(hdxElement)) {
            return hdxElement;
        }
        DocumentFragment df = HdxElement.constructHdxElementTree(hdxElement);
        if (df == null || !df.hasChildNodes()) {
            return null;
        }
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer("validateHdxDOM: DocumentFragment contents:");
            for (Node kid = df.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                sb.append("   ");
                sb.append(HdxDocument.NodeUtil.serializeNode(kid));
            }
            logger.fine(sb.toString());
        }
        HdxElement ret = (HdxElement)df.getFirstChild();
        if (!$assertionsDisabled && !HdxResourceType.HDX.isValid(ret)) {
            throw new AssertionError();
        }
        return ret;
    }

    static {
        $assertionsDisabled = !HdxFactory.class.desiredAssertionStatus();
        defaultInstance = null;
        hdxFactoryList = new ArrayList(3);
        logger = Logger.getLogger("uk.ac.starlink.hdx");
        factoryMap = new WeakHashMap();
        String classname = "...eh?";
        try {
            HdxProperties.setProperty("HdxDocumentFactory.load.uk.ac.starlink.hdx.XmlHdxDocumentFactory", "true");
            String prefix = "HdxDocumentFactory.load.";
            Enumeration<?> e = HdxProperties.getProperties().propertyNames();
            while (e.hasMoreElements()) {
                String propname = (String)e.nextElement();
                if (!propname.startsWith(prefix)) continue;
                classname = propname.substring(prefix.length());
                Boolean loadflag = Boolean.valueOf(HdxProperties.getProperty(propname));
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.config("HdxDocumentFactory class " + classname + ":" + (loadflag != false ? "LOAD" : "NOLOAD"));
                }
                if (!loadflag.booleanValue()) continue;
                Class<?> newclass = Class.forName(classname, true, Thread.currentThread().getContextClassLoader());
            }
        }
        catch (HdxException ex) {
            throw new PluginException("Static initialiser threw HdxException: " + ex);
        }
        catch (NoSuchElementException ex) {
            throw new PluginException("Ooops, runaway Enumeration!:" + ex);
        }
        catch (ExceptionInInitializerError ex) {
            throw new PluginException("Failed to initialize class " + classname + " (" + ex + ")");
        }
        catch (LinkageError ex) {
            throw new PluginException("Failed to load class " + classname + " (" + ex + ")");
        }
        catch (ClassNotFoundException ex) {
            throw new PluginException("Failed to find class " + classname + " (" + ex + ")");
        }
    }
}

