/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hdx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import uk.ac.starlink.hdx.HdxElement;

class HdxNode
implements Node,
Cloneable {
    private HdxNode parent;
    private HdxNode firstChild;
    private HdxNode nextSibling;
    private HdxNode previousSibling;
    private short nodeType;
    private Document ownerDocument;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected HdxNode(short nodeType, Document ownerDocument) {
        if (nodeType != 9 && ownerDocument == null) {
            throw new IllegalArgumentException("HdxNode: No owner for non-Document node");
        }
        if (!$assertionsDisabled && nodeType != 9 && ownerDocument == null) {
            throw new AssertionError();
        }
        this.nodeType = nodeType;
        this.ownerDocument = ownerDocument;
        this.previousSibling = null;
        this.nextSibling = null;
        this.firstChild = null;
        this.parent = null;
    }

    public String toString() {
        return "HdxNode(" + this.getNodeName() + ':' + this.getNodeValue() + ")";
    }

    Object getNodeObject() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("HdxNode.getNodeObject -- null");
        }
        return null;
    }

    public String getNodeName() {
        Class<?> c = this.getClass();
        throw new UnsupportedOperationException("Method getNodeName() not supported on objects of type " + c.getName() + " (no." + this.nodeType + ")");
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        switch (this.getNodeType()) {
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            default: {
                this.unimplementedMethod("setNodeValue");
            }
        }
    }

    public short getNodeType() {
        return this.nodeType;
    }

    public boolean hasAttributes() {
        return false;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public NodeList getChildNodes() {
        return new NodeList(){
            private ArrayList list = new ArrayList();
            {
                HdxNode t = HdxNode.this.firstChild;
                while (t != null) {
                    this.list.add(t);
                    t = t.nextSibling;
                }
            }

            public int getLength() {
                return this.list.size();
            }

            public Node item(int index) {
                if (index < 0 || index >= this.getLength()) {
                    return null;
                }
                return (Node)this.list.get(index);
            }
        };
    }

    public Node getFirstChild() {
        return this.firstChild;
    }

    public Node getLastChild() {
        HdxNode t = this.firstChild;
        if (t == null) {
            return null;
        }
        while (t.nextSibling != null) {
            t = t.nextSibling;
        }
        return t;
    }

    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    private HdxNode findChild(HdxNode n) {
        HdxNode kid = this.firstChild;
        while (kid != null) {
            if (kid.equals(n)) {
                return kid;
            }
            kid = kid.nextSibling;
        }
        return null;
    }

    private boolean isAncestor(Node n) {
        if (n.equals(this)) {
            return true;
        }
        return this.parent == null ? false : this.parent.isAncestor(n);
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (newChild == null) {
            throw new IllegalArgumentException("newChild is null");
        }
        this.assertModifiableNode();
        if (newChild.getNodeType() == 11) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("HdxNode:" + this.toString() + ".insertBefore(DocumentFragment)...");
            }
            ArrayList<Node> l = new ArrayList<Node>();
            for (Node kid = newChild.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                l.add(kid);
            }
            Iterator li = l.iterator();
            while (li.hasNext()) {
                this.insertBefore((Node)li.next(), refChild);
            }
            return newChild;
        }
        this.assertInsertableNode(newChild);
        if (refChild != null) {
            this.assertInsertableNode(refChild);
        }
        HdxNode n = (HdxNode)newChild;
        if (this.ownerDocument != null) {
            n.ownerDocument = this.ownerDocument;
        }
        if (refChild == null) {
            HdxNode lastChild = (HdxNode)this.getLastChild();
            n.parent = this;
            n.nextSibling = null;
            n.previousSibling = lastChild;
            if (lastChild == null) {
                this.firstChild = n;
            } else {
                lastChild.nextSibling = n;
            }
        } else {
            HdxNode kid = this.findChild((HdxNode)refChild);
            if (kid == null) {
                throw new DOMException(8, "insertBefore: refChild node not found");
            }
            HdxNode prev = kid.previousSibling;
            n.parent = this;
            n.nextSibling = kid;
            n.previousSibling = prev;
            if (prev == null) {
                this.firstChild = n;
            } else {
                prev.nextSibling = n;
            }
            kid.previousSibling = n;
        }
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer("insertBefore(");
            sb.append(newChild.toString()).append(',').append(refChild == null ? "<null>" : refChild.toString()).append("): kids now");
            HdxNode kid = this.firstChild;
            while (kid != null) {
                sb.append(' ');
                sb.append(kid.toString());
                kid = kid.nextSibling;
            }
            logger.fine(sb.toString());
        }
        return newChild;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (newChild == null || oldChild == null) {
            throw new IllegalArgumentException("replaceChild: null newChild or oldChild");
        }
        this.insertBefore(newChild, oldChild);
        return this.removeChild(oldChild);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild == null) {
            throw new IllegalArgumentException("oldChild is null");
        }
        this.assertModifiableNode();
        HdxNode kid = this.findChild((HdxNode)oldChild);
        if (kid == null) {
            throw new DOMException(8, "oldChild is not a child of this node");
        }
        HdxNode prev = kid.previousSibling;
        if (prev == null) {
            this.firstChild = kid.nextSibling;
        } else {
            prev.nextSibling = kid.nextSibling;
        }
        if (kid.nextSibling != null) {
            kid.nextSibling.previousSibling = prev;
        }
        return oldChild;
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.insertBefore(newChild, null);
    }

    public boolean hasChildNodes() {
        return this.firstChild != null;
    }

    public Node cloneNode(boolean deep) {
        HdxNode n = (HdxNode)this.clone(deep);
        n.parent = null;
        n.nextSibling = null;
        n.previousSibling = null;
        return n;
    }

    public Object clone() {
        return this.clone(true);
    }

    protected Object clone(boolean deep) {
        try {
            HdxNode n = (HdxNode)super.clone();
            n.firstChild = null;
            if (deep) {
                for (HdxNode kid = (HdxNode)this.getFirstChild(); kid != null; kid = (HdxNode)kid.getNextSibling()) {
                    n.appendChild((Node)kid.clone());
                }
            }
            return n;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)"Can't happen: Object.clone() threw exception in HdxNode.clone");
        }
    }

    public boolean equals(Object t) {
        if (!$assertionsDisabled && this instanceof HdxElement) {
            throw new AssertionError();
        }
        if (t == null) {
            return false;
        }
        if (!(t instanceof HdxNode)) {
            return false;
        }
        Node tn = (Node)t;
        if (this.getNodeType() != tn.getNodeType()) {
            return false;
        }
        if (!this.getNodeName().equals(tn.getNodeName())) {
            return false;
        }
        String myvalue = this.getNodeValue();
        String tnvalue = tn.getNodeValue();
        if (myvalue != null && tnvalue != null ? !myvalue.equals(tnvalue) : myvalue != null || tnvalue != null) {
            return false;
        }
        if (!$assertionsDisabled && tn.hasAttributes()) {
            throw new AssertionError();
        }
        return true;
    }

    public int hashCode() {
        if (!$assertionsDisabled && this.getNodeType() == 1) {
            throw new AssertionError();
        }
        HashCode hc = new HashCode(this.getNodeName().hashCode());
        for (Node kid = this.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            hc.add(kid.hashCode());
        }
        return hc.value();
    }

    public void normalize() {
        this.normalizeTextChildren();
    }

    private void normalizeTextChildren() {
        Node kid = this.getFirstChild();
        while (kid != null) {
            Node nextnode = kid.getNextSibling();
            if (kid instanceof Text) {
                Text t = (Text)kid;
                if (t.getLength() == 0) {
                    this.removeChild(kid);
                } else if (nextnode != null && nextnode instanceof Text) {
                    t.appendData(nextnode.getNodeValue());
                    Node nextnextnode = nextnode.getNextSibling();
                    this.removeChild(nextnode);
                    nextnode = nextnextnode;
                }
            } else if (kid.getNodeType() == 1) {
                ((HdxNode)kid).normalizeTextChildren();
            }
            kid = nextnode;
        }
    }

    public boolean isSupported(String feature, String version) {
        return false;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String prefix) throws DOMException {
        this.cannotModifyException("setPrefix");
        this.assertModifiableNode();
    }

    public String getLocalName() {
        return null;
    }

    private void cannotModifyException(String methodName) throws DOMException {
        throw new DOMException(7, "HdxNode can't be modified using method " + methodName);
    }

    private void notSupportedException(String methodName) throws DOMException {
        throw new DOMException(9, "HdxNode doesn't support method " + methodName);
    }

    protected void unimplementedMethod(String methodName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Method " + methodName + " not supported on this class (" + this.getClass().getName() + ")");
    }

    private void assertModifiableNode() throws DOMException {
    }

    private void assertInsertableNode(Node n) throws DOMException {
        if (n == null) {
            throw new IllegalArgumentException("Node to insert is null");
        }
        if (!(n instanceof HdxNode)) {
            throw new DOMException(4, "Node is not a HdxNode");
        }
        if (this == n) {
            throw new DOMException(3, "Cannot insert Node into itself");
        }
        if (this.isAncestor(n)) {
            throw new DOMException(3, "Node is an ancestor of current node");
        }
    }

    static {
        $assertionsDisabled = !HdxNode.class.desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.hdx");
    }

    static final class HashCode {
        private Checksum crc = new Adler32();

        public HashCode() {
        }

        public HashCode(int i) {
            this();
            this.add(i);
        }

        public HashCode add(int I) {
            for (int i = 0; i < 4; ++i) {
                this.crc.update(I & 0xFF);
                I >>= 8;
            }
            return this;
        }

        public void reset() {
            this.crc.reset();
        }

        public int value() {
            return new Long(this.crc.getValue()).hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof HashCode)) {
                return false;
            }
            return this.crc.equals(((HashCode)o).crc);
        }

        public int hashCode() {
            return this.crc.hashCode();
        }
    }
}

