/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hdx;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.hdx.ElementValidator;
import uk.ac.starlink.hdx.HdxDocument;
import uk.ac.starlink.hdx.HdxException;
import uk.ac.starlink.hdx.HdxProperties;
import uk.ac.starlink.hdx.HdxResourceFactory;
import uk.ac.starlink.hdx.PluginException;

public class HdxResourceType {
    private static Logger logger = Logger.getLogger("uk.ac.starlink.hdx");
    public static final String HDX_NAMESPACE = "http://www.starlink.ac.uk/HDX";
    static final String HDX_ARCHATT = "hdxname";
    public static HdxResourceType HDX;
    public static HdxResourceType TITLE;
    public static HdxResourceType NONE;
    private static Map resourceTypeMap;
    private Class requiredClass;
    private final String name;
    private String hoistAttribute;
    private List handlers;
    private ElementValidator validator;

    private HdxResourceType(String name) {
        this.name = name;
    }

    public static HdxResourceType newHdxResourceType(String name) {
        if (resourceTypeMap.containsKey(name)) {
            return null;
        }
        HdxResourceType t = new HdxResourceType(name);
        resourceTypeMap.put(name, t);
        logger.config("Registered new HDX resource type " + t);
        return t;
    }

    public String toString() {
        return this.name;
    }

    public String xmlName() {
        return this.name;
    }

    public String getHoistAttribute() {
        return this.hoistAttribute;
    }

    public void setHoistAttribute(String s) {
        this.hoistAttribute = s;
    }

    public void setConstructedClass(Class c) {
        this.requiredClass = c;
    }

    public void setConstructedClass(String classname) throws HdxException {
        try {
            this.getClass();
            Class<?> c = Class.forName(classname);
            this.setConstructedClass(c);
        }
        catch (ClassNotFoundException ex) {
            throw new HdxException("Class " + classname + " not registrable: " + ex);
        }
    }

    public Class getConstructedClass() {
        if (this.requiredClass == null) {
            return Object.class;
        }
        return this.requiredClass;
    }

    public static boolean isValidHdx(Document doc) {
        return HDX.isValid(doc.getDocumentElement());
    }

    public boolean isValid(Element el) {
        return this.validator == null ? true : this.validator.validateElement(el);
    }

    public void setElementValidator(ElementValidator validator) {
        this.validator = validator;
    }

    public void registerHdxResourceFactory(HdxResourceFactory factory) {
        if (this.handlers == null) {
            this.handlers = new LinkedList();
        }
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("HdxResourceType.registerHdxResourceFactory for " + this.toString() + " type=" + factory.getClass().getName());
        }
        this.handlers.add(0, factory);
    }

    Object getObject(Element el) throws HdxException {
        if (this.handlers != null) {
            ListIterator li = this.handlers.listIterator();
            while (li.hasNext()) {
                logger.fine("  next handler...");
                Object ret = ((HdxResourceFactory)li.next()).getObject(el);
                if (ret == null) continue;
                if (this.requiredClass == null) {
                    return ret;
                }
                if (this.requiredClass.isInstance(ret)) {
                    return ret;
                }
                throw new PluginException("Constructor for element " + el.getTagName() + " returned an object of class " + ret.getClass() + " and not class " + this.requiredClass + " as required");
            }
        }
        return null;
    }

    public static HdxResourceType match(Element el) {
        return HdxResourceType.match(el == null ? null : el.getTagName());
    }

    public static HdxResourceType match(String gi) {
        HdxResourceType result;
        if (gi == null) {
            result = NONE;
        } else {
            result = (HdxResourceType)resourceTypeMap.get(gi);
            if (result == null) {
                result = NONE;
            }
        }
        return result;
    }

    public static Iterator getAllTypes() {
        return resourceTypeMap.values().iterator();
    }

    static {
        resourceTypeMap = new HashMap();
        try {
            NONE = HdxResourceType.newHdxResourceType("none");
            resourceTypeMap.remove("none");
            HDX = HdxResourceType.newHdxResourceType("hdx");
            HDX.setElementValidator(new ElementValidator(){

                public boolean validateElement(Element el) {
                    boolean log = logger.isLoggable(Level.FINE);
                    if (el == null) {
                        throw new IllegalArgumentException("HDX.validateElement received null argument");
                    }
                    if (log) {
                        logger.fine("validateElement(" + HdxDocument.NodeUtil.serializeNode(el) + "):");
                    }
                    if (HdxResourceType.match(el) != HDX) {
                        return false;
                    }
                    for (Node n = el.getFirstChild(); n != null; n = n.getNextSibling()) {
                        if (n.getNodeType() != 1) {
                            logger.fine("...child type=" + n.getNodeType() + " value=<" + n.getNodeValue() + ">");
                            return false;
                        }
                        HdxResourceType type = HdxResourceType.match((Element)n);
                        if (type == NONE) {
                            if (log) {
                                logger.fine("...unrecognised child type <" + n.getNodeName() + ">");
                            }
                            return false;
                        }
                        if (type.isValid((Element)n)) continue;
                        if (log) {
                            logger.fine("...child not valid");
                        }
                        return false;
                    }
                    if (log) {
                        logger.fine("...OK");
                    }
                    return true;
                }
            });
            HDX.setConstructedClass("uk.ac.starlink.hdx.HdxContainer");
            TITLE = HdxResourceType.newHdxResourceType("title");
            TITLE.setHoistAttribute("value");
            TITLE.setElementValidator(new ElementValidator(){

                public boolean validateElement(Element el) {
                    return HdxResourceType.match(el) == TITLE && el.hasAttribute(TITLE.getHoistAttribute());
                }
            });
        }
        catch (HdxException ex) {
            throw new PluginException("Failed to initialise HDX properly.  What now?!");
        }
        String classname = "...eh?";
        try {
            String prefix = "HdxResourceType.load.";
            Enumeration<?> e = HdxProperties.getProperties().propertyNames();
            while (e.hasMoreElements()) {
                String propname = (String)e.nextElement();
                if (!propname.startsWith(prefix)) continue;
                classname = propname.substring(prefix.length());
                Boolean loadflag = Boolean.valueOf(HdxProperties.getProperty(propname));
                logger.config("HdxResourceType class " + classname + ":" + (loadflag != false ? "LOAD" : "NOLOAD"));
                if (!loadflag.booleanValue()) continue;
                Class.forName(classname, true, Thread.currentThread().getContextClassLoader());
            }
        }
        catch (NoSuchElementException ex) {
            throw new PluginException("Ooops, runaway Enumeration!:" + ex);
        }
        catch (ExceptionInInitializerError ex) {
            throw new PluginException("Failed to initialize class " + classname + " (" + ex + ")");
        }
        catch (LinkageError ex) {
            throw new PluginException("Failed to load class " + classname + " (" + ex + ")");
        }
        catch (ClassNotFoundException ex) {
            throw new PluginException("Failed to find class " + classname + " (" + ex + ")");
        }
    }
}

