/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndx;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDArrayFactory;
import uk.ac.starlink.hdx.HdxException;
import uk.ac.starlink.hdx.HdxFactory;
import uk.ac.starlink.hdx.HdxResourceType;
import uk.ac.starlink.ndx.BridgeNdx;
import uk.ac.starlink.ndx.NdxImpl;

class DomNdxImpl
implements NdxImpl {
    private static Logger logger;
    private Map contents = new HashMap();
    private Element ndxElement;
    static final /* synthetic */ boolean $assertionsDisabled;

    DomNdxImpl(Element elem) throws HdxException {
        if (HdxResourceType.match((Element)elem) != BridgeNdx.getHdxResourceType()) {
            throw new HdxException("Element " + elem.getTagName() + " wrong type for DomNdxImpl constructor");
        }
        this.ndxElement = elem;
    }

    public NDArray getImage() {
        return this.getChildArray("image");
    }

    public NDArray getVariance() {
        return this.getChildArray("variance");
    }

    public NDArray getQuality() {
        return this.getChildArray("quality");
    }

    public String getTitle() {
        return this.getChildText(HdxResourceType.TITLE.xmlName(), HdxResourceType.TITLE.getHoistAttribute());
    }

    public String getLabel() {
        return this.getChildText("label", "value");
    }

    public String getUnits() {
        return this.getChildText("units", "value");
    }

    public int getBadBits() {
        String bytestr = this.getChildText("badbits", "value");
        return bytestr == null ? 0 : (int)Byte.decode(bytestr).byteValue();
    }

    public Object getWCS() {
        return this.getChildElement("wcs");
    }

    public Source getEtc() {
        Element etcElement = this.getChildElement("etc");
        if (!$assertionsDisabled && etcElement == null) {
            throw new AssertionError();
        }
        return new DOMSource(etcElement);
    }

    public boolean hasImage() {
        return this.hasChildArray("data");
    }

    public boolean hasVariance() {
        return this.hasChildArray("variance");
    }

    public boolean hasQuality() {
        return this.hasChildArray("quality");
    }

    public boolean hasTitle() {
        return this.getTitle() != null;
    }

    public boolean hasLabel() {
        return this.getLabel() != null;
    }

    public boolean hasUnits() {
        return this.getUnits() != null;
    }

    public boolean hasWCS() {
        return this.getChildElement("wcs") != null;
    }

    public boolean hasEtc() {
        return this.getChildElement("etc") != null;
    }

    public String toString() {
        return "DomNdxImpl<" + this.ndxElement.getTagName() + ">";
    }

    private void putChild(String r, Object n) {
        this.contents.put(r, n);
    }

    private Element getChildElement(String xmlname) {
        if (this.ndxElement == null) {
            return null;
        }
        for (Node kid = this.ndxElement.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1 || !((Element)kid).getTagName().equals(xmlname)) continue;
            return (Element)kid;
        }
        return null;
    }

    private NDArray getChildArray(String xmlname) {
        if (!this.contents.containsKey(xmlname)) {
            Element kid = this.getChildElement(xmlname);
            if (kid == null) {
                this.putChild(xmlname, null);
            } else {
                try {
                    URL url = this.getURLFromElement(kid);
                    if (url == null) {
                        logger.warning("No URL in element: " + kid);
                        this.putChild(xmlname, null);
                    } else {
                        this.putChild(xmlname, new NDArrayFactory().makeNDArray(url, AccessMode.READ));
                    }
                }
                catch (IOException ex) {
                    logger.warning("Error creating NDArray (" + ex + ")");
                    this.putChild(xmlname, null);
                }
                catch (HdxException ex) {
                    logger.warning("Error creating NDArray (" + (Object)((Object)ex) + ")");
                    this.putChild(xmlname, null);
                }
            }
        }
        return (NDArray)this.contents.get(xmlname);
    }

    private boolean hasChildArray(String xmlname) {
        return this.getChildArray(xmlname) != null;
    }

    private String getChildText(String xmlname, String substAttribute) {
        if (!this.contents.containsKey(xmlname)) {
            Element kid = this.getChildElement(xmlname);
            if (kid == null) {
                this.putChild(xmlname, null);
            } else if (substAttribute != null && kid.hasAttribute(substAttribute)) {
                this.putChild(xmlname, kid.getAttribute(substAttribute));
            } else {
                this.putChild(xmlname, kid.getNodeValue());
            }
        }
        return (String)this.contents.get(xmlname);
    }

    private URL getURLFromElement(Element e) throws HdxException {
        String urlString = e.getAttribute("url");
        if (!$assertionsDisabled && urlString == null) {
            throw new AssertionError();
        }
        if (urlString.length() == 0) {
            urlString = e.getAttribute("uri");
        }
        if (!$assertionsDisabled && urlString == null) {
            throw new AssertionError();
        }
        URL url = urlString.length() == 0 ? null : HdxFactory.findFactory((Node)e).fullyResolveURI(urlString, (Node)e);
        logger.fine("DomNdxImpl.getURLFromElement(" + e + ")=" + url);
        return url;
    }

    static {
        $assertionsDisabled = !DomNdxImpl.class.desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.ndx");
    }
}

