/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndx;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.NdxHandler;
import uk.ac.starlink.ndx.XMLNdxHandler;
import uk.ac.starlink.util.Loader;
import uk.ac.starlink.util.URLUtils;

public class NdxIO {
    private static List defaultHandlers;
    private List handlers;
    private static Logger logger;

    public NdxIO() {
        if (defaultHandlers == null) {
            NdxHandler handler;
            Method meth;
            Class<?> clazz;
            defaultHandlers = new ArrayList(3);
            Class[] noParams = new Class[]{};
            Object[] noArgs = new Object[]{};
            String className = "uk.ac.starlink.hds.NDFNdxHandler";
            try {
                this.getClass();
                clazz = Class.forName(className);
                meth = clazz.getMethod("getInstance", noParams);
                handler = (NdxHandler)meth.invoke(null, noArgs);
                defaultHandlers.add(handler);
                logger.config(className + " registered");
            }
            catch (ClassNotFoundException e) {
                logger.config(className + " not found - can't register");
            }
            catch (LinkageError e) {
                try {
                    this.getClass();
                    Class.forName("uk.ac.starlink.hds.HDSPackage").getMethod("isAvailable", noParams).invoke(null, noArgs);
                }
                catch (Exception e2) {
                    logger.config(className + " " + e2 + " - can't register");
                }
            }
            catch (InvocationTargetException e) {
                logger.config(className + " " + e.getTargetException() + " - can't register");
            }
            catch (Exception e) {
                logger.config(className + " " + e + " - can't register");
            }
            className = "uk.ac.starlink.fits.FitsNdxHandler";
            try {
                this.getClass();
                clazz = Class.forName(className);
                meth = clazz.getMethod("getInstance", noParams);
                handler = (NdxHandler)meth.invoke(null, noArgs);
                defaultHandlers.add(handler);
                logger.config(className + " registered");
            }
            catch (ClassNotFoundException e) {
                logger.config(className + " not found - can't register");
            }
            catch (Exception e) {
                logger.config(className + e + " - can't register");
            }
            defaultHandlers.add(XMLNdxHandler.getInstance());
        }
        this.handlers = new ArrayList(defaultHandlers);
    }

    public List getHandlers() {
        return this.handlers;
    }

    public void setHandlers(NdxHandler[] handlers) {
        this.handlers = new ArrayList<NdxHandler>(Arrays.asList(handlers));
    }

    public Ndx makeNdx(URL url, AccessMode mode) throws IOException {
        Iterator it = this.handlers.iterator();
        while (it.hasNext()) {
            NdxHandler handler = (NdxHandler)it.next();
            Ndx ndx = handler.makeNdx(url, mode);
            if (ndx == null) continue;
            return ndx;
        }
        return null;
    }

    public boolean makeBlankNdx(URL url, Ndx template) throws IOException {
        Iterator it = this.handlers.iterator();
        while (it.hasNext()) {
            NdxHandler handler = (NdxHandler)it.next();
            if (!handler.makeBlankNdx(url, template)) continue;
            return true;
        }
        return false;
    }

    public void outputNdx(URL url, Ndx ndx) throws IOException {
        Iterator it = this.handlers.iterator();
        while (it.hasNext()) {
            NdxHandler handler = (NdxHandler)it.next();
            if (!handler.outputNdx(url, ndx)) continue;
            return;
        }
        throw new UnsupportedOperationException("No Ndx handler found for URL " + url);
    }

    public Ndx makeNdx(String location, AccessMode mode) throws IOException {
        return this.makeNdx(NdxIO.getUrl(location), mode);
    }

    public boolean makeBlankNdx(String location, Ndx template) throws IOException {
        return this.makeBlankNdx(NdxIO.getUrl(location), template);
    }

    public void outputNdx(String location, Ndx ndx) throws IOException {
        this.outputNdx(NdxIO.getUrl(location), ndx);
    }

    private static URL getUrl(String location) {
        return URLUtils.makeURL((String)location);
    }

    static {
        logger = Logger.getLogger("uk.ac.starlink.ndx");
        Loader.loadProperties();
    }
}

