/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndx;

import java.io.IOException;
import uk.ac.starlink.array.AccessImpl;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.ArrayAccess;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.BridgeNDArray;
import uk.ac.starlink.array.ChunkStepper;
import uk.ac.starlink.array.ConvertArrayImpl;
import uk.ac.starlink.array.Function;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDArrays;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Requirements;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.array.TypeConverter;
import uk.ac.starlink.array.WrapperArrayImpl;
import uk.ac.starlink.ast.Frame;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.ast.Mapping;
import uk.ac.starlink.ast.WinMap;
import uk.ac.starlink.ndx.Ndx;

public class Ndxs {
    private static final int BUFSIZ = ChunkStepper.defaultChunkSize;

    private Ndxs() {
    }

    public static NDArray getMaskedImage(Ndx ndx, Requirements req) throws IOException {
        if (ndx.hasQuality() && ndx.getBadBits() != 0) {
            return Ndxs.maskArray(ndx.getImage(), ndx.getQuality(), ndx.getBadBits(), req);
        }
        return NDArrays.toRequiredArray(ndx.getImage(), req);
    }

    public static NDArray getMaskedImage(Ndx ndx) throws IOException {
        return Ndxs.getMaskedImage(ndx, null);
    }

    public static NDArray getMaskedVariance(Ndx ndx, Requirements req) throws IOException {
        if (ndx.hasQuality() && ndx.getBadBits() != 0) {
            return Ndxs.maskArray(ndx.getVariance(), ndx.getQuality(), ndx.getBadBits(), req);
        }
        return NDArrays.toRequiredArray(ndx.getVariance(), req);
    }

    public static NDArray getMaskedVariance(Ndx ndx) throws IOException {
        return Ndxs.getMaskedVariance(ndx, null);
    }

    public static NDArray getMaskedErrors(Ndx ndx, Requirements req) throws IOException {
        Type type;
        req = req != null ? req : new Requirements();
        Requirements vreq = (Requirements)req.clone();
        vreq.setBadHandler(null);
        vreq.setType(null);
        NDArray var = Ndxs.getMaskedVariance(ndx, vreq);
        Type type2 = type = req.getType() != null ? req.getType() : var.getType();
        BadHandler handler = req.getBadHandler() != null ? req.getBadHandler() : (type == var.getType() ? var.getBadHandler() : BadHandler.getHandler(type, type.defaultBadValue()));
        Function rooter = new Function(){

            public double forward(double x) {
                return Math.sqrt(x);
            }

            public double inverse(double y) {
                return y * y;
            }
        };
        TypeConverter tconv = new TypeConverter(var.getType(), var.getBadHandler(), type, handler, rooter);
        return new BridgeNDArray(new ConvertArrayImpl(var, tconv));
    }

    public static NDArray getMaskedErrors(Ndx ndx) throws IOException {
        return Ndxs.getMaskedErrors(ndx, null);
    }

    public static NDArray maskArray(NDArray target, NDArray quality, int badbits, Requirements req) throws IOException {
        Requirements treq;
        Requirements requirements = treq = req != null ? (Requirements)req.clone() : new Requirements();
        if (treq.getWindow() == null) {
            treq.setWindow(target.getShape());
        }
        if (treq.getOrder() == null) {
            treq.setOrder(target.getShape().getOrder());
        }
        OrderedNDShape oshape = new OrderedNDShape(treq.getWindow(), treq.getOrder());
        final Type qtype = quality.getType();
        if (qtype.isFloating()) {
            throw new IllegalArgumentException("Quality array " + quality + " may not have floating point type");
        }
        Requirements qreq = new Requirements(AccessMode.READ).setWindow(oshape).setOrder(oshape.getOrder());
        final NDArray tbase = NDArrays.toRequiredArray(target, treq);
        final NDArray qbase = NDArrays.toRequiredArray(quality, qreq);
        final Masker masker = Ndxs.getMasker(qtype, badbits, tbase.getBadHandler());
        WrapperArrayImpl maskedImpl = new WrapperArrayImpl(tbase){

            public boolean canMap() {
                return false;
            }

            public boolean isRandom() {
                return tbase.isRandom() && qbase.isRandom();
            }

            public boolean isWritable() {
                return tbase.isWritable() && qbase.isWritable();
            }

            public boolean multipleAccess() {
                return tbase.multipleAccess() && qbase.multipleAccess();
            }

            public void close() throws IOException {
                super.close();
                qbase.close();
            }

            public AccessImpl getAccess() throws IOException {
                ArrayAccess tacc = tbase.getAccess();
                ArrayAccess qacc = qbase.getAccess();
                Object qbuf = qtype.newArray(BUFSIZ);
                return new AccessImpl(this, tacc, qacc, qbuf){
                    private final /* synthetic */ ArrayAccess val$tacc;
                    private final /* synthetic */ ArrayAccess val$qacc;
                    private final /* synthetic */ Object val$qbuf;
                    private final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$tacc = val$tacc;
                        this.val$qacc = val$qacc;
                        this.val$qbuf = val$qbuf;
                    }

                    public void setOffset(long off) throws IOException {
                        this.val$tacc.setOffset(off);
                        this.val$qacc.setOffset(off);
                    }

                    public void read(Object tbuf, int start, int size) throws IOException {
                        if (size <= Ndxs.access$000()) {
                            this.val$tacc.read(tbuf, 0, size);
                            this.val$qacc.read(this.val$qbuf, 0, size);
                            2.access$100(this.this$0).mask(this.val$qbuf, tbuf, start, size);
                        } else {
                            ChunkStepper cIt = new ChunkStepper(size, Ndxs.access$000());
                            while (cIt.hasNext()) {
                                int leng = cIt.getSize();
                                int base = (int)cIt.getBase();
                                this.val$qacc.read(this.val$qbuf, 0, leng);
                                2.access$100(this.this$0).mask(this.val$qbuf, tbuf, base, leng);
                                cIt.next();
                            }
                        }
                    }

                    public void write(Object tbuf, int start, int size) throws IOException {
                        this.val$tacc.write(tbuf, start, size);
                    }

                    public void close() throws IOException {
                        this.val$tacc.close();
                        this.val$qacc.close();
                    }
                };
            }

            static /* synthetic */ Masker access$100(2 x0) {
                return x0.masker;
            }
        };
        return new BridgeNDArray(maskedImpl);
    }

    private static Masker getMasker(Type qtype, final int badbits, final BadHandler thandler) {
        if (qtype == Type.BYTE) {
            return new Masker(){
                byte bitmask;
                {
                    this.bitmask = (byte)badbits;
                }

                public void mask(Object qb, Object tbuf, int start, int size) {
                    byte[] qbuf = (byte[])qb;
                    int tpos = start;
                    int qpos = 0;
                    while (size-- > 0) {
                        if ((qbuf[qpos] & this.bitmask) != 0) {
                            thandler.putBad(tbuf, tpos);
                        }
                        ++tpos;
                        ++qpos;
                    }
                }
            };
        }
        if (qtype == Type.SHORT) {
            return new Masker(){
                short bitmask;
                {
                    this.bitmask = (short)badbits;
                }

                public void mask(Object qb, Object tbuf, int start, int size) {
                    short[] qbuf = (short[])qb;
                    int tpos = start;
                    int qpos = 0;
                    while (size-- > 0) {
                        if ((qbuf[qpos] & this.bitmask) != 0) {
                            thandler.putBad(tbuf, tpos);
                        }
                        ++tpos;
                        ++qpos;
                    }
                }
            };
        }
        if (qtype == Type.INT) {
            return new Masker(){
                int bitmask;
                {
                    this.bitmask = badbits;
                }

                public void mask(Object qb, Object tbuf, int start, int size) {
                    int[] qbuf = (int[])qb;
                    int tpos = start;
                    int qpos = 0;
                    while (size-- > 0) {
                        if ((qbuf[qpos] & this.bitmask) != 0) {
                            thandler.putBad(tbuf, tpos);
                        }
                        ++tpos;
                        ++qpos;
                    }
                }
            };
        }
        throw new AssertionError((Object)("Wrong type " + qtype));
    }

    public static FrameSet getAst(Ndx ndx) {
        if (ndx.hasWCS()) {
            return ndx.getAst();
        }
        return Ndxs.getDefaultAst(ndx);
    }

    public static FrameSet getDefaultAst(Ndx ndx) {
        NDArray image = ndx.getImage();
        OrderedNDShape imshape = image.getShape();
        int ndim = imshape.getNumDims();
        Frame gridfrm = new Frame(ndim);
        gridfrm.setDomain("GRID");
        Frame imfrm = new Frame(ndim);
        imfrm.setDomain("PIXEL");
        FrameSet ast = new FrameSet(gridfrm);
        Mapping gpmap = Ndxs.translateMap(imshape);
        ast.addFrame(FrameSet.AST__BASE, gpmap, imfrm);
        return ast;
    }

    private static Mapping translateMap(NDShape shape) {
        int ndim = shape.getNumDims();
        long[] origin = shape.getOrigin();
        double[] ina = new double[ndim];
        double[] inb = new double[ndim];
        double[] outa = new double[ndim];
        double[] outb = new double[ndim];
        for (int i = 0; i < ndim; ++i) {
            ina[i] = 0.5;
            inb[i] = 1.5;
            outa[i] = (double)origin[i] - 1.0;
            outb[i] = origin[i];
        }
        return new WinMap(ndim, ina, inb, outa, outb);
    }

    private static interface Masker {
        public void mask(Object var1, Object var2, int var3, int var4);
    }
}

