package uk.ac.starlink.util.gui;

import java.util.EventObject;

/**
 * SelectCharactersEvent defines an event that passes on new text that
 * has been created.
 *
 * @since $Date: 2003-12-08 17:18:49 +0000 (Mon, 08 Dec 2003) $
 * @since 03-NOV-2000
 * @author Peter W. Draper
 * @version $Id: SelectCharactersEvent.java 1546 2003-12-08 17:18:49Z pwd $
 * @copyright Copyright (C) 2000 Central Laboratory of the Research Councils
 */
public class SelectCharactersEvent 
    extends EventObject
{
    /**
     * Constructs a SelectCharactersEvent object.
     *
     * @param source the source Object (typically this).
     * @param text the new text.
     */
    public SelectCharactersEvent( Object source, String text )
    {
        super( source );
        this.text = text;
    }

    /**
     * The text.
     */
    protected String text = null;

    /**
     *  Return the event text.
     */
    public String getText()
    {
        return text;
    }
}
