/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ecsv;

import java.lang.reflect.Array;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.Tables;

public abstract class EcsvEncoder {
    private final String datatype_;
    private final String subtype_;
    private static final String ECSV_TRUE = "True";
    private static final String ECSV_FALSE = "False";
    private static final String JSON_BLANK = "null";
    private static final String JSON_TRUE = "true";
    private static final String JSON_FALSE = "false";

    protected EcsvEncoder(String datatype, String subtype) {
        this.datatype_ = datatype;
        this.subtype_ = subtype;
    }

    private EcsvEncoder(String datatype) {
        this(datatype, (String)null);
    }

    public abstract String encode(Object var1);

    public String getDatatype() {
        return this.datatype_;
    }

    public String getSubtype() {
        return this.subtype_;
    }

    public static EcsvEncoder createEncoder(ColumnInfo info, final char delimiter) {
        Class<?> clazz = info.getContentClass();
        if (Boolean.class.equals(clazz)) {
            return new EcsvEncoder("bool"){

                @Override
                public String encode(Object value) {
                    if (Boolean.TRUE.equals(value)) {
                        return EcsvEncoder.ECSV_TRUE;
                    }
                    if (Boolean.FALSE.equals(value)) {
                        return EcsvEncoder.ECSV_FALSE;
                    }
                    return null;
                }
            };
        }
        if (Byte.class.equals(clazz)) {
            return new EcsvEncoder("int8"){

                @Override
                public String encode(Object value) {
                    return value instanceof Byte ? ((Byte)value).toString() : null;
                }
            };
        }
        if (Short.class.equals(clazz)) {
            boolean isUnsignedByte = Boolean.TRUE.equals(info.getAuxDatumValue(Tables.UBYTE_FLAG_INFO, Boolean.class));
            return new EcsvEncoder(isUnsignedByte ? "uint8" : "int16"){

                @Override
                public String encode(Object value) {
                    return value instanceof Short ? ((Short)value).toString() : null;
                }
            };
        }
        if (Integer.class.equals(clazz)) {
            return new EcsvEncoder("int32"){

                @Override
                public String encode(Object value) {
                    return value instanceof Integer ? ((Integer)value).toString() : null;
                }
            };
        }
        if (Long.class.equals(clazz)) {
            return new EcsvEncoder("int64"){

                @Override
                public String encode(Object value) {
                    return value instanceof Long ? ((Long)value).toString() : null;
                }
            };
        }
        if (Float.class.equals(clazz)) {
            return new EcsvEncoder("float32"){

                @Override
                public String encode(Object value) {
                    if (value instanceof Float) {
                        Float fval = (Float)value;
                        float f = fval.floatValue();
                        if (Float.isFinite(f)) {
                            return fval.toString();
                        }
                        if (Float.isNaN(f)) {
                            return null;
                        }
                        if (Float.isInfinite(f)) {
                            return f > 0.0f ? "inf" : "-inf";
                        }
                        assert (false);
                        return null;
                    }
                    if (value == null) {
                        return null;
                    }
                    return null;
                }
            };
        }
        if (Double.class.equals(clazz)) {
            return new EcsvEncoder("float64"){

                @Override
                public String encode(Object value) {
                    if (value instanceof Double) {
                        Double dval = (Double)value;
                        double d = dval;
                        if (Double.isFinite(d)) {
                            return dval.toString();
                        }
                        if (Double.isNaN(d)) {
                            return null;
                        }
                        if (Double.isInfinite(d)) {
                            return d > 0.0 ? "inf" : "-inf";
                        }
                        assert (false);
                        return null;
                    }
                    if (value == null) {
                        return null;
                    }
                    return null;
                }
            };
        }
        if (String.class.equals(clazz)) {
            return new EcsvEncoder("string"){

                @Override
                public String encode(Object value) {
                    return value instanceof String ? 8.quoteString((String)value, delimiter) : null;
                }
            };
        }
        if (Character.class.equals(clazz)) {
            return new EcsvEncoder("string"){

                @Override
                public String encode(Object value) {
                    return value instanceof Character ? 9.quoteString(((Character)value).toString(), delimiter) : null;
                }
            };
        }
        if (boolean[].class.equals(clazz)) {
            return EcsvEncoder.createArrayEncoder("bool", info.getShape(), boolean[].class, delimiter, (arr, i) -> arr[i] ? JSON_TRUE : JSON_FALSE);
        }
        if (byte[].class.equals(clazz)) {
            return EcsvEncoder.createArrayEncoder("int8", info.getShape(), byte[].class, delimiter, (arr, i) -> Byte.toString(arr[i]));
        }
        if (short[].class.equals(clazz)) {
            boolean isUnsignedByte = Boolean.TRUE.equals(info.getAuxDatumValue(Tables.UBYTE_FLAG_INFO, Boolean.class));
            return EcsvEncoder.createArrayEncoder(isUnsignedByte ? "uint8" : "int16", info.getShape(), short[].class, delimiter, (arr, i) -> Short.toString(arr[i]));
        }
        if (int[].class.equals(clazz)) {
            return EcsvEncoder.createArrayEncoder("int32", info.getShape(), int[].class, delimiter, (arr, i) -> Integer.toString(arr[i]));
        }
        if (long[].class.equals(clazz)) {
            return EcsvEncoder.createArrayEncoder("int64", info.getShape(), long[].class, delimiter, (arr, i) -> Long.toString(arr[i]));
        }
        if (float[].class.equals(clazz)) {
            return EcsvEncoder.createArrayEncoder("float32", info.getShape(), float[].class, delimiter, (arr, i) -> {
                float f = arr[i];
                return Float.isNaN(f) || Float.isInfinite(f) ? JSON_BLANK : Float.toString(f);
            });
        }
        if (double[].class.equals(clazz)) {
            return EcsvEncoder.createArrayEncoder("float64", info.getShape(), double[].class, delimiter, (arr, i) -> {
                double d = arr[i];
                return Double.isNaN(d) || Double.isInfinite(d) ? JSON_BLANK : Double.toString(d);
            });
        }
        if (String[].class.equals(clazz)) {
            return EcsvEncoder.createArrayEncoder("string", info.getShape(), String[].class, delimiter, (arr, i) -> EcsvEncoder.toJsonString(arr[i]));
        }
        return null;
    }

    public static String quoteString(String txt, char delimiter) {
        int nc = txt.length();
        if (nc == 0) {
            return delimiter == ' ' ? "\"\"" : "";
        }
        boolean needsQuote = false;
        int ndq = 0;
        block5: for (int ic = 0; ic < nc; ++ic) {
            char c = txt.charAt(ic);
            switch (c) {
                case ' ': 
                case ',': {
                    needsQuote |= c == delimiter;
                    continue block5;
                }
                case '\"': {
                    ++ndq;
                    needsQuote = true;
                    continue block5;
                }
                case '\n': {
                    needsQuote = true;
                    continue block5;
                }
            }
        }
        if (needsQuote) {
            int nqc = 2 + nc + ndq;
            StringBuilder sbuf = new StringBuilder(nqc);
            sbuf.append('\"');
            for (int ic = 0; ic < nc; ++ic) {
                char c = txt.charAt(ic);
                sbuf.append(c);
                if (c != '\"') continue;
                sbuf.append(c);
            }
            sbuf.append('\"');
            assert (sbuf.length() == nqc);
            return sbuf.toString();
        }
        return txt;
    }

    private static String toJsonString(String txt) {
        if (txt == null) {
            return JSON_BLANK;
        }
        int leng = txt.length();
        StringBuffer sbuf = new StringBuffer(leng + 2);
        sbuf.append('\"');
        block9: for (int i = 0; i < leng; ++i) {
            char c = txt.charAt(i);
            switch (c) {
                case '\"': {
                    sbuf.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sbuf.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sbuf.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sbuf.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sbuf.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sbuf.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sbuf.append("\\t");
                    continue block9;
                }
                default: {
                    if (c <= '\u007f') {
                        sbuf.append(c);
                        continue block9;
                    }
                    sbuf.append("\\u");
                    String hex = Integer.toHexString(c);
                    for (int j = hex.length(); j < 4; ++j) {
                        sbuf.append('0');
                    }
                    sbuf.append(hex);
                }
            }
        }
        sbuf.append('\"');
        return sbuf.toString();
    }

    private static <T> EcsvEncoder createArrayEncoder(String elementType, final int[] stilShape, final Class<T> aclazz, final char delimiter, final ElementEncoder<T> elEnc) {
        int ndim;
        int nel;
        String dimsTxt;
        if (stilShape == null || stilShape.length == 0) {
            dimsTxt = JSON_BLANK;
            nel = -1;
            ndim = 1;
        } else {
            int nd = stilShape.length;
            boolean isFixed = true;
            int n = 1;
            for (int i2 = 0; i2 < nd; ++i2) {
                int dim = stilShape[i2];
                isFixed = isFixed && dim > 0;
                n *= Math.abs(dim);
            }
            if (isFixed) {
                nel = n;
                dimsTxt = IntStream.range(0, nd).map(i -> stilShape[nd - 1 - i]).mapToObj(Integer::toString).collect(Collectors.joining(","));
                ndim = nd;
            } else {
                nel = -1;
                dimsTxt = JSON_BLANK;
                ndim = 1;
            }
        }
        String subtype = elementType + "[" + dimsTxt + "]";
        if (ndim == 1) {
            return new EcsvEncoder("string", subtype){

                @Override
                public String encode(Object value) {
                    if (aclazz.isInstance(value)) {
                        Object tval = aclazz.cast(value);
                        int tleng = Array.getLength(tval);
                        int leng = nel > 0 ? nel : tleng;
                        StringBuffer sbuf = new StringBuffer();
                        sbuf.append('[');
                        for (int i = 0; i < leng; ++i) {
                            if (i > 0) {
                                sbuf.append(',');
                            }
                            sbuf.append(i < tleng ? elEnc.elementToJson(tval, i) : EcsvEncoder.JSON_BLANK);
                        }
                        sbuf.append(']');
                        return 10.quoteString(sbuf.toString(), delimiter);
                    }
                    return null;
                }
            };
        }
        return new EcsvEncoder("string", subtype){

            @Override
            public String encode(Object value) {
                if (aclazz.isInstance(value)) {
                    Object tval = aclazz.cast(value);
                    if (Array.getLength(tval) == nel) {
                        StringBuffer sbuf = new StringBuffer();
                        EcsvEncoder.appendElements(sbuf, tval, 0, stilShape, elEnc);
                        return 11.quoteString(sbuf.toString(), delimiter);
                    }
                    return null;
                }
                return null;
            }
        };
    }

    private static <T> int appendElements(StringBuffer sbuf, T array, int pos, int[] dims, ElementEncoder<T> elEnc) {
        sbuf.append('[');
        int ndim = dims.length;
        int limit = dims[ndim - 1];
        if (ndim == 1) {
            for (int i = 0; i < limit; ++i) {
                if (i > 0) {
                    sbuf.append(',');
                }
                sbuf.append(elEnc.elementToJson(array, pos++));
            }
        } else {
            int[] subdims = new int[ndim - 1];
            System.arraycopy(dims, 0, subdims, 0, ndim - 1);
            for (int i = 0; i < limit; ++i) {
                if (i > 0) {
                    sbuf.append(',');
                }
                pos = EcsvEncoder.appendElements(sbuf, array, pos, subdims, elEnc);
            }
        }
        sbuf.append(']');
        return pos;
    }

    @FunctionalInterface
    private static interface ElementEncoder<T> {
        public String elementToJson(T var1, int var2);
    }
}

