/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ecsv;

import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import uk.ac.starlink.ecsv.EcsvColumn;
import uk.ac.starlink.ecsv.EcsvFormatException;
import uk.ac.starlink.ecsv.EcsvHeader;
import uk.ac.starlink.ecsv.EcsvMeta;
import uk.ac.starlink.ecsv.EcsvReader;
import uk.ac.starlink.ecsv.EcsvStarTable;
import uk.ac.starlink.ecsv.MessagePolicy;
import uk.ac.starlink.ecsv.SnakeYamlParser;
import uk.ac.starlink.ecsv.YamlParser;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.formats.DocumentedTableBuilder;
import uk.ac.starlink.util.ConfigMethod;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.util.URLUtils;

public class EcsvTableBuilder
extends DocumentedTableBuilder {
    private final YamlParser yamlParser_ = new SnakeYamlParser();
    private String headerLoc_;
    private MessagePolicy colCheck_ = MessagePolicy.WARN;
    private byte[] headerBuf_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ecsv");

    public EcsvTableBuilder() {
        super(new String[]{"ecsv"});
    }

    @Override
    public String getFormatName() {
        return "ECSV";
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    @ConfigMethod(property="header", doc="<p>Location of a file containing a header to be applied\nto the start of the input file.\nBy using this you can apply your own ECSV-format metadata\nto plain CSV files.\n</p>", usage="<filename-or-url>", example="http://cdn.gea.esac.esa.int/Gaia/gedr3/ECSV_headers/gaia_source.header", sequence=1)
    public void setHeader(String headerLoc) {
        this.headerLoc_ = headerLoc;
    }

    public String getHeader() {
        return this.headerLoc_;
    }

    @ConfigMethod(property="colcheck", doc="<p>Determines the action taken if the columns named\nin the YAML header differ from the columns named in the\nfirst line of the CSV part of the file.\n</p>", example="FAIL", sequence=2)
    public void setColcheck(MessagePolicy colCheck) {
        this.colCheck_ = colCheck;
    }

    public MessagePolicy getColcheck() {
        return this.colCheck_;
    }

    @Override
    public void streamStarTable(InputStream in, TableSink sink, String pos) throws IOException {
        try (EcsvReader reader = this.createEcsvReader(in, this.colCheck_);){
            EcsvStarTable stMeta = new EcsvStarTable(reader.getMeta()){

                @Override
                public RowSequence getRowSequence() {
                    throw new UnsupportedOperationException();
                }
            };
            sink.acceptMetadata(stMeta);
            while (reader.next()) {
                sink.acceptRow(reader.getRow());
            }
            sink.endRows();
        }
        catch (EcsvFormatException e) {
            throw new TableFormatException(e.getMessage(), e);
        }
    }

    @Override
    public StarTable makeStarTable(final DataSource datsrc, boolean wantRandom, StoragePolicy storagePolicy) throws IOException {
        EcsvMeta meta;
        if (this.headerLoc_ == null && !EcsvHeader.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("No ECSV header");
        }
        try (EcsvReader reader = this.createEcsvReader(datsrc.getInputStream(), this.colCheck_);){
            meta = reader.getMeta();
        }
        EcsvColumn<?>[] ecols = meta.getColumns();
        for (int ic = 0; ic < ecols.length; ++ic) {
            EcsvColumn<?> ecol = ecols[ic];
            String msg = ecol.getDecoder().getWarning();
            if (msg == null) continue;
            logger_.warning("Column " + ecol.getName() + " (#" + (ic + 1) + "): " + msg);
        }
        return new EcsvStarTable(meta){

            @Override
            public RowSequence getRowSequence() throws IOException {
                final EcsvReader rdr = EcsvTableBuilder.this.createEcsvReader(datsrc.getInputStream(), MessagePolicy.IGNORE);
                return new RowSequence(){

                    @Override
                    public boolean next() throws IOException {
                        try {
                            return rdr.next();
                        }
                        catch (EcsvFormatException e) {
                            throw new TableFormatException(e.getMessage(), e);
                        }
                    }

                    @Override
                    public Object[] getRow() {
                        return rdr.getRow();
                    }

                    @Override
                    public Object getCell(int icol) {
                        return rdr.getCell(icol);
                    }

                    @Override
                    public void close() throws IOException {
                        rdr.close();
                    }
                };
            }
        };
    }

    @Override
    public String getXmlDescription() {
        return this.readText("EcsvTableBuilder.xml");
    }

    @Override
    public boolean canStream() {
        return true;
    }

    @Override
    public boolean docIncludesExample() {
        return false;
    }

    private InputStream applyHeader(InputStream in) throws IOException {
        return this.headerLoc_ == null ? in : new SequenceInputStream(new ByteArrayInputStream(this.getHeaderBytes()), in);
    }

    private byte[] getHeaderBytes() throws IOException {
        if (this.headerLoc_ == null) {
            return new byte[0];
        }
        if (this.headerBuf_ == null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IOUtils.copy(EcsvTableBuilder.getInputStream(this.headerLoc_), bout);
            this.headerBuf_ = bout.toByteArray();
        }
        return this.headerBuf_;
    }

    private static InputStream getInputStream(String location) throws IOException {
        URL url;
        File file = new File(location);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        try {
            url = URLUtils.newURL(location);
        }
        catch (MalformedURLException e) {
            String msg = "No file or URL \"" + location + "\"";
            throw new FileNotFoundException(msg);
        }
        return url.openStream();
    }

    private EcsvReader createEcsvReader(InputStream in, MessagePolicy colCheck) throws IOException {
        try {
            return new EcsvReader(this.applyHeader(in), this.yamlParser_, colCheck);
        }
        catch (EcsvFormatException e) {
            throw new TableFormatException(e.getMessage(), e);
        }
    }
}

