/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.parquet;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnReadStore;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import uk.ac.starlink.parquet.Decoder;
import uk.ac.starlink.parquet.InputColumn;
import uk.ac.starlink.parquet.ParquetStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.storage.Codec;
import uk.ac.starlink.table.storage.ColumnStore;
import uk.ac.starlink.table.storage.ColumnStoreStarTable;
import uk.ac.starlink.table.storage.IndexedStreamColumnStore;
import uk.ac.starlink.table.storage.StreamColumnStore;
import uk.ac.starlink.util.IOSupplier;

public class CachedParquetStarTable
extends ParquetStarTable {
    private final ColumnStoreStarTable dataTable_;
    private final Path basePath_;
    private final Collection<File> tmpFiles_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.parquet");

    public CachedParquetStarTable(IOSupplier<ParquetFileReader> pfrSupplier, ParquetStarTable.Config config, int nthread) throws IOException {
        super(pfrSupplier, config);
        if (nthread <= 0) {
            nthread = CachedParquetStarTable.getDefaultThreadCount();
        }
        this.basePath_ = Files.createTempDirectory("CacheTable", new FileAttribute[0]);
        this.basePath_.toFile().deleteOnExit();
        this.tmpFiles_ = Collections.newSetFromMap(new ConcurrentHashMap());
        logger_.info("Will cache parquet data in " + this.basePath_);
        ExecutorService executor = Executors.newFixedThreadPool(nthread);
        ArrayList<Future<ColumnStore>> futures = new ArrayList<Future<ColumnStore>>();
        int ncol = this.getColumnCount();
        int icol = 0;
        while (icol < ncol) {
            int ic = icol++;
            Callable<ColumnStore> callable = () -> this.readColumn(ic);
            futures.add(executor.submit(callable));
        }
        ArrayList colStores = new ArrayList();
        try {
            for (Future future : futures) {
                colStores.add(future.get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            executor.shutdownNow();
            this.deleteFiles();
            throw new IOException("Parallel read failure", e);
        }
        executor.shutdown();
        ColumnStore[] cstores = colStores.toArray(new ColumnStore[0]);
        this.dataTable_ = new ColumnStoreStarTable(this, this.getRowCount(), cstores);
    }

    @Override
    public boolean isRandom() {
        return true;
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        return this.dataTable_.getRowSequence();
    }

    @Override
    public RowAccess getRowAccess() throws IOException {
        return this.dataTable_.getRowAccess();
    }

    @Override
    public RowSplittable getRowSplittable() throws IOException {
        return this.dataTable_.getRowSplittable();
    }

    @Override
    public Object getCell(long irow, int icol) throws IOException {
        return this.dataTable_.getCell(irow, icol);
    }

    @Override
    public Object[] getRow(long irow) throws IOException {
        return this.dataTable_.getRow(irow);
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.deleteFiles();
        }
    }

    private ColumnStore readColumn(int icol) throws IOException {
        PageReadStore pageStore;
        ColumnStore colStore;
        InputColumn<?> incol = this.getInputColumn(icol);
        ColumnInfo cinfo = this.getColumnInfo(icol);
        ArrayList<File> tmpFiles = new ArrayList<File>();
        Codec codec = Codec.getCodec(cinfo);
        int itemSize = codec.getItemSize();
        boolean fixedSize = itemSize >= 0;
        File dataFile = this.createTempFile(icol, "dat");
        tmpFiles.add(dataFile);
        if (fixedSize) {
            colStore = new StreamColumnStore(codec, dataFile);
        } else {
            File indexFile = this.createTempFile(icol, "idx");
            tmpFiles.add(indexFile);
            colStore = new IndexedStreamColumnStore(codec, dataFile, indexFile);
        }
        logger_.config("Caching data for column " + cinfo.getName() + " " + tmpFiles);
        String[] cpath = incol.getColumnDescriptor().getPath();
        ArrayList<Type> types = new ArrayList<Type>();
        MessageType schema = this.getSchema();
        for (int ip = 1; ip <= cpath.length; ++ip) {
            String[] subpath = new String[ip];
            System.arraycopy(cpath, 0, subpath, 0, ip);
            types.add(schema.getType(subpath));
        }
        MessageType projSchema = new MessageType("col_" + cinfo.getName(), types);
        ParquetFileReader pfr = this.getParquetFileReader();
        pfr.setRequestedSchema(projSchema);
        ColumnDescriptor cdesc = incol.getColumnDescriptor();
        int cdefmax = cdesc.getMaxDefinitionLevel();
        while ((pageStore = pfr.readNextRowGroup()) != null) {
            ColumnReadStore crstore = this.getColumnReadStore(pageStore, projSchema);
            Decoder<?> decoder = incol.createDecoder();
            ColumnReader crdr = crstore.getColumnReader(cdesc);
            long nr = pageStore.getRowCount();
            for (long ir = 0L; ir < nr; ++ir) {
                decoder.clearValue();
                do {
                    int cdef;
                    if ((cdef = crdr.getCurrentDefinitionLevel()) == cdefmax) {
                        decoder.readItem(crdr);
                    } else if (cdef == cdefmax - 1) {
                        decoder.readNull();
                    }
                    crdr.consume();
                } while (crdr.getCurrentRepetitionLevel() > 0);
                colStore.acceptCell(decoder.getValue());
            }
        }
        colStore.endCells();
        return colStore;
    }

    private File createTempFile(int icol, String ftype) throws IOException {
        Path fpath = this.basePath_.getFileSystem().getPath(this.basePath_.toString(), "col-" + icol + "." + ftype);
        FileAttribute<Set<PosixFilePermission>> permissions = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------"));
        Files.createFile(fpath, permissions);
        File file = fpath.toFile();
        file.deleteOnExit();
        this.tmpFiles_.add(file);
        return file;
    }

    private void deleteFiles() {
        Iterator<File> it = this.tmpFiles_.iterator();
        while (it.hasNext()) {
            File file = it.next();
            if (!file.delete()) {
                logger_.warning("Failed to remove temp file " + file);
            }
            it.remove();
        }
        if (!this.basePath_.toFile().delete()) {
            logger_.warning("Failed to remove temp dir " + this.basePath_);
        }
    }

    static int getDefaultThreadCount() {
        return Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
    }
}

