/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.parquet;

import java.lang.reflect.Array;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import uk.ac.starlink.parquet.Encoder;
import uk.ac.starlink.parquet.NullsWithoutGroupArrayException;
import uk.ac.starlink.table.ColumnInfo;

public class Encoders {
    private Encoders() {
    }

    public static Encoder<?> createEncoder(ColumnInfo info, boolean groupArray) {
        Class<?> clazz = info.getContentClass();
        String cname = info.getName();
        if (clazz.equals(Boolean.class)) {
            return Encoders.createScalarEncoder(Boolean.class, cname, PrimitiveType.PrimitiveTypeName.BOOLEAN, null, val -> false, (val, cns) -> cns.addBoolean(val.booleanValue()));
        }
        if (clazz.equals(Byte.class)) {
            return Encoders.createScalarEncoder(Byte.class, cname, PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true), val -> false, (val, cns) -> cns.addInteger(val.intValue()));
        }
        if (clazz.equals(Short.class)) {
            return Encoders.createScalarEncoder(Short.class, cname, PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true), val -> false, (val, cns) -> cns.addInteger(val.intValue()));
        }
        if (clazz.equals(Integer.class)) {
            return Encoders.createScalarEncoder(Integer.class, cname, PrimitiveType.PrimitiveTypeName.INT32, null, val -> false, (val, cns) -> cns.addInteger(val.intValue()));
        }
        if (clazz.equals(Long.class)) {
            return Encoders.createScalarEncoder(Long.class, cname, PrimitiveType.PrimitiveTypeName.INT64, null, val -> false, (val, cns) -> cns.addLong(val.longValue()));
        }
        if (clazz.equals(Float.class)) {
            return Encoders.createScalarEncoder(Float.class, cname, PrimitiveType.PrimitiveTypeName.FLOAT, null, val -> val.isNaN(), (val, cns) -> cns.addFloat(val.floatValue()));
        }
        if (clazz.equals(Double.class)) {
            return Encoders.createScalarEncoder(Double.class, cname, PrimitiveType.PrimitiveTypeName.DOUBLE, null, val -> val.isNaN(), (val, cns) -> cns.addDouble(val.doubleValue()));
        }
        if (clazz.equals(String.class)) {
            return Encoders.createScalarEncoder(String.class, cname, PrimitiveType.PrimitiveTypeName.BINARY, (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType(), val -> val.length() == 0, (val, cns) -> cns.addBinary(Binary.fromString((String)val)));
        }
        if (clazz.equals(boolean[].class)) {
            return Encoders.createArrayEncoder(boolean[].class, cname, PrimitiveType.PrimitiveTypeName.BOOLEAN, null, (val, ix) -> new WritableElement((boolean[])val, ix){
                boolean el;
                final /* synthetic */ boolean[] val$val;
                final /* synthetic */ int val$ix;
                {
                    this.val$val = blArray;
                    this.val$ix = n;
                    this.el = this.val$val[this.val$ix];
                }

                @Override
                public boolean isBlank() {
                    return false;
                }

                @Override
                public void writeToRecord(RecordConsumer cns) {
                    cns.addBoolean(this.el);
                }
            }, groupArray);
        }
        if (clazz.equals(byte[].class)) {
            return Encoders.createArrayEncoder(byte[].class, cname, PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true), (val, ix) -> new WritableElement((byte[])val, ix){
                byte el;
                final /* synthetic */ byte[] val$val;
                final /* synthetic */ int val$ix;
                {
                    this.val$val = byArray;
                    this.val$ix = n;
                    this.el = this.val$val[this.val$ix];
                }

                @Override
                public boolean isBlank() {
                    return false;
                }

                @Override
                public void writeToRecord(RecordConsumer cns) {
                    cns.addInteger((int)this.el);
                }
            }, groupArray);
        }
        if (clazz.equals(short[].class)) {
            return Encoders.createArrayEncoder(short[].class, cname, PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true), (val, ix) -> new WritableElement((short[])val, ix){
                short el;
                final /* synthetic */ short[] val$val;
                final /* synthetic */ int val$ix;
                {
                    this.val$val = sArray;
                    this.val$ix = n;
                    this.el = this.val$val[this.val$ix];
                }

                @Override
                public boolean isBlank() {
                    return false;
                }

                @Override
                public void writeToRecord(RecordConsumer cns) {
                    cns.addInteger((int)this.el);
                }
            }, groupArray);
        }
        if (clazz.equals(int[].class)) {
            return Encoders.createArrayEncoder(int[].class, cname, PrimitiveType.PrimitiveTypeName.INT32, null, (val, ix) -> new WritableElement((int[])val, ix){
                int el;
                final /* synthetic */ int[] val$val;
                final /* synthetic */ int val$ix;
                {
                    this.val$val = nArray;
                    this.val$ix = n;
                    this.el = this.val$val[this.val$ix];
                }

                @Override
                public boolean isBlank() {
                    return false;
                }

                @Override
                public void writeToRecord(RecordConsumer cns) {
                    cns.addInteger(this.el);
                }
            }, groupArray);
        }
        if (clazz.equals(long[].class)) {
            return Encoders.createArrayEncoder(long[].class, cname, PrimitiveType.PrimitiveTypeName.INT64, null, (val, ix) -> new WritableElement((long[])val, ix){
                long el;
                final /* synthetic */ long[] val$val;
                final /* synthetic */ int val$ix;
                {
                    this.val$val = lArray;
                    this.val$ix = n;
                    this.el = this.val$val[this.val$ix];
                }

                @Override
                public boolean isBlank() {
                    return false;
                }

                @Override
                public void writeToRecord(RecordConsumer cns) {
                    cns.addLong(this.el);
                }
            }, groupArray);
        }
        if (clazz.equals(float[].class)) {
            return Encoders.createArrayEncoder(float[].class, cname, PrimitiveType.PrimitiveTypeName.FLOAT, null, (val, ix) -> new WritableElement((float[])val, ix){
                float el;
                final /* synthetic */ float[] val$val;
                final /* synthetic */ int val$ix;
                {
                    this.val$val = fArray;
                    this.val$ix = n;
                    this.el = this.val$val[this.val$ix];
                }

                @Override
                public boolean isBlank() {
                    return Float.isNaN(this.el);
                }

                @Override
                public void writeToRecord(RecordConsumer cns) {
                    cns.addFloat(this.el);
                }
            }, groupArray);
        }
        if (clazz.equals(double[].class)) {
            return Encoders.createArrayEncoder(double[].class, cname, PrimitiveType.PrimitiveTypeName.DOUBLE, null, (val, ix) -> new WritableElement((double[])val, ix){
                double el;
                final /* synthetic */ double[] val$val;
                final /* synthetic */ int val$ix;
                {
                    this.val$val = dArray;
                    this.val$ix = n;
                    this.el = this.val$val[this.val$ix];
                }

                @Override
                public boolean isBlank() {
                    return Double.isNaN(this.el);
                }

                @Override
                public void writeToRecord(RecordConsumer cns) {
                    cns.addDouble(this.el);
                }
            }, groupArray);
        }
        if (clazz.equals(String[].class)) {
            return Encoders.createArrayEncoder(String[].class, cname, PrimitiveType.PrimitiveTypeName.BINARY, (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType(), (val, ix) -> new WritableElement((String[])val, ix){
                String el;
                final /* synthetic */ String[] val$val;
                final /* synthetic */ int val$ix;
                {
                    this.val$val = stringArray;
                    this.val$ix = n;
                    this.el = this.val$val[this.val$ix];
                }

                @Override
                public boolean isBlank() {
                    return this.el == null || this.el.length() == 0;
                }

                @Override
                public void writeToRecord(RecordConsumer cns) {
                    cns.addBinary(Binary.fromString((String)this.el));
                }
            }, groupArray);
        }
        return null;
    }

    private static <T> Encoder<T> createScalarEncoder(Class<T> clazz, String cname, PrimitiveType.PrimitiveTypeName primType, LogicalTypeAnnotation logType, Predicate<T> isBlank, BiConsumer<T, RecordConsumer> consume) {
        Types.PrimitiveBuilder builder = Types.optional((PrimitiveType.PrimitiveTypeName)primType);
        if (logType != null) {
            builder = (Types.PrimitiveBuilder)builder.as(logType);
        }
        Function<Object, Object> toTyped = value -> {
            if (clazz.isInstance(value)) {
                Object tval = clazz.cast(value);
                return isBlank.test(tval) ? null : tval;
            }
            return null;
        };
        PrimitiveType type = (PrimitiveType)builder.named(cname);
        Runnable checkNull = () -> {};
        return new DefaultEncoder<Object>(cname, (Type)type, toTyped, consume, checkNull);
    }

    private static <T> Encoder<T> createArrayEncoder(Class<T> clazz, String cname, PrimitiveType.PrimitiveTypeName primType, LogicalTypeAnnotation logType, ArrayReader<T> arrayReader, boolean groupArray) {
        Function<Object, Object> toTyped = value -> clazz.isInstance(value) && Array.getLength(value) > 0 ? clazz.cast(value) : null;
        if (groupArray) {
            Types.PrimitiveBuilder elBuilder = Types.optional((PrimitiveType.PrimitiveTypeName)primType);
            if (logType != null) {
                elBuilder = (Types.PrimitiveBuilder)elBuilder.as(logType);
            }
            String elName = "element";
            String listName = "list";
            PrimitiveType elType = (PrimitiveType)elBuilder.named("element");
            GroupType listType = (GroupType)Types.optionalList().element((Type)elType).named(cname);
            BiConsumer<Object, RecordConsumer> consume = (val, cns) -> {
                cns.startGroup();
                cns.startField("list", 0);
                int nel = Array.getLength(val);
                for (int i = 0; i < nel; ++i) {
                    cns.startGroup();
                    WritableElement writable = arrayReader.getWritable(val, i);
                    if (!writable.isBlank()) {
                        cns.startField("element", 0);
                        writable.writeToRecord((RecordConsumer)cns);
                        cns.endField("element", 0);
                    }
                    cns.endGroup();
                }
                cns.endField("list", 0);
                cns.endGroup();
            };
            Runnable checkNull = () -> {};
            return new DefaultEncoder<Object>(cname, (Type)listType, toTyped, consume, checkNull);
        }
        Types.PrimitiveBuilder elBuilder = Types.repeated((PrimitiveType.PrimitiveTypeName)primType);
        if (logType != null) {
            elBuilder = (Types.PrimitiveBuilder)elBuilder.as(logType);
        }
        PrimitiveType elType = (PrimitiveType)elBuilder.named(cname);
        BiConsumer<Object, RecordConsumer> consume = (val, cns) -> {
            int nel = Array.getLength(val);
            for (int i = 0; i < nel; ++i) {
                WritableElement writable = arrayReader.getWritable(val, i);
                if (writable.isBlank()) {
                    String msg = "Null array elements not permitted for groupArray=false";
                    throw new NullsWithoutGroupArrayException(msg);
                }
                writable.writeToRecord((RecordConsumer)cns);
            }
        };
        Runnable checkNull = () -> {
            String msg = "Null array values not permitted for groupArray=false";
            throw new NullsWithoutGroupArrayException(msg);
        };
        return new DefaultEncoder<Object>(cname, (Type)elType, toTyped, consume, checkNull);
    }

    @FunctionalInterface
    private static interface ArrayReader<T> {
        public WritableElement getWritable(T var1, int var2);
    }

    private static interface WritableElement {
        public boolean isBlank();

        public void writeToRecord(RecordConsumer var1);
    }

    private static class DefaultEncoder<T>
    implements Encoder<T> {
        final String cname_;
        final Type type_;
        final Function<Object, T> toTyped_;
        final BiConsumer<T, RecordConsumer> consumeValue_;
        final Runnable checkNull_;

        DefaultEncoder(String cname, Type type, Function<Object, T> toTyped, BiConsumer<T, RecordConsumer> consumeValue, Runnable checkNull) {
            this.cname_ = cname;
            this.type_ = type;
            this.toTyped_ = toTyped;
            this.consumeValue_ = consumeValue;
            this.checkNull_ = checkNull;
        }

        @Override
        public String getColumnName() {
            return this.cname_;
        }

        @Override
        public Type getColumnType() {
            return this.type_;
        }

        @Override
        public T typedValue(Object obj) {
            return this.toTyped_.apply(obj);
        }

        @Override
        public void addValue(T tValue, RecordConsumer consumer) {
            this.consumeValue_.accept(tValue, consumer);
        }

        @Override
        public void checkNull() {
            this.checkNull_.run();
        }
    }
}

