/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.parquet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class FileInputFile
implements InputFile {
    private final File file_;

    public FileInputFile(File file) {
        this.file_ = file;
    }

    public long getLength() {
        return this.file_.length();
    }

    public SeekableInputStream newStream() throws IOException {
        return new FileSeekableInputStream(new FileInputStream(this.file_));
    }

    private static class FileSeekableInputStream
    extends DelegatingSeekableInputStream {
        private final FileInputStream in_;
        private long pos_;

        public FileSeekableInputStream(FileInputStream in) {
            super((InputStream)in);
            this.in_ = in;
        }

        public long getPos() {
            return this.pos_;
        }

        public void seek(long newPos) throws IOException {
            this.in_.skip(newPos - this.pos_);
            this.pos_ = newPos;
        }

        public int read() throws IOException {
            int b = this.in_.read();
            if (b >= 0) {
                ++this.pos_;
            }
            return b;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int nb = this.in_.read(b, off, len);
            if (nb > 0) {
                this.pos_ += (long)nb;
            }
            return nb;
        }

        public int read(byte[] b) throws IOException {
            int nb = this.in_.read(b);
            if (nb > 0) {
                this.pos_ += (long)nb;
            }
            return nb;
        }

        public long skip(long nreq) throws IOException {
            long nb = this.in_.skip(nreq);
            this.pos_ += nb;
            return nb;
        }

        public void readFully(byte[] bytes) throws IOException {
            super.readFully(bytes);
            this.pos_ += (long)bytes.length;
        }

        public void readFully(byte[] bytes, int start, int len) throws IOException {
            super.readFully(bytes, start, len);
            this.pos_ += (long)len;
        }

        public void readFully(ByteBuffer bbuf) throws IOException {
            int nb = bbuf.remaining();
            super.readFully(bbuf);
            this.pos_ += (long)nb;
        }

        public boolean markSupported() {
            return false;
        }

        public void reset() throws IOException {
            throw new IOException("Mark not supported");
        }
    }
}

