/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.parquet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;
import uk.ac.starlink.parquet.CachedParquetStarTable;
import uk.ac.starlink.parquet.NullsWithoutGroupArrayException;
import uk.ac.starlink.parquet.ParquetStarTable;
import uk.ac.starlink.parquet.ParquetTableBuilder;
import uk.ac.starlink.parquet.ParquetTableWriter;
import uk.ac.starlink.parquet.SequentialParquetStarTable;
import uk.ac.starlink.parquet.StarParquetWriter;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;
import uk.ac.starlink.util.IOSupplier;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.votable.VOTableVersion;

public class ParquetIO {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.parquet");

    public ParquetStarTable readParquet(DataSource datsrc, ParquetTableBuilder builder, ParquetStarTable.Config config, boolean useCache, boolean tryUrl) throws IOException {
        IOSupplier<ParquetFileReader> pfrSupplier = ParquetIO.readerSupplier(ParquetIO.createInputFile(datsrc, tryUrl), datsrc.getName());
        if (useCache) {
            int nThread = builder.getReadThreadCount();
            if (nThread <= 0) {
                nThread = CachedParquetStarTable.getDefaultThreadCount();
            }
            logger_.info("Caching parquet column data for " + datsrc + " with " + nThread + " threads");
            try {
                return new CachedParquetStarTable(pfrSupplier, config, nThread);
            }
            catch (IOException e) {
                logger_.log(Level.WARNING, "Cached read failed for " + datsrc, e);
            }
        }
        logger_.info("No parquet column caching for " + datsrc);
        return new SequentialParquetStarTable(pfrSupplier, config);
    }

    public void writeParquet(StarTable table, ParquetTableWriter writer, String location) throws IOException {
        Path path = new Path(location);
        StarParquetWriter.StarBuilder builder = new StarParquetWriter.StarBuilder(table, path);
        ParquetIO.configureBuilder(builder, writer);
        ParquetIO.writeParquetTable(builder);
    }

    public void writeParquet(StarTable table, ParquetTableWriter writer, OutputStream out) throws IOException {
        StarParquetWriter.StarBuilder builder = new StarParquetWriter.StarBuilder(table, ParquetIO.createOutputFile(out));
        ParquetIO.configureBuilder(builder, writer);
        ParquetIO.writeParquetTable(builder);
    }

    private static IOSupplier<ParquetFileReader> readerSupplier(InputFile inFile, String name) {
        return () -> {
            try {
                return ParquetFileReader.open((InputFile)inFile);
            }
            catch (RuntimeException e) {
                throw new TableFormatException("Trouble opening " + name + " as parquet", e);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static InputFile createInputFile(DataSource datsrc, boolean tryUrl) throws IOException {
        Path path = null;
        File file = ParquetIO.getFile(datsrc);
        URL url = datsrc.getURL();
        if (file != null) {
            path = new Path(file.getPath());
            return HadoopInputFile.fromPath((Path)path, (Configuration)new Configuration());
        } else {
            if (url == null) throw new IOException("Can't turn " + datsrc.getClass().getName() + " " + datsrc + " into input file");
            if (!tryUrl) throw new TableFormatException("Parquet files must be local, can't use URL " + url);
            logger_.warning(datsrc + " doesn't look like a local file: try as URL but may not work");
            path = new Path(url.toString());
        }
        return HadoopInputFile.fromPath((Path)path, (Configuration)new Configuration());
    }

    private static File getFile(DataSource datsrc) {
        if (datsrc instanceof FileDataSource) {
            return ((FileDataSource)datsrc).getFile();
        }
        URL url = datsrc.getURL();
        return url == null ? null : URLUtils.urlToFile((String)url.toString());
    }

    private static void configureBuilder(StarParquetWriter.StarBuilder builder, ParquetTableWriter writer) {
        Boolean useDict;
        VOTableVersion vers;
        VOTableVersion votmetaVersion = writer.isVOTableMetadata() ? ((vers = writer.getVOTableVersion()) == null ? VOTableVersion.getDefaultVersion() : vers) : null;
        Map<String, String> kvItems = writer.getKeyValueItems();
        ((StarParquetWriter.StarBuilder)((StarParquetWriter.StarBuilder)builder.withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withGroupArray(writer.isGroupArray()).withVOTableMetadata(votmetaVersion).withValidation(true)).withKeyValueItems(kvItems);
        CompressionCodecName codec = writer.getCompressionCodec();
        if (codec != null) {
            builder.withCompressionCodec(codec);
        }
        if ((useDict = writer.isDictionaryEncoding()) != null) {
            builder.withDictionaryEncoding(useDict);
        }
    }

    private static void writeParquetTable(StarParquetWriter.StarBuilder bldr) throws IOException {
        try (ParquetWriter pwriter = bldr.build();
             RowSequence rseq = bldr.getTable().getRowSequence();){
            while (rseq.next()) {
                pwriter.write((Object)rseq.getRow());
            }
        }
        catch (NullsWithoutGroupArrayException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private static OutputFile createOutputFile(final OutputStream out) {
        return new OutputFile(){

            public PositionOutputStream create(long blockSizeHint) throws IOException {
                return ParquetIO.createPositionOutputStream(out);
            }

            public PositionOutputStream createOrOverwrite(long blockSizeHint) throws IOException {
                return ParquetIO.createPositionOutputStream(out);
            }

            public boolean supportsBlockSize() {
                return false;
            }

            public long defaultBlockSize() {
                return -1L;
            }
        };
    }

    private static PositionOutputStream createPositionOutputStream(final OutputStream out) {
        return new PositionOutputStream(){
            private long pos_;

            public long getPos() {
                return this.pos_;
            }

            public void write(int b) throws IOException {
                out.write(b);
                ++this.pos_;
            }

            public void write(byte[] b) throws IOException {
                out.write(b);
                this.pos_ += (long)b.length;
            }

            public void write(byte[] b, int off, int len) throws IOException {
                out.write(b, off, len);
                this.pos_ += (long)len;
            }

            public void flush() throws IOException {
                out.flush();
            }

            public void close() throws IOException {
                out.close();
            }
        };
    }
}

