/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.parquet;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.parquet.ParquetIO;
import uk.ac.starlink.util.IOSupplier;

public class ParquetUtil {
    private static final IOSupplier<ParquetIO> ioSupplier_ = ParquetUtil.createIOSupplier();

    private ParquetUtil() {
    }

    public static boolean isMagic(byte[] buffer) {
        return buffer.length >= 4 && (char)buffer[0] == 'P' && (char)buffer[1] == 'A' && (char)buffer[2] == 'R' && (char)buffer[3] == '1';
    }

    public static ParquetIO getIO() throws IOException {
        return (ParquetIO)ioSupplier_.get();
    }

    private static IOSupplier<ParquetIO> createIOSupplier() {
        Logger logger = Logger.getLogger("uk.ac.starlink.parquet");
        try {
            ParquetIO io = new ParquetIO();
            logger.info("Parquet support available");
            return () -> io;
        }
        catch (Throwable e) {
            logger.log(Level.INFO, "No Parquet support (parquet-mr missing)", e);
            return () -> {
                throw new IOException("Parquet-mr libraries not available", e);
            };
        }
    }
}

