/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.gbin;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.gbin.GbinTableProfile;
import uk.ac.starlink.gbin.Representation;

public class ItemReader {
    private final ItemReader parentReader_;
    private final Method method_;
    private final String itemName_;
    private final Representation<?> repr_;
    public static final ItemReader ROOT = new ItemReader(null, null, null, null);
    private static final String GET = "get";
    private static final String IS = "is";
    private static final Logger logger_ = Logger.getLogger(ItemReader.class.getName());

    public ItemReader(ItemReader parentReader, Method method, String itemName, Representation<?> repr) {
        this.parentReader_ = parentReader;
        this.method_ = method;
        this.itemName_ = itemName;
        this.repr_ = repr;
    }

    public boolean isRoot() {
        return this == ROOT;
    }

    public ItemReader getParentReader() {
        return this.parentReader_;
    }

    public String getItemName() {
        return this.itemName_;
    }

    public Class<?> getItemContentClass() {
        return this.repr_.getContentClass();
    }

    public Object readItem(Map<ItemReader, Object> itemMap) throws IOException {
        if (!itemMap.containsKey(this)) {
            Object parentItem = this.parentReader_ == null ? null : this.parentReader_.readItem(itemMap);
            Object item = parentItem == null ? null : (Object)this.repr_.representValue(this.invokeMethod(parentItem));
            itemMap.put(this, item);
        }
        assert (itemMap.containsKey(this));
        return itemMap.get(this);
    }

    private Object invokeMethod(Object parentItem) throws IOException {
        try {
            return this.method_.invoke(parentItem, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw (IOException)new IOException("Reflection trouble").initCause(e);
        }
        catch (IllegalArgumentException e) {
            throw (IOException)new IOException("Reflection trouble").initCause(e);
        }
        catch (InvocationTargetException e) {
            throw (IOException)new IOException(e.getTargetException().getMessage()).initCause(e);
        }
    }

    public static ItemReader[] createItemReaders(Class<?> rootClazz, GbinTableProfile profile) {
        ArrayList<ItemReader> rdrList = new ArrayList<ItemReader>();
        ItemReader.addItemReaders(rootClazz, ROOT, rdrList, 0, profile);
        return rdrList.toArray(new ItemReader[0]);
    }

    public static String getColumnName(ItemReader rdr, Map<String, List<ItemReader>> nameMap, boolean forceHier, String separator) {
        ItemReader parentRdr;
        String itemName = rdr.getItemName();
        StringBuffer sbuf = new StringBuffer();
        if ((forceHier || nameMap.containsKey(itemName) && nameMap.get(itemName).size() > 1) && !(parentRdr = rdr.getParentReader()).isRoot()) {
            sbuf.append(ItemReader.getColumnName(parentRdr, nameMap, forceHier, separator)).append(separator);
        }
        sbuf.append(itemName);
        return sbuf.toString();
    }

    private static void addItemReaders(Class<?> parentClazz, ItemReader parentRdr, List<ItemReader> rdrList, int iLevel, GbinTableProfile profile) {
        StringBuffer pbuf = new StringBuffer();
        for (int i = 0; i < iLevel; ++i) {
            pbuf.append("  ");
        }
        String prefix = pbuf.toString();
        if (!parentRdr.isRoot()) {
            logger_.config(new StringBuffer().append("GBIN obj: ").append(prefix).append("+ ").append(parentRdr.getItemName()).append("  (").append(parentRdr.getItemContentClass().getSimpleName()).append(")").toString());
        }
        HashSet<String> ignoreNames = new HashSet<String>(Arrays.asList(profile.getIgnoreMethodNames()));
        HashSet<String> ignoreMethodDeclaringClasses = new HashSet<String>(Arrays.asList(profile.getIgnoreMethodDeclaringClasses()));
        Method[] methods = parentClazz.getMethods();
        if (profile.isSortedMethods()) {
            Arrays.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method m1, Method m2) {
                    return m1.getName().compareTo(m2.getName());
                }
            });
        }
        for (Method method : methods) {
            String itemName;
            if (ignoreMethodDeclaringClasses.contains(method.getDeclaringClass().getName()) || (itemName = ItemReader.getItemName(method, ignoreNames)) == null) continue;
            Representation<?> repr = profile.createRepresentation(method.getReturnType());
            if (repr == null) {
                logger_.info("Skip GBIN column " + itemName + ", return type " + method.getReturnType().getSimpleName() + " blocked by profile");
                continue;
            }
            Class<?> clazz = repr.getContentClass();
            ItemReader rdr = new ItemReader(parentRdr, method, itemName, repr);
            if (repr.isColumn()) {
                rdrList.add(rdr);
                logger_.config(new StringBuffer().append("GBIN col: ").append(prefix).append("  - ").append(rdr.getItemName()).append("  (").append(clazz.getSimpleName()).append(")").toString());
                continue;
            }
            if (!ItemReader.hasAncestorType(rdr.getParentReader(), clazz)) {
                ItemReader.addItemReaders(clazz, rdr, rdrList, iLevel + 1, profile);
                continue;
            }
            logger_.warning("Skip GBIN column " + rdr + " (" + clazz.getSimpleName() + ") to avoid infinite recursion");
        }
    }

    private static String getItemName(Method method, Collection<String> ignoreNames) {
        String methodName = method.getName();
        Class<?> clazz = method.getReturnType();
        int mods = method.getModifiers();
        if (!ignoreNames.contains(methodName) && Modifier.isPublic(mods) && !Modifier.isStatic(mods) && method.getParameterTypes().length == 0) {
            if (methodName.matches("^get[A-Z0-9_].*$") && !Void.TYPE.equals(clazz)) {
                return methodName.substring(GET.length());
            }
            if (methodName.matches("^is[A-Z0-9_].*$") && (Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz))) {
                return methodName.substring(IS.length());
            }
            return null;
        }
        return null;
    }

    private static boolean hasAncestorType(ItemReader rdr, Class<?> clazz) {
        if (rdr.isRoot()) {
            return false;
        }
        if (rdr.getItemContentClass().equals(clazz)) {
            return true;
        }
        return ItemReader.hasAncestorType(rdr.getParentReader(), clazz);
    }
}

