/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.Documented;
import uk.ac.starlink.table.LoopTableScheme;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableScheme;

public class ClassTableScheme
implements TableScheme,
Documented {
    private static final Pattern CLASSNAME_REGEX = Pattern.compile("([\\p{L}[0-9]_$.]+):(.*)");

    @Override
    public String getSchemeName() {
        return "class";
    }

    @Override
    public String getSchemeUsage() {
        return "<TableScheme-classname>:<scheme-spec>";
    }

    @Override
    public String getExampleSpecification() {
        return LoopTableScheme.class.getName() + ":" + 5;
    }

    @Override
    public String getXmlDescription() {
        String prefix = ":" + this.getSchemeName() + ":";
        String exClassname = LoopTableScheme.class.getName();
        String exArglist = "10";
        return String.join((CharSequence)"\n", "<p>Uses an instance of a named class that implements", "the <code>uk.ac.starlink.table.TableScheme</code> interface", "and that has a no-arg constructor.", "Arguments to be passed to an instance of the named class", "are appended after a colon following the classname.", "</p>", "<p>For example, the specification", "\"<code>" + prefix + exClassname + ":" + exArglist + "</code>\"", "would return a table constructed by the code", "<code>new " + exClassname + "().createTable(\"" + exArglist + "\")</code>.", "</p>", "");
    }

    @Override
    public StarTable createTable(String spec) throws IOException {
        TableScheme subscheme;
        Class<?> clazz;
        Matcher matcher = CLASSNAME_REGEX.matcher(spec);
        if (!matcher.matches()) {
            throw new TableFormatException();
        }
        String classname = matcher.group(1);
        String subspec = matcher.group(2);
        try {
            clazz = Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            throw new TableFormatException("Unkown class " + classname);
        }
        if (!TableScheme.class.isAssignableFrom(clazz)) {
            throw new TableFormatException("Class " + classname + " does not implement " + TableScheme.class.getName());
        }
        Class<?> schemeClazz = clazz;
        try {
            subscheme = (TableScheme)schemeClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new TableFormatException("Can't instantiate " + clazz.getName(), e);
        }
        return subscheme.createTable(subspec);
    }
}

