/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.LongSupplier;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.EmptyRowSequence;
import uk.ac.starlink.table.EmptyStarTable;
import uk.ac.starlink.table.RandomRowSplittable;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.WrapperStarTable;

public class ConcatStarTable
extends WrapperStarTable {
    private final ColumnInfo[] colInfos_;
    private final List<StarTable> tableList_;
    private Iterator<StarTable> tableIt_;
    private Boolean isRandom_;
    private long nrow_ = -1L;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table");

    public ConcatStarTable(StarTable meta, Iterator<StarTable> tableIt) {
        super(meta);
        this.colInfos_ = Tables.getColumnInfos(meta);
        this.tableIt_ = tableIt;
        this.tableList_ = new ArrayList<StarTable>();
    }

    public ConcatStarTable(StarTable meta, StarTable[] tables) throws IOException {
        super(meta);
        this.colInfos_ = Tables.getColumnInfos(meta);
        for (int itab = 0; itab < tables.length; ++itab) {
            this.checkCompatible(tables[itab]);
        }
        this.tableIt_ = null;
        this.tableList_ = Arrays.asList(tables);
        this.gotTables();
    }

    @Override
    public long getRowCount() {
        return this.nrow_;
    }

    @Override
    public Object getCell(long irow, int icol) throws IOException {
        if (this.isRandom()) {
            for (StarTable table : this.tableList_) {
                long nr = table.getRowCount();
                assert (nr >= 0L);
                if (irow < nr) {
                    return table.getCell(irow, icol);
                }
                irow -= nr;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new UnsupportedOperationException("No random access");
    }

    @Override
    public Object[] getRow(long irow) throws IOException {
        if (this.isRandom()) {
            for (StarTable table : this.tableList_) {
                long nr = table.getRowCount();
                assert (nr >= 0L);
                if (irow < nr) {
                    return table.getRow(irow);
                }
                irow -= nr;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new UnsupportedOperationException("No random access");
    }

    @Override
    public boolean isRandom() {
        return this.isRandom_ != null && this.isRandom_ != false;
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        return new ConcatRowSequence(this.getTableIterator());
    }

    @Override
    public RowSplittable getRowSplittable() throws IOException {
        if (this.isRandom()) {
            return new RandomRowSplittable(this);
        }
        if (this.tableIt_ == null) {
            return new ConcatRowSplittable(this.tableList_.toArray(new StarTable[0]));
        }
        return Tables.getDefaultRowSplittable(this);
    }

    @Override
    public RowAccess getRowAccess() {
        if (!this.isRandom()) {
            throw new UnsupportedOperationException("No random access");
        }
        final int ntable = this.tableList_.size();
        final long[] istarts = new long[ntable + 1];
        for (int it = 0; it < ntable; ++it) {
            istarts[it + 1] = istarts[it] + this.tableList_.get(it).getRowCount();
        }
        return new RowAccess(){
            private final RowAccess[] subAccs_;
            private long irow_;
            private RowAccess subAcc_;
            {
                this.subAccs_ = new RowAccess[ntable];
                this.irow_ = -1L;
            }

            @Override
            public void setRowIndex(long irow) throws IOException {
                if (irow != this.irow_) {
                    long iSubrow;
                    int iTable;
                    this.irow_ = irow;
                    int ipos = Arrays.binarySearch(istarts, irow);
                    if (ipos >= 0) {
                        while (ipos < ntable && istarts[ipos + 1] == istarts[ipos]) {
                            ++ipos;
                        }
                        iTable = ipos;
                        iSubrow = 0L;
                    } else {
                        iTable = -2 - ipos;
                        iSubrow = irow - istarts[iTable];
                    }
                    if (this.subAccs_[iTable] == null) {
                        this.subAccs_[iTable] = ((StarTable)ConcatStarTable.this.tableList_.get(iTable)).getRowAccess();
                    }
                    this.subAcc_ = this.subAccs_[iTable];
                    boolean hasRow = istarts[iTable + 1] > istarts[iTable];
                    this.subAcc_.setRowIndex(hasRow ? iSubrow : -1L);
                }
            }

            @Override
            public Object getCell(int icol) throws IOException {
                return this.subAcc_.getCell(icol);
            }

            @Override
            public Object[] getRow() throws IOException {
                return this.subAcc_.getRow();
            }

            @Override
            public void close() {
                for (int i = 0; i < ntable; ++i) {
                    RowAccess subAcc = this.subAccs_[i];
                    if (subAcc == null) continue;
                    try {
                        subAcc.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.subAccs_[i] = null;
                }
            }
        };
    }

    private void checkCompatible(StarTable table) throws IOException {
        if (table.getRowCount() == 0L) {
            return;
        }
        int ncol0 = this.colInfos_.length;
        int ncol1 = table.getColumnCount();
        if (ncol1 != ncol0) {
            throw new IOException("Column count mismatch (" + ncol1 + " != " + ncol0 + ")");
        }
        for (int icol = 0; icol < ncol0; ++icol) {
            ColumnInfo info0 = this.colInfos_[icol];
            ColumnInfo info1 = table.getColumnInfo(icol);
            if (info0.getContentClass().isAssignableFrom(info1.getContentClass()) && info0.isArray() == info1.isArray()) continue;
            throw new IOException("Column type mismatch (" + info1 + " not compatible with " + info0 + ")");
        }
    }

    private synchronized void gotTables() {
        assert (this.isRandom_ == null);
        boolean isRand = true;
        long nrow = 0L;
        for (StarTable table : this.tableList_) {
            boolean bl = isRand = isRand && table.isRandom();
            if (nrow < 0L) continue;
            long nr = table.getRowCount();
            nrow = nr >= 0L ? nrow + nr : -1L;
        }
        this.isRandom_ = isRand;
        this.nrow_ = nrow;
    }

    private synchronized Iterator<StarTable> getTableIterator() {
        if (this.tableIt_ == null) {
            return this.tableList_.iterator();
        }
        return new Iterator<StarTable>(){
            private int index_;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                ConcatStarTable concatStarTable = ConcatStarTable.this;
                synchronized (concatStarTable) {
                    if (this.index_ < ConcatStarTable.this.tableList_.size()) {
                        return true;
                    }
                    if (ConcatStarTable.this.tableIt_ == null) {
                        return false;
                    }
                    if (ConcatStarTable.this.tableIt_.hasNext()) {
                        StarTable table = (StarTable)ConcatStarTable.this.tableIt_.next();
                        try {
                            ConcatStarTable.this.checkCompatible(table);
                        }
                        catch (IOException e) {
                            logger_.warning("Omitting incompatible table #" + ConcatStarTable.this.tableList_.size() + " - " + e.getMessage());
                            table = new EmptyStarTable(table);
                        }
                        ConcatStarTable.this.tableList_.add(table);
                        return true;
                    }
                    ConcatStarTable.this.tableIt_ = null;
                    ConcatStarTable.this.gotTables();
                    return false;
                }
            }

            @Override
            public StarTable next() {
                if (this.hasNext()) {
                    return (StarTable)ConcatStarTable.this.tableList_.get(this.index_++);
                }
                throw new IllegalStateException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static ColumnInfo[] extendColumnTypes(ColumnInfo[] colInfos, StarTable[] tables) throws IOException {
        int ncol = colInfos.length;
        ColumnInfo[] outInfos = new ColumnInfo[ncol];
        for (int it = 0; it < tables.length; ++it) {
            int ncol1 = tables[it].getColumnCount();
            if (ncol1 == ncol) continue;
            throw new IOException("Column count mismatch (" + ncol1 + " != " + ncol + ")");
        }
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnInfo info = new ColumnInfo(colInfos[icol]);
            for (int itab = 0; itab < tables.length; ++itab) {
                ColumnInfo info1 = tables[itab].getColumnInfo(icol);
                if (!info.getContentClass().isAssignableFrom(info1.getContentClass()) || info.isArray() != info1.isArray()) {
                    throw new IOException("Column type mismatch (" + info1 + " not compatible with " + info + ")");
                }
                if (info1.isNullable()) {
                    info.setNullable(true);
                }
                if (info1.getElementSize() != info.getElementSize()) {
                    info.setElementSize(-1);
                }
                if (!info.isArray()) continue;
                int[] shape = info.getShape();
                int[] shape1 = info1.getShape();
                if (shape == null || shape1 == null || shape.length == 0 || shape1.length == 0 || shape[0] < 1 || shape1[0] < 1 || shape.length != shape1.length) {
                    info.setShape(new int[]{-1});
                    continue;
                }
                if (Arrays.equals(shape, shape1)) continue;
                shape[shape.length - 1] = -1;
                info1.setShape(shape);
            }
            outInfos[icol] = info;
        }
        return outInfos;
    }

    private static class ConcatRowSplittable
    implements RowSplittable {
        private final StarTable[] tables_;
        private final long[] nrows_;
        private long ir0_;
        private long irow_;
        private int itab_;
        private int ntab_;
        private RowSequence rseq_;

        public ConcatRowSplittable(StarTable[] tables) {
            this(tables, ConcatRowSplittable.countRows(tables), -1, tables.length);
        }

        private ConcatRowSplittable(StarTable[] tables, long[] nrows, int itab, int ntab) {
            this.tables_ = tables;
            this.nrows_ = nrows;
            this.itab_ = itab;
            this.ntab_ = ntab;
            this.irow_ = -1L;
            this.ir0_ = this.getStartRowIndex();
        }

        @Override
        public RowSplittable split() {
            if (this.rseq_ == null && this.ntab_ - this.itab_ > 2) {
                int mid = (1 + this.itab_ + this.ntab_) / 2;
                ConcatRowSplittable split = new ConcatRowSplittable(this.tables_, this.nrows_, this.itab_, mid);
                this.itab_ = mid - 1;
                this.ir0_ = this.getStartRowIndex();
                return split;
            }
            return null;
        }

        @Override
        public long splittableSize() {
            int i;
            if (this.nrows_ == null) {
                return -1L;
            }
            long nr = 0L;
            int n = i = this.rseq_ == null ? this.itab_ + 1 : this.itab_;
            while (i < this.ntab_) {
                nr += this.nrows_[i];
                ++i;
            }
            return nr;
        }

        @Override
        public LongSupplier rowIndex() {
            return this.ir0_ >= 0L ? () -> this.ir0_ + this.irow_ : null;
        }

        @Override
        public boolean next() throws IOException {
            while (true) {
                if (this.rseq_ == null) {
                    if (this.itab_ + 1 == this.ntab_) {
                        return false;
                    }
                    ++this.itab_;
                    this.rseq_ = this.tables_[this.itab_].getRowSequence();
                    continue;
                }
                if (this.rseq_.next()) {
                    ++this.irow_;
                    return true;
                }
                this.rseq_.close();
                this.rseq_ = null;
            }
        }

        @Override
        public Object getCell(int icol) throws IOException {
            return this.rseq_.getCell(icol);
        }

        @Override
        public Object[] getRow() throws IOException {
            return this.rseq_.getRow();
        }

        @Override
        public void close() throws IOException {
            if (this.rseq_ != null) {
                this.rseq_ = null;
                this.itab_ = this.ntab_;
            }
        }

        private long getStartRowIndex() {
            if (this.nrows_ == null) {
                return -1L;
            }
            long ir0 = 0L;
            for (int i = 0; i < this.itab_ + 1; ++i) {
                ir0 += this.nrows_[i];
            }
            return ir0;
        }

        private static long[] countRows(StarTable[] tables) {
            int nt = tables.length;
            long[] nrows = new long[nt];
            for (int it = 0; it < nt; ++it) {
                nrows[it] = tables[it].getRowCount();
                if (nrows[it] >= 0L) continue;
                return null;
            }
            return nrows;
        }
    }

    private class ConcatRowSequence
    implements RowSequence {
        private final Iterator<StarTable> tIt_;
        private RowSequence rseq_;

        ConcatRowSequence(Iterator<StarTable> tableIt) {
            this.tIt_ = tableIt;
            this.rseq_ = EmptyRowSequence.getInstance();
        }

        @Override
        public boolean next() throws IOException {
            while (!this.rseq_.next()) {
                this.rseq_.close();
                if (this.tIt_.hasNext()) {
                    this.rseq_ = this.tIt_.next().getRowSequence();
                    continue;
                }
                return false;
            }
            return true;
        }

        @Override
        public Object getCell(int icol) throws IOException {
            return this.rseq_.getCell(icol);
        }

        @Override
        public Object[] getRow() throws IOException {
            return this.rseq_.getRow();
        }

        @Override
        public void close() throws IOException {
            this.rseq_.close();
        }
    }
}

