/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.logging.Logger;
import uk.ac.starlink.table.RowData;
import uk.ac.starlink.table.RowSequence;

public class CountCheckRowSequence
implements RowSequence {
    private final RowSequence base_;
    private final int ncol_;
    private final long nrow_;
    private long irow_;
    private RowData rowData_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table");

    private CountCheckRowSequence(RowSequence base, int ncol, long nrow) {
        this.base_ = base;
        this.ncol_ = ncol;
        this.nrow_ = nrow;
        this.rowData_ = this.base_;
        assert (this.nrow_ >= 0L);
    }

    @Override
    public boolean next() throws IOException {
        boolean hasNext = this.base_.next();
        if (this.irow_ < this.nrow_) {
            if (!hasNext && this.rowData_ == this.base_) {
                String msg = new StringBuffer().append("Missing rows at row #").append(this.irow_).append("/").append(this.nrow_).append(": adding ").append(this.nrow_ - this.irow_).append(" dummies").toString();
                logger_.warning(msg);
                this.rowData_ = new RowData(){

                    @Override
                    public Object getCell(int icol) {
                        return null;
                    }

                    @Override
                    public Object[] getRow() {
                        return new Object[CountCheckRowSequence.this.ncol_];
                    }
                };
            }
            ++this.irow_;
            return true;
        }
        if (hasNext && this.irow_ >= this.nrow_) {
            long nextra = 1L;
            try {
                while (this.base_.next()) {
                    ++nextra;
                }
            }
            catch (IOException e) {
                nextra = -1L;
            }
            String msg = new StringBuffer().append("Too many rows at row #").append(this.irow_).append("/").append(this.nrow_).append(": discarding").append(nextra >= 0L ? " " + nextra : "").append(" extras").toString();
            logger_.warning(msg);
        }
        return false;
    }

    @Override
    public Object getCell(int icol) throws IOException {
        return this.rowData_.getCell(icol);
    }

    @Override
    public Object[] getRow() throws IOException {
        return this.rowData_.getRow();
    }

    @Override
    public void close() throws IOException {
        this.base_.close();
    }

    public static RowSequence getSafeRowSequence(RowSequence rseq, int ncol, long nrow) {
        return nrow >= 0L ? new CountCheckRowSequence(rseq, ncol, nrow) : rseq;
    }
}

