/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;

public class HealpixTableInfo {
    private final int level_;
    private final boolean isNest_;
    private final String ipixColName_;
    private final HpxCoordSys csys_;
    public static final ValueInfo HPX_LEVEL_INFO = new DefaultValueInfo("STIL_HPX_LEVEL", Integer.class, "Level of HEALPix pixels contained in the table (nside=2^level)");
    public static final ValueInfo HPX_ISNEST_INFO = new DefaultValueInfo("STIL_HPX_ISNEST", Boolean.class, "True for NEST indexation scheme, False for RING");
    public static final ValueInfo HPX_COLNAME_INFO = new DefaultValueInfo("STIL_HPX_COLNAME", String.class, "Name of the table column containing HEALPix index; null value or empty string indicates implicit");
    public static final ValueInfo HPX_CSYS_INFO = new DefaultValueInfo("STIL_HPX_CSYS", String.class, "'C'=celestial/equatorial, 'G'=galactic, 'E'=ecliptic");
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table");

    public HealpixTableInfo(int level, boolean isNest, String ipixColName, HpxCoordSys csys) {
        this.level_ = level;
        this.isNest_ = isNest;
        this.ipixColName_ = ipixColName;
        this.csys_ = csys;
    }

    public int getLevel() {
        return this.level_;
    }

    public boolean isNest() {
        return this.isNest_;
    }

    public String getPixelColumnName() {
        return this.ipixColName_;
    }

    public HpxCoordSys getCoordSys() {
        return this.csys_;
    }

    public DescribedValue[] toParams() {
        ArrayList<DescribedValue> dvals = new ArrayList<DescribedValue>();
        dvals.add(new DescribedValue(HPX_LEVEL_INFO, this.level_));
        dvals.add(new DescribedValue(HPX_ISNEST_INFO, this.isNest_));
        dvals.add(new DescribedValue(HPX_COLNAME_INFO, this.ipixColName_));
        if (this.csys_ != null) {
            dvals.add(new DescribedValue(HPX_CSYS_INFO, this.csys_.getCharString()));
        }
        return dvals.toArray(new DescribedValue[0]);
    }

    public int hashCode() {
        int code = -3351;
        code = 23 * code + this.level_;
        code = 23 * code + (this.isNest_ ? 11 : 19);
        code = 23 * code + (this.ipixColName_ == null ? 0 : this.ipixColName_.hashCode());
        code = 23 * code + (this.csys_ == null ? 32 : (int)this.csys_.character_);
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof HealpixTableInfo) {
            HealpixTableInfo other = (HealpixTableInfo)o;
            return this.level_ == other.level_ && this.isNest_ == other.isNest_ && (this.ipixColName_ == null ? other.ipixColName_ == null : this.ipixColName_.equals(other.ipixColName_)) && (this.csys_ == null ? other.csys_ == null : this.csys_ == other.csys_);
        }
        return false;
    }

    public String toString() {
        return new StringBuffer().append("HEALPix(").append("level=").append(this.level_).append(",").append("order=").append(this.isNest_ ? "nest" : "ring").append(",").append("pixcol=").append(this.ipixColName_ == null ? "<implicit>" : this.ipixColName_).append(",").append("csys=").append(this.csys_ == null ? "null" : this.csys_.getCharString()).append(")").toString();
    }

    public static boolean isHealpix(List<DescribedValue> params) {
        for (DescribedValue param : params) {
            String pname = param.getInfo().getName();
            if (!pname.equals(HPX_LEVEL_INFO.getName()) && !pname.equals(HPX_ISNEST_INFO.getName()) && !pname.equals(HPX_COLNAME_INFO.getName()) && !pname.equals(HPX_CSYS_INFO.getName())) continue;
            return true;
        }
        return false;
    }

    public static HealpixTableInfo fromParams(List<DescribedValue> params) {
        int level = -1;
        Boolean isNest = null;
        String ipixColName = null;
        Character csysChar = null;
        for (DescribedValue dval : params) {
            ValueInfo info = dval.getInfo();
            String pname = info.getName();
            Object value = dval.getValue();
            if (pname.equals(HPX_LEVEL_INFO.getName())) {
                if (value instanceof Number) {
                    level = ((Number)value).intValue();
                } else {
                    logger_.warning("Wrong type for " + dval);
                }
            }
            if (pname.equals(HPX_COLNAME_INFO.getName())) {
                if (value == null) {
                    ipixColName = "";
                } else if (value instanceof String) {
                    ipixColName = (String)value;
                } else {
                    logger_.warning("Wrong type for " + dval);
                }
            }
            if (pname.equals(HPX_ISNEST_INFO.getName())) {
                if (value instanceof Boolean) {
                    isNest = (Boolean)value;
                } else {
                    logger_.warning("Wrong type for " + dval);
                }
            }
            if (!pname.equals(HPX_CSYS_INFO.getName())) continue;
            if (value instanceof Character) {
                csysChar = (Character)value;
                continue;
            }
            if (value instanceof String && ((String)value).length() == 1) {
                csysChar = Character.valueOf(((String)value).charAt(0));
                continue;
            }
            logger_.warning("Wrong type for " + dval);
        }
        if (ipixColName == null) {
            logger_.warning("Missing HEALPix index column name parameter " + HPX_COLNAME_INFO + " - assume implicit");
        } else if (ipixColName.length() == 0) {
            ipixColName = null;
        }
        if (isNest == null) {
            logger_.warning("Missing HEALPix ordering parameter " + HPX_ISNEST_INFO + " - assume NEST");
            isNest = Boolean.TRUE;
        }
        HpxCoordSys csys = null;
        if (csysChar != null && (csys = HpxCoordSys.fromCharacter(csysChar.charValue())) == null) {
            logger_.warning("Ignoring unknown HEALPix COORDSYS value '" + csysChar + "'");
        }
        return new HealpixTableInfo(level, isNest, ipixColName, csys);
    }

    public static enum HpxCoordSys {
        GALACTIC('G', "Galactic"),
        ECLIPTIC('E', "Ecliptic"),
        CELESTIAL('C', "Celestial/Equatorial");

        private final char character_;
        private final String word_;

        private HpxCoordSys(char character, String word) {
            this.character_ = character;
            this.word_ = word;
        }

        public String getCharString() {
            return new String(new char[]{this.character_});
        }

        public String getWord() {
            return this.word_;
        }

        public static HpxCoordSys fromCharacter(char c) {
            for (HpxCoordSys csys : HpxCoordSys.values()) {
                if (csys.character_ != c) continue;
                return csys;
            }
            return null;
        }
    }
}

