/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class JoinFixAction {
    private final String name_;
    public static final JoinFixAction NO_ACTION = new JoinFixAction("No Action"){

        @Override
        public String getFixedName(String orig, Collection<String> others) {
            return orig;
        }
    };

    protected JoinFixAction(String name) {
        this.name_ = name;
    }

    public abstract String getFixedName(String var1, Collection<String> var2);

    public String toString() {
        return this.name_;
    }

    public static boolean isDuplicate(String name, Collection<String> others, boolean caseSensitive) {
        if (caseSensitive) {
            return others.contains(name);
        }
        name = String.valueOf(name).toLowerCase();
        for (String other : others) {
            if (!String.valueOf(other).toLowerCase().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static String ensureUnique(String name, Collection<String> others, boolean caseSensitive) {
        if (!JoinFixAction.isDuplicate(name, others, caseSensitive)) {
            return name;
        }
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            String namex = name + JoinFixAction.toLetters(i);
            if (JoinFixAction.isDuplicate(namex, others, caseSensitive)) continue;
            return namex;
        }
        assert (false);
        return name;
    }

    static String toLetters(int index) {
        StringBuffer sbuf = new StringBuffer(Integer.toString(index, 26));
        for (int j = 0; j < sbuf.length(); ++j) {
            char c = sbuf.charAt(j);
            if (c >= '0' && c <= '9') {
                c = (char)(c - 48 + 97);
            } else if (c >= 'a' && c <= 'p') {
                c = (char)(c + 10);
            }
            assert (c >= 'a' && c <= 'z');
            sbuf.setCharAt(j, c);
        }
        return sbuf.toString();
    }

    public static JoinFixAction makeRenameDuplicatesAction(String appendage) {
        return JoinFixAction.makeRenameDuplicatesAction(appendage, false, true);
    }

    public static JoinFixAction makeRenameDuplicatesAction(final String appendage, final boolean caseSensitive, final boolean ensureUnique) {
        return new JoinFixAction("Fix Duplicates: " + appendage){

            @Override
            public String getFixedName(String orig, Collection<String> others) {
                if (2.isDuplicate(orig, others, caseSensitive)) {
                    String name = orig + appendage;
                    return ensureUnique ? 2.ensureUnique(name, others, caseSensitive) : name;
                }
                return orig;
            }
        };
    }

    public static JoinFixAction makeRenameAllAction(String appendage) {
        return JoinFixAction.makeRenameAllAction(appendage, false, true);
    }

    public static JoinFixAction makeRenameAllAction(final String appendage, final boolean caseSensitive, final boolean ensureUnique) {
        return new JoinFixAction("Rename All: " + appendage){

            @Override
            public String getFixedName(String orig, Collection<String> others) {
                String name = orig + appendage;
                return ensureUnique ? 3.ensureUnique(name, others, caseSensitive) : name;
            }
        };
    }

    public static JoinFixAction makeNumericDeduplicationAction(String delimiter, final boolean caseSensitive) {
        final String delim = delimiter == null ? "" : delimiter;
        String name = delim.length() == 0 ? "Numeric Renamer" : "Numeric Renamer: " + delim;
        final Pattern regex = Pattern.compile("(.*)\\Q" + delim + "\\E([0-9]+)");
        return new JoinFixAction(name){

            @Override
            public String getFixedName(String orig, Collection<String> others) {
                if (!4.isDuplicate(orig, others, caseSensitive)) {
                    return orig;
                }
                Matcher oMatch = regex.matcher(orig);
                String origStrip = oMatch.matches() ? oMatch.group(1) : orig;
                long maxNum = 0L;
                for (String other : others) {
                    Matcher matcher = regex.matcher(String.valueOf(other));
                    if (!matcher.matches()) continue;
                    String strip = matcher.group(1);
                    boolean same = caseSensitive ? strip.equals(origStrip) : strip.equalsIgnoreCase(origStrip);
                    if (!same) continue;
                    long num = Long.parseLong(matcher.group(2));
                    maxNum = Math.max(maxNum, num);
                }
                return origStrip + delim + (maxNum + 1L);
            }
        };
    }
}

