/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import uk.ac.starlink.table.RowSplittable;

public class ProgressRowSplittable
implements RowSplittable {
    private final RowSplittable base_;
    private final Tracker tracker_;
    private final int trackBlock_;
    private long itrack_;

    public ProgressRowSplittable(RowSplittable base, Target target) {
        this(base, new Tracker(target));
    }

    private ProgressRowSplittable(RowSplittable base, Tracker tracker) {
        this.base_ = base;
        this.tracker_ = tracker;
        this.trackBlock_ = 10000;
        this.tracker_.addWorker(this);
    }

    @Override
    public boolean next() throws IOException {
        if (this.base_.next()) {
            this.trackNext();
            return true;
        }
        return false;
    }

    @Override
    public ProgressRowSplittable split() {
        RowSplittable split0 = (RowSplittable)this.base_.split();
        return split0 == null ? null : new ProgressRowSplittable(split0, this.tracker_);
    }

    @Override
    public Object getCell(int icol) throws IOException {
        return this.base_.getCell(icol);
    }

    @Override
    public Object[] getRow() throws IOException {
        return this.base_.getRow();
    }

    @Override
    public LongSupplier rowIndex() {
        return this.base_.rowIndex();
    }

    @Override
    public long splittableSize() {
        return this.base_.splittableSize();
    }

    @Override
    public void close() throws IOException {
        if (this.itrack_ > 0L) {
            try {
                this.tracker_.addCount(this.itrack_);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.itrack_ = 0L;
        }
        this.tracker_.removeWorker(this);
        this.base_.close();
    }

    private void trackNext() throws IOException {
        if (++this.itrack_ >= (long)this.trackBlock_) {
            this.tracker_.addCount(this.itrack_);
            this.itrack_ = 0L;
            if (Thread.interrupted()) {
                throw new IOException("Sequence interrupted");
            }
        }
    }

    private static class Tracker {
        private final Target target_;
        private final Set<ProgressRowSplittable> workers_;
        private final AtomicLong count_;

        Tracker(Target target) {
            this.target_ = target;
            this.workers_ = new HashSet<ProgressRowSplittable>();
            this.count_ = new AtomicLong();
        }

        void addCount(long inc) throws IOException {
            this.target_.updateCount(this.count_.addAndGet(inc));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addWorker(ProgressRowSplittable worker) {
            Set<ProgressRowSplittable> set = this.workers_;
            synchronized (set) {
                this.workers_.add(worker);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeWorker(ProgressRowSplittable worker) {
            boolean isFinal;
            Set<ProgressRowSplittable> set = this.workers_;
            synchronized (set) {
                isFinal = this.workers_.remove(worker) && this.workers_.isEmpty();
            }
            if (isFinal) {
                this.target_.done(this.count_.longValue());
            }
        }
    }

    public static interface Target {
        public void updateCount(long var1) throws IOException;

        public void done(long var1);
    }
}

