/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.Arrays;
import uk.ac.starlink.table.AccessRowSequence;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.WrapperStarTable;

public class RowPermutedStarTable
extends WrapperStarTable {
    private long[] rowMap;

    public RowPermutedStarTable(StarTable baseTable, long[] rowMap) {
        super(baseTable);
        if (!baseTable.isRandom()) {
            throw new IllegalArgumentException("No random access in base table " + baseTable);
        }
        this.rowMap = rowMap;
    }

    public RowPermutedStarTable(StarTable baseTable) {
        this(baseTable, new long[Math.max(RowPermutedStarTable.checkedLongToInt(baseTable.getRowCount()), 0)]);
        int nrow = this.rowMap.length;
        for (int i = 0; i < nrow; ++i) {
            this.rowMap[i] = i;
        }
    }

    public long[] getRowMap() {
        return this.rowMap;
    }

    public void setRowMap(long[] rowMap) {
        this.rowMap = rowMap;
    }

    @Override
    public long getRowCount() {
        return this.rowMap.length;
    }

    @Override
    public boolean isRandom() {
        return true;
    }

    @Override
    public RowAccess getRowAccess() throws IOException {
        final RowAccess baseAcc = this.baseTable.getRowAccess();
        int ncol = this.baseTable.getColumnCount();
        final Object[] emptyRow = new Object[ncol];
        return new RowAccess(){
            private long baseIrow_ = -1L;

            @Override
            public void setRowIndex(long irow) throws IOException {
                this.baseIrow_ = RowPermutedStarTable.this.rowMap[WrapperStarTable.checkedLongToInt(irow)];
                baseAcc.setRowIndex(this.baseIrow_);
            }

            @Override
            public Object getCell(int icol) throws IOException {
                return this.baseIrow_ >= 0L ? baseAcc.getCell(icol) : null;
            }

            @Override
            public Object[] getRow() throws IOException {
                return this.baseIrow_ >= 0L ? baseAcc.getRow() : this.emptyRow();
            }

            @Override
            public void close() throws IOException {
                baseAcc.close();
            }

            private Object[] emptyRow() {
                Arrays.fill(emptyRow, null);
                return emptyRow;
            }
        };
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        return AccessRowSequence.createInstance(this);
    }

    @Override
    public RowSplittable getRowSplittable() throws IOException {
        return Tables.getDefaultRowSplittable(this);
    }

    @Override
    public Object getCell(long irow, int icol) throws IOException {
        long baseRow = this.rowMap[RowPermutedStarTable.checkedLongToInt(irow)];
        return baseRow >= 0L ? this.baseTable.getCell(baseRow, icol) : null;
    }

    @Override
    public Object[] getRow(long irow) throws IOException {
        long baseRow = this.rowMap[RowPermutedStarTable.checkedLongToInt(irow)];
        return baseRow >= 0L ? this.baseTable.getRow(baseRow) : new Object[this.baseTable.getColumnCount()];
    }
}

