/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.function.LongSupplier;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;

public class SequentialRowSplittable
implements RowSplittable {
    private final RowSequence rseq_;
    private final long nrow_;
    private long irow_;

    public SequentialRowSplittable(StarTable table) throws IOException {
        this(table.getRowSequence(), table.getRowCount());
    }

    public SequentialRowSplittable(RowSequence rseq) {
        this(rseq, -1L);
    }

    public SequentialRowSplittable(RowSequence rseq, long nrow) {
        this.rseq_ = rseq;
        this.nrow_ = nrow;
        this.irow_ = -1L;
    }

    @Override
    public long splittableSize() {
        return this.nrow_;
    }

    @Override
    public RowSplittable split() {
        return null;
    }

    @Override
    public boolean next() throws IOException {
        ++this.irow_;
        return this.rseq_.next();
    }

    @Override
    public LongSupplier rowIndex() {
        return () -> this.irow_;
    }

    @Override
    public Object getCell(int icol) throws IOException {
        return this.rseq_.getCell(icol);
    }

    @Override
    public Object[] getRow() throws IOException {
        return this.rseq_.getRow();
    }

    @Override
    public void close() throws IOException {
        this.rseq_.close();
    }
}

