/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.awt.datatransfer.Transferable;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.MultiStarTableWriter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableTransferable;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.StreamTableSink;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.formats.AsciiTableWriter;
import uk.ac.starlink.table.formats.CsvTableWriter;
import uk.ac.starlink.table.formats.HTMLTableWriter;
import uk.ac.starlink.table.formats.IpacTableWriter;
import uk.ac.starlink.table.formats.LatexTableWriter;
import uk.ac.starlink.table.formats.TextTableWriter;
import uk.ac.starlink.table.formats.TstTableWriter;
import uk.ac.starlink.table.jdbc.JDBCHandler;
import uk.ac.starlink.table.jdbc.WriteMode;
import uk.ac.starlink.util.BeanConfig;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.Loader;
import uk.ac.starlink.util.URLUtils;

public class StarTableOutput {
    private List<StarTableWriter> handlers_ = new ArrayList<StarTableWriter>();
    private JDBCHandler jdbcHandler_;
    private static String[] defaultHandlerClasses = new String[]{"uk.ac.starlink.votable.UnifiedFitsTableWriter", "uk.ac.starlink.votable.UnifiedFitsTableWriter$Col", "uk.ac.starlink.votable.VOTableWriter", "uk.ac.starlink.fits.HealpixFitsTableWriter", "uk.ac.starlink.ecsv.EcsvTableWriter", "uk.ac.starlink.parquet.ParquetTableWriter", TextTableWriter.class.getName(), AsciiTableWriter.class.getName(), CsvTableWriter.class.getName(), IpacTableWriter.class.getName(), HTMLTableWriter.class.getName(), LatexTableWriter.class.getName(), TstTableWriter.class.getName(), "uk.ac.starlink.feather.FeatherTableWriter", "uk.ac.starlink.mirage.MirageTableWriter"};
    private static Map<String, String> legacyHandlerMap_ = StarTableOutput.createLegacyHandlerMap();
    private static Logger logger = Logger.getLogger("uk.ac.starlink.table");
    private StarTableWriter voWriter_;
    public static final String AUTO_HANDLER = "(auto)";
    public static final String EXTRA_WRITERS_PROPERTY = "startable.writers";

    public StarTableOutput() {
        for (int i = 0; i < defaultHandlerClasses.length; ++i) {
            String className = defaultHandlerClasses[i];
            try {
                Class<?> clazz = Class.forName(className);
                StarTableWriter handler = (StarTableWriter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.handlers_.add(handler);
                logger.config("Handler " + handler.getFormatName() + " registered");
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.info(className + " not found - can't register");
                continue;
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Failed to register " + className, e);
            }
        }
        this.handlers_.addAll(Loader.getClassInstances(EXTRA_WRITERS_PROPERTY, StarTableWriter.class));
        this.voWriter_ = this.createTransferableWriter();
    }

    public List<StarTableWriter> getHandlers() {
        return this.handlers_;
    }

    public void setHandlers(StarTableWriter[] handlers) {
        this.handlers_ = new ArrayList<StarTableWriter>(Arrays.asList(handlers));
    }

    public void writeStarTable(StarTable startab, String location, String format) throws TableFormatException, IOException {
        if (location.startsWith("jdbc:")) {
            try {
                this.getJDBCHandler().createJDBCTable(startab, location, WriteMode.DROP_CREATE);
                return;
            }
            catch (SQLException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        this.getHandler(format, location).writeStarTable(startab, location, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStarTable(StarTable startab, OutputStream out, StarTableWriter handler) throws IOException {
        try {
            if (!(out instanceof BufferedOutputStream)) {
                out = new BufferedOutputStream(out);
            }
            handler.writeStarTable(startab, out);
            out.flush();
        }
        finally {
            out.close();
        }
    }

    public void writeStarTables(StarTable[] tables, String location, String format) throws TableFormatException, IOException {
        StarTableWriter handler = this.getHandler(format, location);
        if (handler instanceof MultiStarTableWriter) {
            ((MultiStarTableWriter)handler).writeStarTables(Tables.arrayTableSequence(tables), location, this);
        } else if (tables.length == 1) {
            handler.writeStarTable(tables[0], location, this);
        } else {
            throw new TableFormatException("Output handler " + handler.getFormatName() + " can't write multiple tables");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStarTables(StarTable[] tables, OutputStream out, MultiStarTableWriter handler) throws IOException {
        try {
            if (!(out instanceof BufferedOutputStream)) {
                out = new BufferedOutputStream(out);
            }
            handler.writeStarTables(Tables.arrayTableSequence(tables), out);
            out.flush();
        }
        finally {
            out.close();
        }
    }

    public TableSink createOutputSink(final OutputStream out, final StarTableWriter handler) {
        return new StreamTableSink(){

            @Override
            protected void scanTable(StarTable table) throws IOException {
                StarTableOutput.this.writeStarTable(table, out, handler);
            }
        };
    }

    public TableSink createOutputSink(final String location, final String format) {
        return new StreamTableSink(){

            @Override
            protected void scanTable(StarTable table) throws IOException {
                StarTableOutput.this.writeStarTable(table, location, format);
            }
        };
    }

    public OutputStream getOutputStream(String location) throws IOException {
        if (location.equals("-")) {
            PrintStream out = System.out;
            return new FilterOutputStream(out){

                @Override
                public void close() throws IOException {
                    this.out.flush();
                }
            };
        }
        try {
            URL url = URLUtils.newURL(location);
            URLConnection uconn = url.openConnection();
            uconn.setDoInput(false);
            uconn.setDoOutput(true);
            uconn.connect();
            return uconn.getOutputStream();
        }
        catch (MalformedURLException url) {
            File file = new File(location);
            if (file.exists()) {
                if (file.delete()) {
                    logger.info("Deleting file \"" + location + "\" prior to overwriting");
                } else {
                    logger.warning("Failed to delete \"" + location + "\" prior to overwriting");
                }
            }
            return new FileOutputStream(file);
        }
    }

    public StarTableWriter getHandler(String format) throws TableFormatException {
        StarTableWriter handler;
        boolean isDynamic;
        if (format.equals(AUTO_HANDLER)) {
            throw new TableFormatException(format + " does not name a specific output handler");
        }
        BeanConfig config = BeanConfig.parseSpec(format);
        String fname = config.getBaseText();
        boolean bl = isDynamic = config.getConfigText() != null;
        if (!isDynamic) {
            for (StarTableWriter handler2 : this.handlers_) {
                if (!handler2.getFormatName().toLowerCase().startsWith(format.toLowerCase())) continue;
                return handler2;
            }
        }
        if ((handler = this.createNamedHandler(fname)) == null) {
            handler = this.createLegacyHandler(fname);
        }
        if (handler != null) {
            try {
                config.configBean(handler);
            }
            catch (LoadException e) {
                throw new TableFormatException("Handler configuration failed: " + e, e);
            }
            return handler;
        }
        throw new TableFormatException("No handler for table format \"" + format + "\"");
    }

    private StarTableWriter createNamedHandler(String fname) throws TableFormatException {
        Class<?> clazz;
        for (StarTableWriter handler : this.handlers_) {
            StarTableWriter handler1;
            if (!handler.getFormatName().toLowerCase().equals(fname)) continue;
            Class<?> hclazz = handler.getClass();
            try {
                handler1 = (StarTableWriter)hclazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new TableFormatException("Can't instantiate class " + hclazz.getName());
            }
            if (handler1.getFormatName().equalsIgnoreCase(fname)) {
                return handler1;
            }
            return null;
        }
        try {
            clazz = Class.forName(fname);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        if (StarTableWriter.class.isAssignableFrom(clazz)) {
            Class<StarTableWriter> hclazz = clazz.asSubclass(StarTableWriter.class);
            try {
                return hclazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new TableFormatException("Can't instantiate class " + hclazz.getName());
            }
        }
        throw new TableFormatException("Class " + clazz.getName() + " does not implement StarTableWriter");
    }

    public StarTableWriter getHandler(String format, String location) throws TableFormatException {
        if (format != null && format.length() > 0 && !AUTO_HANDLER.equals(format)) {
            return this.getHandler(format);
        }
        for (StarTableWriter handler : this.handlers_) {
            if (!handler.looksLikeFile(location)) continue;
            return handler;
        }
        StringBuffer msg = new StringBuffer();
        msg.append("No handler specified for writing table.\n").append("Known formats: ");
        Iterator<String> it = this.getKnownFormats().iterator();
        while (it.hasNext()) {
            msg.append(it.next());
            if (!it.hasNext()) continue;
            msg.append(", ");
        }
        throw new TableFormatException(msg.toString());
    }

    public List<String> getKnownFormats() {
        ArrayList<String> kf = new ArrayList<String>();
        kf.add("jdbc");
        for (StarTableWriter handler : this.handlers_) {
            kf.add(handler.getFormatName());
        }
        return kf;
    }

    public JDBCHandler getJDBCHandler() {
        if (this.jdbcHandler_ == null) {
            this.jdbcHandler_ = new JDBCHandler();
        }
        return this.jdbcHandler_;
    }

    public void setJDBCHandler(JDBCHandler handler) {
        this.jdbcHandler_ = handler;
    }

    public Transferable transferStarTable(StarTable startab) {
        if (this.voWriter_ != null) {
            return new StarTableTransferable(this, startab);
        }
        return null;
    }

    StarTableWriter getTransferWriter() {
        return this.voWriter_;
    }

    private final StarTableWriter createTransferableWriter() {
        for (String fname : new String[]{"votable(format=BINARY2)", "votable"}) {
            try {
                return this.getHandler(fname);
            }
            catch (TableFormatException e) {
                logger.warning("No format " + fname + " for transferables");
            }
        }
        logger.warning("No table drag'n'drop available");
        return null;
    }

    private StarTableWriter createLegacyHandler(String name) throws TableFormatException {
        for (Map.Entry<String, String> entry : legacyHandlerMap_.entrySet()) {
            if (!entry.getKey().startsWith(name)) continue;
            String hspec = entry.getValue();
            logger.info("Mapping legacy output handler: " + name + " -> " + hspec);
            BeanConfig config = BeanConfig.parseSpec(hspec);
            String fname = config.getBaseText();
            StarTableWriter handler = this.createNamedHandler(fname);
            try {
                config.configBean(handler);
            }
            catch (LoadException e) {
                throw new TableFormatException("Error configuring known handler?", e);
            }
            return handler;
        }
        return null;
    }

    static Map<String, String> createLegacyHandlerMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("votable-tabledata", "votable(format=TABLEDATA)");
        map.put("votable-binary-inline", "votable(format=BINARY,inline=true)");
        map.put("votable-binary2-inline", "votable(format=BINARY2,inline=true)");
        map.put("votable-fits-href", "votable(format=FITS,inline=false)");
        map.put("votable-binary-href", "votable(format=BINARY,inline=false)");
        map.put("votable-binary2-href", "votable(format=BINARY2,inline=false)");
        map.put("votable-fits-inline", "votable(format=FITS,inline=true)");
        map.put("fits-plus", "fits");
        map.put("fits-basic", "fits(primary=basic)");
        map.put("fits-var", "fits(primary=basic,var=true)");
        map.put("colfits-plus", "fits(col=true)");
        map.put("colfits-basic", "fits(col=true,primary=basic)");
        map.put("ecsv-space", "ecsv(delimiter=space)");
        map.put("ecsv-comma", "ecsv(delimiter=comma)");
        map.put("csv-noheader", "csv(header=false)");
        map.put("html-element", "html(standalone=false)");
        map.put("latex-document", "latex(standalone=true)");
        return Collections.unmodifiableMap(map);
    }
}

