/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableCellRenderer;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.util.URLUtils;

public class URLValueInfo
implements ValueInfo {
    private String ucd_;
    private String utype_;
    private String name_;
    private String description_;
    private List<DescribedValue> auxData_;

    public URLValueInfo(String name, String description) {
        this.name_ = name;
        this.description_ = description;
        this.auxData_ = new ArrayList<DescribedValue>();
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    @Override
    public String getUnitString() {
        return null;
    }

    @Override
    public String getUCD() {
        return this.ucd_;
    }

    @Override
    public String getUtype() {
        return this.utype_;
    }

    @Override
    public String getXtype() {
        return null;
    }

    @Override
    public Class<?> getContentClass() {
        return URL.class;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public int[] getShape() {
        return null;
    }

    @Override
    public int getElementSize() {
        return -1;
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public DomainMapper[] getDomainMappers() {
        return new DomainMapper[0];
    }

    @Override
    public List<DescribedValue> getAuxData() {
        return this.auxData_;
    }

    @Override
    public String formatValue(Object value, int maxLength) {
        if (value == null) {
            return "";
        }
        String txt = value.toString();
        int leng = txt.length();
        return leng <= maxLength ? txt : txt.substring(0, maxLength);
    }

    @Override
    public Object unformatString(String rep) {
        try {
            return URLUtils.newURL(rep);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public TableCellRenderer getCellRenderer() {
        return null;
    }
}

