/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.formats.DocumentedTableBuilder;
import uk.ac.starlink.table.formats.IpacReader;
import uk.ac.starlink.util.DataSource;

public class IpacTableBuilder
extends DocumentedTableBuilder {
    public static final ValueInfo COMMENT_INFO = new DefaultValueInfo("Ipac_Comments", String.class, "IPAC format comment lines");

    public IpacTableBuilder() {
        super(new String[]{"tbl", "ipac"});
    }

    @Override
    public String getFormatName() {
        return "IPAC";
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void streamStarTable(InputStream istrm, TableSink sink, String pos) throws IOException {
        try (IpacReader reader = null;){
            reader = new IpacReader(istrm);
            sink.acceptMetadata(new IpacStarTable(reader){

                @Override
                public RowSequence getRowSequence() throws IOException {
                    throw new UnsupportedOperationException();
                }
            });
            while (reader.next()) {
                sink.acceptRow(reader.getRow());
            }
            sink.endRows();
        }
    }

    @Override
    public StarTable makeStarTable(final DataSource datsrc, boolean wantRandom, StoragePolicy storagePolicy) throws IOException {
        IpacReader reader = new IpacReader(new BufferedInputStream(datsrc.getInputStream()));
        reader.close();
        return new IpacStarTable(reader){

            @Override
            public RowSequence getRowSequence() throws IOException {
                return new IpacReader(new BufferedInputStream(datsrc.getInputStream()));
            }
        };
    }

    @Override
    public boolean canStream() {
        return true;
    }

    @Override
    public boolean docIncludesExample() {
        return true;
    }

    @Override
    public String getXmlDescription() {
        return this.readText("IpacTableBuilder.xml");
    }

    private static abstract class IpacStarTable
    extends AbstractStarTable {
        private final IpacReader reader_;

        IpacStarTable(IpacReader reader) {
            this.reader_ = reader;
            this.setParameters(new ArrayList<DescribedValue>(Arrays.asList(this.reader_.getParameters())));
        }

        @Override
        public int getColumnCount() {
            return this.reader_.getColumnCount();
        }

        @Override
        public ColumnInfo getColumnInfo(int icol) {
            return this.reader_.getColumnInfo(icol);
        }

        @Override
        public long getRowCount() {
            return -1L;
        }

        @Override
        public void close() throws IOException {
            this.reader_.close();
        }
    }
}

