/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.awt.datatransfer.DataFlavor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.formats.DocumentedTableBuilder;
import uk.ac.starlink.table.formats.RowEvaluator;
import uk.ac.starlink.util.ConfigMethod;

public abstract class RowEvaluatorTableBuilder
extends DocumentedTableBuilder {
    private int maxSample_;
    private RowEvaluator.Decoder<?>[] decoders_ = RowEvaluator.getStandardDecoders();

    protected RowEvaluatorTableBuilder(String[] extensions) {
        super(extensions);
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    @Override
    public void streamStarTable(InputStream in, TableSink sink, String pos) throws TableFormatException {
        throw new TableFormatException("Can't stream " + this.getFormatName() + " format tables");
    }

    @Override
    public boolean canStream() {
        return false;
    }

    @ConfigMethod(property="maxSample", doc="<p>Controls how many rows of the input file are sampled\nto determine column datatypes.\nThis file format provides no header information about\ncolumn type, so the handler has to look at the column data\nto see what type of value appears to be present\nin each column, before even starting to read the data in.\nBy default it goes through the whole table when doing this,\nwhich can be time-consuming for large tables.\nIf this value is set, it limits the number of rows\nthat are sampled in this data characterisation pass,\nwhich can reduce read time substantially.\nHowever, if values near the end of the table differ\nin apparent type from those near the start,\nit can also result in getting the datatypes wrong.\n</p>", usage="<int>", example="100000", sequence=10)
    public void setMaxSample(int maxSample) {
        this.maxSample_ = maxSample;
    }

    public int getMaxSample() {
        return this.maxSample_;
    }

    public void setDecoders(RowEvaluator.Decoder<?>[] decoders) {
        this.decoders_ = decoders;
    }

    public RowEvaluator.Decoder<?>[] getDecoders() {
        return this.decoders_;
    }

    @ConfigMethod(property="notypes", doc="<p>Specifies a semicolon-separated list of names for datatypes that will <em>not</em> appear in the columns of the table as read. Type names that can be excluded are <code>blank</code>, <code>boolean</code>, <code>short</code>, <code>int</code>, <code>long</code>, <code>float</code>, <code>double</code>, <code>date</code>, <code>hms</code> and <code>dms</code>. So if you want to make sure that all integer and floating-point columns are 64-bit (i.e. <code>long</code> and <code>double</code> respectively) you can set this value to \"<code>short;int;float</code>\".</p>", usage="<type>[;<type>...]", example="short;float", sequence=11)
    public void setDecoderExcludeList(String excludeSemicolonList) {
        LinkedHashMap decoderMap = new LinkedHashMap();
        for (RowEvaluator.Decoder<?> decoder : RowEvaluator.getStandardDecoders()) {
            decoderMap.put(decoder.getName(), decoder);
        }
        String optList = decoderMap.keySet().toString();
        ArrayList decoders = new ArrayList();
        for (String excludeName : excludeSemicolonList.split(";")) {
            if (decoderMap.remove(excludeName) != null) continue;
            String msg = "Unknown type name \"" + excludeName + "\"; options are " + optList;
            throw new IllegalArgumentException(msg);
        }
        this.setDecoders(decoderMap.values().toArray(new RowEvaluator.Decoder[0]));
    }
}

