/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.List;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ReaderRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.formats.RowEvaluator;
import uk.ac.starlink.util.DataSource;

public abstract class StreamStarTable
extends AbstractStarTable {
    private DataSource datsrc_;
    private int ncol_;
    private long nrow_;
    private RowEvaluator.Decoder<?>[] decoders_;
    private ColumnInfo[] colInfos_;
    protected static final char END = '\uffff';

    protected StreamStarTable() {
    }

    protected void init(DataSource datsrc) throws TableFormatException, IOException {
        if (this.datsrc_ != null) {
            throw new IllegalStateException("Already initialised");
        }
        this.datsrc_ = datsrc;
        this.setName(datsrc.getName());
        this.setURL(datsrc.getURL());
        RowEvaluator.Metadata meta = this.obtainMetadata();
        this.decoders_ = meta.decoders_;
        this.colInfos_ = meta.colInfos_;
        this.nrow_ = meta.nrow_;
        this.ncol_ = meta.ncol_;
    }

    @Override
    public int getColumnCount() {
        return this.ncol_;
    }

    @Override
    public long getRowCount() {
        return this.nrow_;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        final PushbackInputStream in = this.getInputStream();
        final int ncol = this.getColumnCount();
        return new ReaderRowSequence(){

            @Override
            protected Object[] readRow() throws IOException {
                List<String> cellList = StreamStarTable.this.readRow(in);
                if (cellList == null) {
                    in.close();
                    return null;
                }
                Object[] row = new Object[ncol];
                for (int icol = 0; icol < ncol; ++icol) {
                    String sval = cellList.get(icol);
                    if (sval == null || sval.trim().length() <= 0) continue;
                    row[icol] = StreamStarTable.this.decoders_[icol].decode(sval);
                }
                return row;
            }

            @Override
            public void close() throws IOException {
                in.close();
            }
        };
    }

    protected PushbackInputStream getInputStream() throws IOException {
        return new PushbackInputStream(new BufferedInputStream(this.datsrc_.getInputStream()));
    }

    protected abstract RowEvaluator.Metadata obtainMetadata() throws TableFormatException, IOException;

    protected abstract List<String> readRow(PushbackInputStream var1) throws TableFormatException, IOException;
}

