/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class MultilineJTable
extends JTable {
    private TableModel baseModel_;
    private MultilineTableModel multiModel_;
    private Border firstBorder_;
    private Border otherBorder_;

    public MultilineJTable(TableModel baseModel) {
        this();
        this.setModel(baseModel);
    }

    public MultilineJTable() {
        this.setModel(this.getModel());
        this.setGridColor(UIManager.getColor("Table.gridColor"));
    }

    @Override
    public void setModel(TableModel baseModel) {
        this.baseModel_ = baseModel;
        this.multiModel_ = new CachingMultilineTableModel(baseModel);
        super.setModel(this.multiModel_);
    }

    @Override
    public TableModel getModel() {
        return super.getModel();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer rend, int row, int col) {
        JComponent cell = (JComponent)super.prepareRenderer(rend, row, col);
        boolean isFirst = this.multiModel_.isFirstRowOfGroup(row);
        cell.setBorder(isFirst ? this.firstBorder_ : this.otherBorder_);
        return cell;
    }

    @Override
    public void setGridColor(Color gridColor) {
        this.firstBorder_ = BorderFactory.createMatteBorder(1, 0, 0, 1, gridColor);
        this.otherBorder_ = BorderFactory.createMatteBorder(0, 0, 0, 1, gridColor);
    }

    private static class CachingMultilineTableModel
    extends MultilineTableModel {
        private static Object BLANK = new Object();
        private final List<ArrayList<Object>> cellValues_;

        public CachingMultilineTableModel(TableModel baseModel) {
            super(baseModel);
            int ncol = this.getColumnCount();
            this.cellValues_ = new ArrayList<ArrayList<Object>>();
            for (int i = 0; i < ncol; ++i) {
                this.cellValues_.add(new ArrayList(16));
            }
        }

        @Override
        public Object getValueAt(int irow, int icol) {
            ArrayList<Object> colValues = this.cellValues_.get(icol);
            if (colValues.size() <= irow) {
                colValues.ensureCapacity((int)((double)irow * 1.5));
            }
            while (colValues.size() <= irow) {
                colValues.add(BLANK);
            }
            if (colValues.get(irow) == BLANK) {
                colValues.set(irow, super.getValueAt(irow, icol));
            }
            return colValues.get(irow);
        }
    }

    private static class MultilineTableModel
    extends AbstractTableModel {
        private int ncol;
        private int multiNrow;
        private int[] firstMultiRowOfBaseRow;
        private int[] baseRowOfMultiRow;
        private TableModel baseModel_;

        public MultilineTableModel(TableModel baseModel) {
            int i;
            this.baseModel_ = baseModel;
            int baseNrow = baseModel.getRowCount();
            this.ncol = baseModel.getColumnCount();
            this.firstMultiRowOfBaseRow = new int[baseNrow + 1];
            this.multiNrow = 0;
            for (i = 0; i < baseNrow; ++i) {
                this.firstMultiRowOfBaseRow[i] = this.multiNrow;
                int nlines = 1;
                for (int j = 0; j < this.ncol; ++j) {
                    Object val = baseModel.getValueAt(i, j);
                    Object[] lines = this.getLines(val);
                    if (lines == null || lines.length <= nlines) continue;
                    nlines = lines.length;
                }
                this.multiNrow += nlines;
            }
            this.firstMultiRowOfBaseRow[baseNrow] = this.multiNrow;
            this.baseRowOfMultiRow = new int[this.multiNrow];
            for (i = 0; i < baseNrow; ++i) {
                for (int j = this.firstMultiRowOfBaseRow[i]; j < this.firstMultiRowOfBaseRow[i + 1]; ++j) {
                    this.baseRowOfMultiRow[j] = i;
                }
            }
        }

        public boolean isFirstRowOfGroup(int multiRow) {
            return this.firstMultiRowOfBaseRow[this.baseRowOfMultiRow[multiRow]] == multiRow;
        }

        @Override
        public int getRowCount() {
            return this.multiNrow;
        }

        @Override
        public int getColumnCount() {
            return this.ncol;
        }

        @Override
        public Object getValueAt(int multiRow, int col) {
            boolean singleRowGroup;
            int baseRow = this.baseRowOfMultiRow[multiRow];
            Object baseValue = this.baseModel_.getValueAt(baseRow, col);
            boolean bl = singleRowGroup = this.firstMultiRowOfBaseRow[baseRow + 1] == this.firstMultiRowOfBaseRow[baseRow] + 1;
            if (singleRowGroup) {
                Object val = baseValue;
                if (val != null && val.getClass().getComponentType() != null && Array.getLength(val) == 1) {
                    val = Array.get(val, 0);
                }
                return val;
            }
            int index = multiRow - this.firstMultiRowOfBaseRow[baseRow];
            return this.getLineFromGroup(index, baseValue);
        }

        private Object getLineFromGroup(int index, Object val) {
            Object[] lines = this.getLines(val);
            if (lines == null) {
                return index == 0 ? val : null;
            }
            return index < lines.length ? lines[index] : null;
        }

        private Object[] getLines(Object val) {
            if (val instanceof String[]) {
                return (Object[])val;
            }
            if (val instanceof String) {
                return ((String)val).trim().split("\n");
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int colIndex) {
            return this.baseModel_.getColumnClass(colIndex);
        }

        @Override
        public String getColumnName(int colIndex) {
            return this.baseModel_.getColumnName(colIndex);
        }
    }
}

