/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.gui.SQLPanel;
import uk.ac.starlink.table.gui.SaveWorker;
import uk.ac.starlink.table.gui.TableSaveDialog;
import uk.ac.starlink.table.jdbc.JDBCFormatter;
import uk.ac.starlink.table.jdbc.WriteMode;

public class SQLWriteDialog
extends JPanel
implements TableSaveDialog {
    private SQLPanel sqlPanel_ = new SQLPanel("Write New SQL Table", false);
    private JDialog dialog_;
    private JComboBox<WriteMode> modeSelector_;
    private static Icon icon_;

    public SQLWriteDialog() {
        super(new BorderLayout());
        this.add((Component)this.sqlPanel_, "Center");
        this.modeSelector_ = new JComboBox<WriteMode>(WriteMode.getAllModes());
        this.modeSelector_.setSelectedItem(WriteMode.CREATE);
        this.sqlPanel_.getStack().addLine("Write Mode", null, this.modeSelector_);
    }

    @Override
    public String getName() {
        return "SQL Table";
    }

    @Override
    public String getDescription() {
        return "Write table as a new table in an SQL relational database";
    }

    @Override
    public Icon getIcon() {
        if (icon_ == null) {
            icon_ = new ImageIcon(this.getClass().getResource("sqlread.png"));
        }
        return icon_;
    }

    @Override
    public boolean isAvailable() {
        return this.sqlPanel_.isAvailable();
    }

    @Override
    public boolean showSaveDialog(Component parent, StarTableOutput sto, ComboBoxModel<String> formatModel, StarTable[] tables) {
        if (tables.length != 1) {
            String[] msg = new String[]{"It is only possible to write one table at a time to SQL;", "you are trying to save " + tables.length + " tables."};
            JOptionPane.showMessageDialog(parent, msg, "Save Error", 0);
            return false;
        }
        this.sqlPanel_.useAuthenticator(sto.getJDBCHandler().getAuthenticator());
        JOptionPane optPane = new JOptionPane(this.sqlPanel_, 3, 2);
        JDialog dialog = optPane.createDialog(parent, "Write New SQL Table");
        final boolean[] done = new boolean[1];
        while (!done[0]) {
            dialog.setVisible(true);
            if (optPane.getValue() instanceof Integer && (Integer)optPane.getValue() == 0) {
                SaveWorker worker = new SaveWorker(parent, tables, this.sqlPanel_.getRef()){

                    @Override
                    public void attemptSave(StarTable[] tables) throws IOException {
                        assert (tables.length == 1);
                        StarTable table = tables[0];
                        WriteMode mode = (WriteMode)SQLWriteDialog.this.modeSelector_.getItemAt(SQLWriteDialog.this.modeSelector_.getSelectedIndex());
                        Connection conn = null;
                        try {
                            conn = SQLWriteDialog.this.sqlPanel_.getConnector().getConnection();
                            new JDBCFormatter(conn, table).createJDBCTable(SQLWriteDialog.this.sqlPanel_.getRef(), mode);
                        }
                        catch (SQLException e) {
                            throw (IOException)new IOException(e.getMessage()).initCause(e);
                        }
                        finally {
                            if (conn != null) {
                                try {
                                    conn.close();
                                }
                                catch (SQLException sQLException) {}
                            }
                        }
                    }

                    @Override
                    public void done(boolean success) {
                        done[0] = success;
                    }
                };
                this.setEnabled(false);
                worker.invoke();
                this.setEnabled(true);
                continue;
            }
            return false;
        }
        return true;
    }
}

