/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.gui.TableLoadClient;

public abstract class TableLoadTransferHandler
extends TransferHandler {
    private final StarTableFactory tfact_;

    public TableLoadTransferHandler(StarTableFactory tfact) {
        this.tfact_ = tfact;
    }

    protected abstract TableLoadClient getLoadClient();

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavors) {
        return this.tfact_.canImport(flavors);
    }

    @Override
    public boolean importData(JComponent comp, Transferable trans) {
        StarTable table;
        TableLoadClient client = this.getLoadClient();
        client.startSequence();
        client.setLabel("Dropped Table");
        try {
            table = this.tfact_.makeStarTable(trans);
        }
        catch (Throwable error) {
            client.loadFailure(error);
            client.endSequence(false);
            return false;
        }
        assert (table != null);
        client.loadSuccess(table);
        client.endSequence(true);
        return true;
    }

    @Override
    public int getSourceActions(JComponent comp) {
        return 0;
    }
}

