/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.starlink.table.UCD;

public class UCDSelector
extends JPanel
implements ItemListener {
    private JComboBox<String> comboBox;
    private JLabel descriptionLabel = new JLabel();

    public UCDSelector() {
        this.comboBox = new JComboBox();
        this.comboBox.setEditable(true);
        this.comboBox.addItem(null);
        Iterator<UCD> it = UCD.getUCDs();
        while (it.hasNext()) {
            this.comboBox.addItem(it.next().getID());
        }
        this.comboBox.addItemListener(this);
        this.comboBox.setSelectedItem("");
        this.comboBox.setSelectedItem(null);
        this.setLayout(new BoxLayout(this, 1));
        this.comboBox.setAlignmentX(2.0f);
        this.descriptionLabel.setAlignmentX(2.0f);
        this.add(this.comboBox);
        this.add(this.descriptionLabel);
    }

    public String getID() {
        return (String)this.comboBox.getSelectedItem();
    }

    public void setID(String id) {
        this.comboBox.setSelectedItem(id);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() != this.comboBox) {
            return;
        }
        String desc = "no UCD";
        String id = this.getID();
        if (id != null && id.trim().length() > 0) {
            UCD ucd = UCD.getUCD(id);
            desc = ucd != null ? ucd.getDescription() : "unknown UCD";
        }
        this.descriptionLabel.setText(desc);
    }
}

