/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.jdbc;

import java.io.IOException;
import uk.ac.starlink.table.Documented;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableScheme;

public class JDBCTableScheme
implements TableScheme,
Documented {
    private final StarTableFactory tfact_;
    private final boolean wantRandom_;

    public JDBCTableScheme(StarTableFactory tfact) {
        this.tfact_ = tfact;
        this.wantRandom_ = false;
    }

    @Override
    public String getSchemeName() {
        return "jdbc";
    }

    @Override
    public String getSchemeUsage() {
        return "<jdbc-part>";
    }

    @Override
    public String getExampleSpecification() {
        return null;
    }

    @Override
    public String getXmlDescription() {
        String exampleUrl = "jdbc:mysql://localhost/dbl#SELECT TOP 10 ra, dec FROM gsc";
        return String.join((CharSequence)"\n", "<p>Interacts with the JDBC system", "(JDBC sort-of stands for Java DataBase Connectivity)", "to execute an SQL query on a connected database.", "The <code>jdbc:...</code> specification is the JDBC URL.", "For historical compatibility reasons,", "specifications of this scheme", "may omit the leading colon character,", "so that the following are both legal, and are equivalent:", "<pre>", "   " + exampleUrl, "   :" + exampleUrl, "</pre>", "</p>", "<p>In order for this to work, you must have access to", "a suitable database with a JDBC driver,", "and some standard JDBC configuration", "is required to set the driver up.", "The following steps are necessary:", "<ol>", "<li>the driver class must be available on the runtime classpath", "    </li>", "<li>the <code>jdbc.drivers</code> system property must be set", "    to the driver classname", "    </li>", "</ol>", "</p>", "<p>More detailed information about how to set up the JDBC system", "to connect with an available database,", "and of how to construct JDBC URLs,", "is provided elsewhere in the documentation.", "</p>", "");
    }

    @Override
    public StarTable createTable(String spec) throws IOException {
        String jdbcUrl = "jdbc:" + spec;
        return this.tfact_.getJDBCHandler().makeStarTable(jdbcUrl, this.wantRandom_);
    }
}

