/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.jdbc;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.jdbc.TypeMapper;
import uk.ac.starlink.table.jdbc.ValueHandler;

public class TypeMappers {
    public static final TypeMapper STANDARD = new StandardTypeMapper(' ');
    public static final TypeMapper DALI = new StandardTypeMapper('T');
    public static final TypeMapper IDENTITY = new IdentityTypeMapper();
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.jdbc");
    private static final ValueInfo JDBC_CLAZZ_INFO = new DefaultValueInfo("JDBC_class", String.class, "Class returned by JDBC database driver");
    private static final ValueInfo JDBC_TYPE_INFO = new DefaultValueInfo("JDBC_type", String.class, "SQL type of column in database");
    private static final ValueInfo JDBC_LABEL_INFO = new DefaultValueInfo("JDBC_label", String.class, "Label of column in JDBC database");
    private static final Pattern DATE_REGEX = Pattern.compile("([0-9]{4}-[01][0-9]-[0-3][0-9]) (.+)");

    private TypeMappers() {
    }

    public static ValueHandler createIdentityValueHandler(ResultSetMetaData meta, int jcol1) throws SQLException {
        return new IdentityValueHandler(meta, jcol1);
    }

    public static ValueHandler createStringValueHandler(ResultSetMetaData meta, int jcol1) throws SQLException {
        return new StringValueHandler(meta, jcol1);
    }

    public static ValueHandler createTimestampValueHandler(ResultSetMetaData meta, int jcol1, char dateTimeSeparator) throws SQLException {
        return dateTimeSeparator == ' ' ? new StringValueHandler(meta, jcol1) : new DoctoredTimestampValueHandler(meta, jcol1, dateTimeSeparator);
    }

    public static <T> ValueHandler createArrayValueHandler(ResultSetMetaData meta, int jcol1, Class<T> arrayClazz) throws SQLException {
        return new ArrayValueHandler<T>(meta, jcol1, arrayClazz);
    }

    public static Class<?> getArrayClass(ResultSetMetaData meta, int jcol1) {
        String tName;
        try {
            tName = meta.getColumnTypeName(jcol1);
        }
        catch (SQLException e) {
            return null;
        }
        if (tName == null || tName.trim().length() == 0) {
            return null;
        }
        String tname = tName.replaceFirst("\\(.*", "").trim().toLowerCase();
        if (tname.indexOf("float4") >= 0 || tname.startsWith("binary_float")) {
            return float[].class;
        }
        if (tname.indexOf("float8") >= 0 || tname.indexOf("double") >= 0 || tname.indexOf("real") >= 0 || tname.indexOf("float") >= 0) {
            return double[].class;
        }
        if (tname.equals("int8") || tname.equals("long") || tname.startsWith("bigint")) {
            return long[].class;
        }
        if (tname.equals("int2") || tname.equals("smallint") || tname.equals("tinyint")) {
            return short[].class;
        }
        if (tname.equals("int4") || tname.equals("int") || tname.equals("integer")) {
            return int[].class;
        }
        if (tname.startsWith("bool")) {
            return boolean[].class;
        }
        if (tname.startsWith("char") || tname.startsWith("varchar")) {
            return String[].class;
        }
        return null;
    }

    private static class StandardTypeMapper
    implements TypeMapper {
        private final char dateTimeSeparator_;

        public StandardTypeMapper(char dateTimeSeparator) {
            this.dateTimeSeparator_ = dateTimeSeparator;
        }

        @Override
        public ValueHandler createValueHandler(ResultSetMetaData meta, int jcol1) throws SQLException {
            ValueHandler handler = TypeMappers.createIdentityValueHandler(meta, jcol1);
            Class<?> clazz = handler.getColumnInfo().getContentClass();
            if (Timestamp.class.isAssignableFrom(clazz)) {
                logger_.info("JDBC table handler casting Date column " + meta.getColumnName(jcol1) + " to String");
                return TypeMappers.createTimestampValueHandler(meta, jcol1, this.dateTimeSeparator_);
            }
            if (Date.class.isAssignableFrom(clazz) || Time.class.isAssignableFrom(clazz)) {
                return TypeMappers.createStringValueHandler(meta, jcol1);
            }
            if (BigInteger.class.isAssignableFrom(clazz)) {
                logger_.info("JDBC table handler casting BigInteger column " + meta.getColumnName(jcol1) + " to Long");
                final BigInteger minLong = BigInteger.valueOf(Long.MIN_VALUE);
                final BigInteger maxLong = BigInteger.valueOf(Long.MAX_VALUE);
                return new ForcedValueHandler<Long>(meta, jcol1, Long.class){

                    @Override
                    public Long getValue(Object baseValue) {
                        if (baseValue instanceof BigInteger) {
                            BigInteger biv = (BigInteger)baseValue;
                            if (biv.compareTo(minLong) >= 0 && biv.compareTo(maxLong) <= 0) {
                                long lv = biv.longValue();
                                assert (biv.equals(BigInteger.valueOf(lv)));
                                return lv;
                            }
                            return null;
                        }
                        return null;
                    }
                };
            }
            if (BigDecimal.class.isAssignableFrom(clazz)) {
                logger_.info("JDBC table handler casting BigDecimal column " + meta.getColumnName(jcol1) + " to Double");
                return new ForcedValueHandler<Double>(meta, jcol1, Double.class){

                    @Override
                    public Double getValue(Object baseValue) {
                        return baseValue instanceof Number ? Double.valueOf(((Number)baseValue).doubleValue()) : null;
                    }
                };
            }
            if (clazz.equals(java.sql.Array.class)) {
                Level level;
                Class<Object> arrayClazz = TypeMappers.getArrayClass(meta, jcol1);
                String msg = "Best guess for array column '" + meta.getColumnName(jcol1) + "' type: ";
                if (arrayClazz == null) {
                    arrayClazz = double[].class;
                    msg = msg + "?? (using " + arrayClazz.getSimpleName() + ")";
                    level = Level.WARNING;
                } else {
                    msg = msg + arrayClazz.getSimpleName();
                    level = Level.CONFIG;
                }
                logger_.log(level, msg);
                return TypeMappers.createArrayValueHandler(meta, jcol1, arrayClazz);
            }
            if (clazz.equals(char[].class)) {
                logger_.info("JDBC table handler casting char[] column " + meta.getColumnName(jcol1) + " to String");
                return new StringValueHandler(meta, jcol1){

                    @Override
                    public String getValue(Object baseValue) {
                        return baseValue instanceof char[] ? new String((char[])baseValue) : null;
                    }
                };
            }
            return handler;
        }

        @Override
        public List<ValueInfo> getColumnAuxDataInfos() {
            return Collections.unmodifiableList(Arrays.asList(JDBC_LABEL_INFO, JDBC_TYPE_INFO, JDBC_CLAZZ_INFO));
        }
    }

    private static class IdentityTypeMapper
    implements TypeMapper {
        private IdentityTypeMapper() {
        }

        @Override
        public ValueHandler createValueHandler(ResultSetMetaData meta, int jcol1) throws SQLException {
            return TypeMappers.createIdentityValueHandler(meta, jcol1);
        }

        @Override
        public List<ValueInfo> getColumnAuxDataInfos() {
            return Collections.unmodifiableList(Arrays.asList(JDBC_LABEL_INFO));
        }
    }

    private static class DoctoredTimestampValueHandler
    extends ForcedValueHandler<String> {
        private final char separator_;

        DoctoredTimestampValueHandler(ResultSetMetaData meta, int jcol1, char dateTimeSeparator) throws SQLException {
            super(meta, jcol1, String.class);
            this.separator_ = dateTimeSeparator;
        }

        @Override
        public String getValue(Object baseValue) {
            if (baseValue == null) {
                return null;
            }
            String isoTxt = baseValue.toString();
            Matcher matcher = DATE_REGEX.matcher(isoTxt);
            if (matcher.matches()) {
                return new StringBuffer().append(matcher.group(1)).append(this.separator_).append(matcher.group(2)).toString();
            }
            return isoTxt;
        }
    }

    private static class ArrayValueHandler<T>
    extends ForcedValueHandler<T> {
        private final Class<T> arrayClazz_;
        private final Class<?> elClazz_;
        private boolean hasComplained_;

        ArrayValueHandler(ResultSetMetaData meta, int jcol1, Class<T> arrayClazz) throws SQLException {
            super(meta, jcol1, arrayClazz);
            this.arrayClazz_ = arrayClazz;
            this.elClazz_ = this.arrayClazz_.getComponentType();
        }

        @Override
        public T getValue(Object baseValue) {
            T outArray;
            block8: {
                Object dataArray;
                if (!(baseValue instanceof java.sql.Array)) {
                    return null;
                }
                java.sql.Array jdbcArray = (java.sql.Array)baseValue;
                try {
                    dataArray = jdbcArray.getArray();
                }
                catch (SQLException e) {
                    return null;
                }
                if (this.arrayClazz_.isInstance(dataArray)) {
                    return this.arrayClazz_.cast(dataArray);
                }
                if (dataArray == null || dataArray.getClass().getComponentType() == null) {
                    return null;
                }
                int leng = Array.getLength(dataArray);
                outArray = this.arrayClazz_.cast(Array.newInstance(this.elClazz_, leng));
                try {
                    for (int i = 0; i < leng; ++i) {
                        Array.set(outArray, i, Array.get(dataArray, i));
                    }
                }
                catch (IllegalArgumentException e) {
                    if (this.hasComplained_) break block8;
                    logger_.warning("Failed array conversion: " + dataArray.getClass().getSimpleName() + " -> " + this.arrayClazz_.getSimpleName());
                    this.hasComplained_ = true;
                }
            }
            return outArray;
        }
    }

    private static class StringValueHandler
    extends ForcedValueHandler<String> {
        StringValueHandler(ResultSetMetaData meta, int jcol1) throws SQLException {
            super(meta, jcol1, String.class);
        }

        @Override
        public String getValue(Object baseValue) {
            return baseValue == null ? null : baseValue.toString();
        }
    }

    private static abstract class ForcedValueHandler<T>
    implements ValueHandler {
        private final ColumnInfo colInfo_;

        ForcedValueHandler(ResultSetMetaData meta, int jcol1, Class<T> forcedClass) throws SQLException {
            String label;
            String name = meta.getColumnName(jcol1);
            this.colInfo_ = new ColumnInfo(name);
            if (meta.isNullable(jcol1) == 0) {
                this.colInfo_.setNullable(false);
            }
            if ((label = meta.getColumnLabel(jcol1)) != null && label.trim().length() > 0 && !label.equalsIgnoreCase(name)) {
                this.colInfo_.setAuxDatum(new DescribedValue(JDBC_LABEL_INFO, label.trim()));
            }
            String origClass = meta.getColumnClassName(jcol1);
            String origType = meta.getColumnTypeName(jcol1);
            if (origClass != null && origClass.trim().length() > 0) {
                this.colInfo_.setAuxDatum(new DescribedValue(JDBC_CLAZZ_INFO, origClass));
            }
            if (origType != null && origType.trim().length() > 0) {
                this.colInfo_.setAuxDatum(new DescribedValue(JDBC_TYPE_INFO, origType));
            }
            this.colInfo_.setContentClass(forcedClass);
        }

        @Override
        public ColumnInfo getColumnInfo() {
            return this.colInfo_;
        }

        public abstract T getValue(Object var1);
    }

    private static class IdentityValueHandler
    implements ValueHandler {
        final ColumnInfo colInfo_;

        IdentityValueHandler(ResultSetMetaData meta, int jcol1) throws SQLException {
            String label;
            String name = meta.getColumnName(jcol1);
            this.colInfo_ = new ColumnInfo(name);
            String className = meta.getColumnClassName(jcol1);
            if (className != null) {
                try {
                    Class<?> clazz = Class.forName(className);
                    this.colInfo_.setContentClass(clazz);
                }
                catch (ClassNotFoundException e) {
                    logger_.warning("Cannot determine class " + className + " for column " + name);
                    this.colInfo_.setContentClass(Object.class);
                }
            } else {
                logger_.warning("No column class given for column " + name);
                this.colInfo_.setContentClass(Object.class);
            }
            if (meta.isNullable(jcol1) == 0) {
                this.colInfo_.setNullable(false);
            }
            if ((label = meta.getColumnLabel(jcol1)) != null && label.trim().length() > 0 && !label.equalsIgnoreCase(name)) {
                this.colInfo_.setAuxDatum(new DescribedValue(JDBC_LABEL_INFO, label.trim()));
            }
        }

        @Override
        public ColumnInfo getColumnInfo() {
            return this.colInfo_;
        }

        @Override
        public Object getValue(Object baseValue) {
            return baseValue;
        }
    }
}

