/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.IOException;
import uk.ac.starlink.table.storage.ByteStoreAccess;
import uk.ac.starlink.table.storage.Codec;
import uk.ac.starlink.table.storage.ColumnReader;

abstract class ByteStoreColumnReader
implements ColumnReader {
    private final Codec codec_;
    private final ByteStoreAccess access_;
    private final long nrow_;

    public ByteStoreColumnReader(Codec codec, ByteStoreAccess access, long nrow) {
        this.codec_ = codec;
        this.access_ = access;
        this.nrow_ = nrow;
    }

    public abstract long getAccessOffset(long var1) throws IOException;

    @Override
    public long getRowCount() {
        return this.nrow_;
    }

    @Override
    public Object getObjectValue(long ix) throws IOException {
        this.seek(ix);
        return this.codec_.decodeObject(this.access_);
    }

    @Override
    public double getDoubleValue(long ix) throws IOException {
        this.seek(ix);
        return this.codec_.decodeDouble(this.access_);
    }

    @Override
    public int getIntValue(long ix) throws IOException {
        this.seek(ix);
        return this.codec_.decodeInt(this.access_);
    }

    @Override
    public long getLongValue(long ix) throws IOException {
        this.seek(ix);
        return this.codec_.decodeLong(this.access_);
    }

    @Override
    public boolean getBooleanValue(long ix) throws IOException {
        this.seek(ix);
        return this.codec_.decodeBoolean(this.access_);
    }

    private void seek(long ioff) throws IOException {
        this.access_.seek(this.getAccessOffset(ioff));
    }
}

