/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.logging.Logger;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.storage.ByteStoreAccess;

public abstract class Codec {
    private volatile int warnings_;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.table.storage");
    public static final Codec BYTE = new ByteCodec();
    public static final Codec SHORT = new ShortCodec();
    public static final Codec INT = new IntCodec();
    public static final Codec LONG = new LongCodec();
    public static final Codec FLOAT = new FloatCodec();
    public static final Codec DOUBLE = new DoubleCodec();
    public static final Codec CHAR = new CharCodec();
    public static final Codec BOOLEAN = new BooleanCodec();
    public static final Codec BYTE_ARRAY = new VariableArrayCodec(new ByteCodec1());
    public static final Codec SHORT_ARRAY = new VariableArrayCodec(new ShortCodec1());
    public static final Codec INT_ARRAY = new VariableArrayCodec(new IntCodec1());
    public static final Codec LONG_ARRAY = new VariableArrayCodec(new LongCodec1());
    public static final Codec FLOAT_ARRAY = new VariableArrayCodec(new FloatCodec1());
    public static final Codec DOUBLE_ARRAY = new VariableArrayCodec(new DoubleCodec1());
    public static final Codec STRING = new VariableStringCodec();

    public abstract int encode(Object var1, DataOutput var2) throws IOException;

    public abstract Object decodeObject(ByteStoreAccess var1) throws IOException;

    public abstract int decodeInt(ByteStoreAccess var1) throws IOException;

    public abstract long decodeLong(ByteStoreAccess var1) throws IOException;

    public abstract double decodeDouble(ByteStoreAccess var1) throws IOException;

    public abstract boolean decodeBoolean(ByteStoreAccess var1) throws IOException;

    public abstract int getItemSize();

    public static Codec getCodec(ValueInfo info) {
        Class<?> clazz = info.getContentClass();
        if (clazz == Byte.class) {
            return new FlaggedCodec(BYTE);
        }
        if (clazz == Short.class) {
            return new FlaggedCodec(SHORT);
        }
        if (clazz == Integer.class) {
            return new FlaggedCodec(INT);
        }
        if (clazz == Long.class) {
            return new FlaggedCodec(LONG);
        }
        if (clazz == Character.class) {
            return new FlaggedCodec(CHAR);
        }
        if (clazz == Float.class) {
            return FLOAT;
        }
        if (clazz == Double.class) {
            return DOUBLE;
        }
        if (clazz == Boolean.class) {
            return BOOLEAN;
        }
        if (clazz == String.class) {
            int esize = info.getElementSize();
            return esize > 0 ? new FixedStringCodec(esize) : new VariableStringCodec();
        }
        if (clazz == String[].class) {
            return new StringArrayCodec();
        }
        if (clazz.isArray()) {
            int[] shape = info.getShape();
            int nel = 1;
            boolean isFixed = true;
            for (int i = 0; i < shape.length; ++i) {
                nel *= shape[i];
                if (shape[i] > 0) continue;
                isFixed = false;
            }
            Codec1 codec1 = null;
            if (clazz == byte[].class) {
                codec1 = new ByteCodec1();
            } else if (clazz == short[].class) {
                codec1 = new ShortCodec1();
            } else if (clazz == int[].class) {
                codec1 = new IntCodec1();
            } else if (clazz == long[].class) {
                codec1 = new LongCodec1();
            } else if (clazz == char[].class) {
                codec1 = new CharCodec1();
            } else if (clazz == float[].class) {
                codec1 = new FloatCodec1();
            } else if (clazz == double[].class) {
                codec1 = new DoubleCodec1();
            } else if (clazz == boolean[].class) {
                codec1 = new BooleanCodec1();
            }
            if (codec1 != null) {
                return isFixed ? new FlaggedCodec(new FixedArrayCodec(codec1, nel)) : new VariableArrayCodec(codec1);
            }
        }
        logger_.info("No codec available for class " + clazz.getName());
        return null;
    }

    protected void warnCorrupt() {
        if (++this.warnings_ <= 3) {
            logger_.warning("Unexpected stream data - table raw data stream is probably corrupt");
            if (this.warnings_ == 3) {
                logger_.warning("... more");
            }
        }
    }

    private static class BooleanCodec1
    extends Codec1 {
        private BooleanCodec1() {
        }

        @Override
        public void encode1(Object array, int index, DataOutput out) throws IOException {
            out.writeByte(((boolean[])array)[index] ? 84 : 70);
        }

        @Override
        public void decode1(Object array, int index, ByteStoreAccess in) throws IOException {
            boolean bval;
            switch (in.readByte()) {
                case 84: {
                    bval = true;
                    break;
                }
                case 70: {
                    bval = false;
                    break;
                }
                default: {
                    bval = false;
                    this.warnCorrupt();
                }
            }
            ((boolean[])array)[index] = bval;
        }

        @Override
        public int getItemSize1() {
            return 1;
        }

        @Override
        public Object getBuffer(int size) {
            return new boolean[size];
        }
    }

    private static class CharCodec1
    extends Codec1 {
        private CharCodec1() {
        }

        @Override
        public void encode1(Object array, int index, DataOutput out) throws IOException {
            out.writeChar(((char[])array)[index]);
        }

        @Override
        public void decode1(Object array, int index, ByteStoreAccess in) throws IOException {
            ((char[])array)[index] = in.readChar();
        }

        @Override
        public int getItemSize1() {
            return 2;
        }

        @Override
        public Object getBuffer(int size) {
            return new char[size];
        }
    }

    private static class DoubleCodec1
    extends Codec1 {
        private DoubleCodec1() {
        }

        @Override
        public void encode1(Object array, int index, DataOutput out) throws IOException {
            out.writeDouble(((double[])array)[index]);
        }

        @Override
        public void decode1(Object array, int index, ByteStoreAccess in) throws IOException {
            ((double[])array)[index] = in.readDouble();
        }

        @Override
        public int getItemSize1() {
            return 8;
        }

        @Override
        public Object getBuffer(int size) {
            return new double[size];
        }
    }

    private static class FloatCodec1
    extends Codec1 {
        private FloatCodec1() {
        }

        @Override
        public void encode1(Object array, int index, DataOutput out) throws IOException {
            out.writeFloat(((float[])array)[index]);
        }

        @Override
        public void decode1(Object array, int index, ByteStoreAccess in) throws IOException {
            ((float[])array)[index] = in.readFloat();
        }

        @Override
        public int getItemSize1() {
            return 4;
        }

        @Override
        public Object getBuffer(int size) {
            return new float[size];
        }
    }

    private static class LongCodec1
    extends Codec1 {
        private LongCodec1() {
        }

        @Override
        public void encode1(Object array, int index, DataOutput out) throws IOException {
            out.writeLong(((long[])array)[index]);
        }

        @Override
        public void decode1(Object array, int index, ByteStoreAccess in) throws IOException {
            ((long[])array)[index] = in.readLong();
        }

        @Override
        public int getItemSize1() {
            return 8;
        }

        @Override
        public Object getBuffer(int size) {
            return new long[size];
        }
    }

    private static class IntCodec1
    extends Codec1 {
        private IntCodec1() {
        }

        @Override
        public void encode1(Object array, int index, DataOutput out) throws IOException {
            out.writeInt(((int[])array)[index]);
        }

        @Override
        public void decode1(Object array, int index, ByteStoreAccess in) throws IOException {
            ((int[])array)[index] = in.readInt();
        }

        @Override
        public int getItemSize1() {
            return 4;
        }

        @Override
        public Object getBuffer(int size) {
            return new int[size];
        }
    }

    private static class ShortCodec1
    extends Codec1 {
        private ShortCodec1() {
        }

        @Override
        public void encode1(Object array, int index, DataOutput out) throws IOException {
            out.writeShort(((short[])array)[index]);
        }

        @Override
        public void decode1(Object array, int index, ByteStoreAccess in) throws IOException {
            ((short[])array)[index] = in.readShort();
        }

        @Override
        public int getItemSize1() {
            return 2;
        }

        @Override
        public Object getBuffer(int size) {
            return new short[size];
        }
    }

    private static class ByteCodec1
    extends Codec1 {
        private ByteCodec1() {
        }

        @Override
        public void encode1(Object array, int index, DataOutput out) throws IOException {
            out.writeByte(((byte[])array)[index]);
        }

        @Override
        public void decode1(Object array, int index, ByteStoreAccess in) throws IOException {
            ((byte[])array)[index] = in.readByte();
        }

        @Override
        public int getItemSize1() {
            return 1;
        }

        @Override
        public Object getBuffer(int size) {
            return new byte[size];
        }
    }

    private static abstract class Codec1 {
        private volatile int warnings_;

        private Codec1() {
        }

        abstract void encode1(Object var1, int var2, DataOutput var3) throws IOException;

        abstract void decode1(Object var1, int var2, ByteStoreAccess var3) throws IOException;

        abstract Object getBuffer(int var1);

        abstract int getItemSize1();

        protected void warnCorrupt() {
            if (++this.warnings_ <= 3) {
                logger_.warning("Unexpected stream data - table raw data stream is probably corrupt");
                if (this.warnings_ == 3) {
                    logger_.warning("... more");
                }
            }
        }
    }

    private static class StringArrayCodec
    extends ObjectCodec {
        private StringArrayCodec() {
        }

        @Override
        public int encode(Object value, DataOutput out) throws IOException {
            int count = 0;
            String[] strings = value == null ? new String[]{} : (String[])value;
            int nstr = strings.length;
            out.writeInt(nstr);
            count += 4;
            for (int is = 0; is < nstr; ++is) {
                String str = strings[is] == null ? "" : strings[is];
                int leng = str.length();
                out.writeInt(leng);
                count += 4;
                for (int ic = 0; ic < leng; ++ic) {
                    out.writeChar(str.charAt(ic));
                    count += 2;
                }
            }
            return count;
        }

        @Override
        public Object decodeObject(ByteStoreAccess in) throws IOException {
            int nstr = in.readInt();
            if (nstr < 0) {
                this.warnCorrupt();
                return null;
            }
            String[] strings = new String[nstr];
            for (int is = 0; is < nstr; ++is) {
                int leng = in.readInt();
                if (leng < 0) {
                    this.warnCorrupt();
                    return null;
                }
                if (leng == 0) {
                    strings[is] = null;
                    continue;
                }
                char[] chrs = new char[leng];
                for (int ic = 0; ic < leng; ++ic) {
                    chrs[ic] = in.readChar();
                }
                strings[is] = new String(chrs);
            }
            return strings;
        }

        @Override
        public int getItemSize() {
            return -1;
        }
    }

    private static class VariableStringCodec
    extends VariableArrayCodec {
        VariableStringCodec() {
            super(new CharCodec1());
        }

        @Override
        public int encode(Object value, DataOutput out) throws IOException {
            char[] cval = value == null ? null : ((String)value).toCharArray();
            return super.encode(cval, out);
        }

        @Override
        public Object decodeObject(ByteStoreAccess in) throws IOException {
            char[] cval = (char[])super.decodeObject(in);
            return cval == null ? null : new String(cval);
        }
    }

    private static class FixedStringCodec
    extends ObjectCodec {
        final int nchar_;

        FixedStringCodec(int nchar) {
            this.nchar_ = nchar;
        }

        @Override
        public int encode(Object value, DataOutput out) throws IOException {
            int ic;
            String sval = (String)value;
            if (sval != null) {
                int leng = sval.length();
                for (ic = 0; ic < this.nchar_ && ic < leng; ++ic) {
                    out.writeChar(sval.charAt(ic));
                }
            }
            while (ic < this.nchar_) {
                out.writeChar(0);
                ++ic;
            }
            return this.nchar_ * 2;
        }

        @Override
        public Object decodeObject(ByteStoreAccess in) throws IOException {
            int lastNonZero = -1;
            char[] cbuf = new char[this.nchar_];
            for (int ic = 0; ic < this.nchar_; ++ic) {
                char c = in.readChar();
                if (c != '\u0000') {
                    lastNonZero = ic;
                }
                cbuf[ic] = c;
            }
            return lastNonZero < 0 ? null : new String(cbuf, 0, lastNonZero + 1);
        }

        @Override
        public int getItemSize() {
            return this.nchar_ * 2;
        }
    }

    private static class VariableArrayCodec
    extends ObjectCodec {
        final Codec1 codec1_;

        VariableArrayCodec(Codec1 codec1) {
            this.codec1_ = codec1;
        }

        @Override
        public int encode(Object value, DataOutput out) throws IOException {
            int nel = value == null ? 0 : Array.getLength(value);
            out.writeInt(nel);
            for (int i = 0; i < nel; ++i) {
                this.codec1_.encode1(value, i, out);
            }
            return 4 + nel * this.codec1_.getItemSize1();
        }

        @Override
        public Object decodeObject(ByteStoreAccess in) throws IOException {
            int nel = in.readInt();
            if (nel < 0) {
                this.warnCorrupt();
                return null;
            }
            if (nel == 0) {
                return null;
            }
            Object value = this.codec1_.getBuffer(nel);
            for (int i = 0; i < nel; ++i) {
                this.codec1_.decode1(value, i, in);
            }
            return value;
        }

        @Override
        public int getItemSize() {
            return -1;
        }
    }

    private static class FixedArrayCodec
    extends ObjectCodec {
        final int nel_;
        final Codec1 codec1_;
        final int itemSize_;

        FixedArrayCodec(Codec1 codec1, int nel) {
            this.codec1_ = codec1;
            this.nel_ = nel;
            this.itemSize_ = nel * codec1.getItemSize1();
        }

        @Override
        public int encode(Object value, DataOutput out) throws IOException {
            for (int i = 0; i < this.nel_; ++i) {
                this.codec1_.encode1(value, i, out);
            }
            return this.itemSize_;
        }

        @Override
        public Object decodeObject(ByteStoreAccess in) throws IOException {
            Object value = this.codec1_.getBuffer(this.nel_);
            for (int i = 0; i < this.nel_; ++i) {
                this.codec1_.decode1(value, i, in);
            }
            return value;
        }

        @Override
        public int getItemSize() {
            return this.itemSize_;
        }
    }

    private static abstract class ObjectCodec
    extends Codec {
        private ObjectCodec() {
        }

        @Override
        public int decodeInt(ByteStoreAccess in) throws IOException {
            this.decodeObject(in);
            return 0;
        }

        @Override
        public long decodeLong(ByteStoreAccess in) throws IOException {
            this.decodeObject(in);
            return 0L;
        }

        @Override
        public double decodeDouble(ByteStoreAccess in) throws IOException {
            this.decodeObject(in);
            return Double.NaN;
        }

        @Override
        public boolean decodeBoolean(ByteStoreAccess in) throws IOException {
            this.decodeObject(in);
            return false;
        }
    }

    private static class FlaggedCodec
    extends Codec {
        Codec baseCodec_;
        int itemSize_;
        byte[] nullBuffer_;
        static final byte BAD = -1;
        static final byte OK = 0;

        FlaggedCodec(Codec baseCodec) {
            this.baseCodec_ = baseCodec;
            this.itemSize_ = baseCodec.getItemSize() + 1;
            this.nullBuffer_ = new byte[this.itemSize_];
            this.nullBuffer_[0] = -1;
        }

        @Override
        public int encode(Object value, DataOutput out) throws IOException {
            if (value == null) {
                out.write(this.nullBuffer_);
            } else {
                out.write(0);
                this.baseCodec_.encode(value, out);
            }
            return this.itemSize_;
        }

        @Override
        public Object decodeObject(ByteStoreAccess in) throws IOException {
            byte flag = in.readByte();
            switch (flag) {
                case 0: {
                    return this.baseCodec_.decodeObject(in);
                }
                case -1: {
                    in.skip(this.itemSize_ - 1);
                    return null;
                }
            }
            this.warnCorrupt();
            return null;
        }

        @Override
        public int decodeInt(ByteStoreAccess in) throws IOException {
            byte flag = in.readByte();
            switch (flag) {
                case 0: {
                    return this.baseCodec_.decodeInt(in);
                }
                case -1: {
                    in.skip(this.itemSize_ - 1);
                    return 0;
                }
            }
            this.warnCorrupt();
            return 0;
        }

        @Override
        public long decodeLong(ByteStoreAccess in) throws IOException {
            byte flag = in.readByte();
            switch (flag) {
                case 0: {
                    return this.baseCodec_.decodeLong(in);
                }
                case -1: {
                    in.skip(this.itemSize_ - 1);
                    return 0L;
                }
            }
            this.warnCorrupt();
            return 0L;
        }

        @Override
        public double decodeDouble(ByteStoreAccess in) throws IOException {
            byte flag = in.readByte();
            switch (flag) {
                case 0: {
                    return this.baseCodec_.decodeDouble(in);
                }
                case -1: {
                    in.skip(this.itemSize_ - 1);
                    return Double.NaN;
                }
            }
            this.warnCorrupt();
            return Double.NaN;
        }

        @Override
        public boolean decodeBoolean(ByteStoreAccess in) throws IOException {
            byte flag = in.readByte();
            switch (flag) {
                case 0: {
                    return this.baseCodec_.decodeBoolean(in);
                }
                case -1: {
                    in.skip(this.itemSize_ - 1);
                    return false;
                }
            }
            this.warnCorrupt();
            return false;
        }

        @Override
        public int getItemSize() {
            return this.itemSize_;
        }
    }

    private static class BooleanCodec
    extends Codec {
        private BooleanCodec() {
        }

        @Override
        public int encode(Object value, DataOutput out) throws IOException {
            int brep = value == null ? 32 : ((Boolean)value != false ? 84 : 70);
            out.writeByte(brep);
            return 1;
        }

        @Override
        public Boolean decodeObject(ByteStoreAccess in) throws IOException {
            switch (in.readByte()) {
                case 84: {
                    return Boolean.TRUE;
                }
                case 70: {
                    return Boolean.FALSE;
                }
                case 32: {
                    return null;
                }
            }
            this.warnCorrupt();
            return null;
        }

        @Override
        public int decodeInt(ByteStoreAccess in) throws IOException {
            return this.decodeBoolean(in) ? 1 : 0;
        }

        @Override
        public long decodeLong(ByteStoreAccess in) throws IOException {
            return this.decodeBoolean(in) ? 1L : 0L;
        }

        @Override
        public double decodeDouble(ByteStoreAccess in) throws IOException {
            switch (in.readByte()) {
                case 84: {
                    return 1.0;
                }
                case 70: {
                    return 0.0;
                }
                case 32: {
                    return Double.NaN;
                }
            }
            this.warnCorrupt();
            return Double.NaN;
        }

        @Override
        public boolean decodeBoolean(ByteStoreAccess in) throws IOException {
            return in.readByte() == 84;
        }

        @Override
        public int getItemSize() {
            return 1;
        }
    }

    private static class DoubleCodec
    extends Codec {
        private DoubleCodec() {
        }

        @Override
        public int encode(Object value, DataOutput out) throws IOException {
            out.writeDouble(value == null ? Double.NaN : ((Number)value).doubleValue());
            return 8;
        }

        @Override
        public Object decodeObject(ByteStoreAccess in) throws IOException {
            return in.readDouble();
        }

        @Override
        public int decodeInt(ByteStoreAccess in) throws IOException {
            return (int)in.readDouble();
        }

        @Override
        public long decodeLong(ByteStoreAccess in) throws IOException {
            return (long)in.readDouble();
        }

        @Override
        public double decodeDouble(ByteStoreAccess in) throws IOException {
            return in.readDouble();
        }

        @Override
        public boolean decodeBoolean(ByteStoreAccess in) throws IOException {
            return in.readDouble() != 0.0;
        }

        @Override
        public int getItemSize() {
            return 8;
        }
    }

    private static class FloatCodec
    extends Codec {
        private FloatCodec() {
        }

        @Override
        public int encode(Object value, DataOutput out) throws IOException {
            out.writeFloat(value == null ? Float.NaN : ((Number)value).floatValue());
            return 4;
        }

        @Override
        public Object decodeObject(ByteStoreAccess in) throws IOException {
            return Float.valueOf(in.readFloat());
        }

        @Override
        public int decodeInt(ByteStoreAccess in) throws IOException {
            return (int)in.readFloat();
        }

        @Override
        public long decodeLong(ByteStoreAccess in) throws IOException {
            return (long)in.readFloat();
        }

        @Override
        public double decodeDouble(ByteStoreAccess in) throws IOException {
            return in.readFloat();
        }

        @Override
        public boolean decodeBoolean(ByteStoreAccess in) throws IOException {
            return in.readFloat() != 0.0f;
        }

        @Override
        public int getItemSize() {
            return 4;
        }
    }

    private static class CharCodec
    extends Codec {
        private CharCodec() {
        }

        @Override
        public int encode(Object value, DataOutput out) throws IOException {
            out.writeChar(((Character)value).charValue());
            return 2;
        }

        @Override
        public Object decodeObject(ByteStoreAccess in) throws IOException {
            return Character.valueOf(in.readChar());
        }

        @Override
        public int decodeInt(ByteStoreAccess in) throws IOException {
            return in.readChar();
        }

        @Override
        public long decodeLong(ByteStoreAccess in) throws IOException {
            return in.readChar();
        }

        @Override
        public double decodeDouble(ByteStoreAccess in) throws IOException {
            return in.readChar();
        }

        @Override
        public boolean decodeBoolean(ByteStoreAccess in) throws IOException {
            return in.readChar() != '\u0000';
        }

        @Override
        public int getItemSize() {
            return 2;
        }
    }

    private static class LongCodec
    extends Codec {
        private LongCodec() {
        }

        @Override
        public int encode(Object value, DataOutput out) throws IOException {
            out.writeLong(((Number)value).longValue());
            return 8;
        }

        @Override
        public Object decodeObject(ByteStoreAccess in) throws IOException {
            return in.readLong();
        }

        @Override
        public int decodeInt(ByteStoreAccess in) throws IOException {
            return (int)in.readLong();
        }

        @Override
        public long decodeLong(ByteStoreAccess in) throws IOException {
            return in.readLong();
        }

        @Override
        public double decodeDouble(ByteStoreAccess in) throws IOException {
            return in.readLong();
        }

        @Override
        public boolean decodeBoolean(ByteStoreAccess in) throws IOException {
            return in.readLong() != 0L;
        }

        @Override
        public int getItemSize() {
            return 8;
        }
    }

    private static class IntCodec
    extends Codec {
        private IntCodec() {
        }

        @Override
        public int encode(Object value, DataOutput out) throws IOException {
            out.writeInt(((Number)value).intValue());
            return 4;
        }

        @Override
        public Object decodeObject(ByteStoreAccess in) throws IOException {
            return in.readInt();
        }

        @Override
        public int decodeInt(ByteStoreAccess in) throws IOException {
            return in.readInt();
        }

        @Override
        public long decodeLong(ByteStoreAccess in) throws IOException {
            return in.readInt();
        }

        @Override
        public double decodeDouble(ByteStoreAccess in) throws IOException {
            return in.readInt();
        }

        @Override
        public boolean decodeBoolean(ByteStoreAccess in) throws IOException {
            return in.readInt() != 0;
        }

        @Override
        public int getItemSize() {
            return 4;
        }
    }

    private static class ShortCodec
    extends Codec {
        private ShortCodec() {
        }

        @Override
        public int encode(Object value, DataOutput out) throws IOException {
            out.writeShort(((Number)value).shortValue());
            return 2;
        }

        @Override
        public Object decodeObject(ByteStoreAccess in) throws IOException {
            return in.readShort();
        }

        @Override
        public int decodeInt(ByteStoreAccess in) throws IOException {
            return in.readShort();
        }

        @Override
        public long decodeLong(ByteStoreAccess in) throws IOException {
            return in.readShort();
        }

        @Override
        public double decodeDouble(ByteStoreAccess in) throws IOException {
            return in.readShort();
        }

        @Override
        public boolean decodeBoolean(ByteStoreAccess in) throws IOException {
            return in.readShort() != 0;
        }

        @Override
        public int getItemSize() {
            return 2;
        }
    }

    private static class ByteCodec
    extends Codec {
        private ByteCodec() {
        }

        @Override
        public int encode(Object value, DataOutput out) throws IOException {
            out.writeByte(((Number)value).byteValue());
            return 1;
        }

        @Override
        public Object decodeObject(ByteStoreAccess in) throws IOException {
            return in.readByte();
        }

        @Override
        public int decodeInt(ByteStoreAccess in) throws IOException {
            return in.readByte();
        }

        @Override
        public long decodeLong(ByteStoreAccess in) throws IOException {
            return in.readByte();
        }

        @Override
        public double decodeDouble(ByteStoreAccess in) throws IOException {
            return in.readByte();
        }

        @Override
        public boolean decodeBoolean(ByteStoreAccess in) throws IOException {
            return in.readByte() != 0;
        }

        @Override
        public int getItemSize() {
            return 1;
        }
    }
}

